/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.services.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.RemoteException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import moos.ssds.io.PacketInput;
import moos.ssds.services.data.util.DataException;
import moos.ssds.transmogrify.SSDSDevicePacket;
import org.apache.log4j.Logger;

public class DataStreamRawDataAccessEJB
implements SessionBean {
    static Logger logger = Logger.getLogger(DataStreamRawDataAccessEJB.class);
    private Properties ingestProps;
    private File rawPacketDirectory = null;
    public static final String BY_SEQUENCE_NUMBER = "sequenceNumber";
    public static final String BY_TIMESTAMP = "timestamp";

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }

    public void ejbRemove() throws EJBException, RemoteException {
    }

    public void setSessionContext(SessionContext sessionContext) throws EJBException, RemoteException {
    }

    public void ejbCreate() throws CreateException {
        this.ingestProps = new Properties();
        try {
            this.ingestProps.load(this.getClass().getResourceAsStream("/moos/ssds/io/io.properties"));
        }
        catch (Exception exception) {
            logger.error("Exception trying to read in properties file: " + exception.getMessage());
        }
        this.rawPacketDirectory = new File(this.ingestProps.getProperty("io.storage.directory"));
    }

    public void ejbPostCreate() throws CreateException {
    }

    public Object[] getRawData(Long l, Long l2, Long l3, Long l4, Calendar calendar, Calendar calendar2, String string, boolean bl, boolean bl2, boolean bl3, ArrayList arrayList, ArrayList arrayList2) {
        arrayList = new ArrayList();
        arrayList2 = new ArrayList();
        boolean bl4 = false;
        int n = 0;
        File[] fileArray = null;
        if (this.rawPacketDirectory.exists() && (fileArray = this.rawPacketDirectory.listFiles(new RawDataFileFilter(l, l2, l3, l4, calendar.getTimeInMillis()))) != null && fileArray.length > 0) {
            bl4 = true;
            n = fileArray.length;
        }
        URL[] uRLArray = null;
        if (!bl4 && (uRLArray = this.listURLs(l, l2, l3, l4, calendar.getTimeInMillis())) != null) {
            n = uRLArray.length;
        }
        AbstractMap abstractMap = null;
        if (bl && bl2) {
            abstractMap = new TreeMap();
        } else if (!bl && bl2) {
            abstractMap = new HashMap();
        }
        for (int i = 0; i < n; ++i) {
            PacketInput packetInput = null;
            try {
                packetInput = bl4 ? new PacketInput(fileArray[i]) : new PacketInput(uRLArray[i]);
            }
            catch (IOException iOException) {
                logger.error("Could not open packetInput to the raw data files: " + iOException.getMessage());
                iOException.printStackTrace();
            }
            if (bl2) {
                this.readFromPacketInputIntoMap(packetInput, calendar, calendar2, string, bl3, abstractMap);
                continue;
            }
            this.readFromPacketInputIntoArrayLists(packetInput, calendar, calendar2, string, bl3, arrayList, arrayList2);
        }
        if (bl2) {
            arrayList = new ArrayList(abstractMap.keySet());
            arrayList2 = new ArrayList(abstractMap.values());
            Object[] objectArray = new Object[]{arrayList, arrayList2};
            return objectArray;
        }
        if (!bl2) {
            if (!bl) {
                Object[] objectArray = new Object[]{arrayList, arrayList2};
                return objectArray;
            }
            if (bl) {
                // empty if block
            }
        }
        return null;
    }

    private URL[] listURLs(Long l, Long l2, Long l3, Long l4, long l5) {
        String string;
        if (l == null) {
            return null;
        }
        String string2 = null;
        string2 = l2 == null ? "\\d+" : l2.toString();
        String string3 = null;
        string3 = l3 == null ? "\\d+" : l3.toString();
        String string4 = null;
        string4 = l4 == null ? "\\d+" : l4.toString();
        URL[] uRLArray = null;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        URL uRL = null;
        try {
            uRL = new URL(this.ingestProps.getProperty("io.storage.directory.url"));
        }
        catch (MalformedURLException malformedURLException) {
            logger.error("Could not do new on URL: " + malformedURLException.getMessage());
            return null;
        }
        BufferedReader bufferedReader = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            string = null;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        string = stringBuffer.toString();
        String string5 = null;
        String string6 = null;
        if (string.indexOf("<a href=") >= 0) {
            string5 = new String("<a href=");
            string6 = new String("</a>");
        } else if (string.indexOf("<a HREF=") >= 0) {
            string5 = new String("<a HREF=");
            string6 = new String("</a>");
        } else if (string.indexOf("<A HREF=") >= 0) {
            string5 = new String("<A HREF=");
            string6 = new String("</A>");
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        while (string != null && string5 != null && string6 != null) {
            int n = string.indexOf(string5);
            if (n < 0) {
                string = null;
                continue;
            }
            int n2 = string.indexOf(">", n);
            if (n2 >= 0) {
                int n3 = string.indexOf(string6, n2);
                if (n3 > 0) {
                    String string7 = string.substring(n2 + 1, n3);
                    if (string7 != null) {
                        arrayList2.add(string7);
                    }
                    string = string.substring(n3);
                    continue;
                }
                string = null;
                continue;
            }
            string = null;
        }
        Pattern pattern = Pattern.compile(new String(l + "_" + string2 + "_" + string3 + "_" + string4));
        Matcher matcher = null;
        for (String string7 : arrayList2) {
            matcher = pattern.matcher(string7);
            if (!matcher.find()) continue;
            URL uRL2 = null;
            try {
                uRL2 = new URL(this.ingestProps.getProperty("io.storage.directory.url") + "/" + string7);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            if (uRL2 == null) continue;
            URLConnection uRLConnection = null;
            try {
                uRLConnection = uRL2.openConnection();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (uRLConnection == null || uRLConnection.getLastModified() <= l5) continue;
            arrayList.add(uRL2);
        }
        uRLArray = arrayList.toArray(new URL[arrayList.size()]);
        return uRLArray;
    }

    private void readFromPacketInputIntoMap(PacketInput packetInput, Calendar calendar, Calendar calendar2, String string, boolean bl, Map map) {
        while (packetInput.hasMoreElements()) {
            long l;
            SSDSDevicePacket sSDSDevicePacket = null;
            try {
                sSDSDevicePacket = (SSDSDevicePacket)packetInput.nextElement();
            }
            catch (Exception exception) {
                logger.debug("Exception caught trying to read next packet element " + exception.getMessage());
            }
            if (sSDSDevicePacket == null || (l = sSDSDevicePacket.systemTime()) < calendar.getTimeInMillis() || l > calendar2.getTimeInMillis()) continue;
            if (string.equalsIgnoreCase(BY_SEQUENCE_NUMBER)) {
                if (bl) {
                    map.put(new Long(sSDSDevicePacket.sequenceNo()), sSDSDevicePacket);
                    continue;
                }
                map.put(new Long(sSDSDevicePacket.sequenceNo()), sSDSDevicePacket.getDataBuffer());
                continue;
            }
            if (bl) {
                map.put(new Long(l), sSDSDevicePacket);
                continue;
            }
            map.put(new Long(l), sSDSDevicePacket.getDataBuffer());
        }
    }

    private void readFromPacketInputIntoArrayLists(PacketInput packetInput, Calendar calendar, Calendar calendar2, String string, boolean bl, ArrayList arrayList, ArrayList arrayList2) {
        while (packetInput.hasMoreElements()) {
            long l;
            SSDSDevicePacket sSDSDevicePacket = null;
            try {
                sSDSDevicePacket = (SSDSDevicePacket)packetInput.nextElement();
            }
            catch (Exception exception) {
                logger.debug("Exception caught trying to read next packet element " + exception.getMessage());
            }
            if (sSDSDevicePacket == null || (l = sSDSDevicePacket.systemTime()) < calendar.getTimeInMillis() || l > calendar2.getTimeInMillis()) continue;
            if (string.equalsIgnoreCase(BY_SEQUENCE_NUMBER)) {
                if (bl) {
                    arrayList.add(new Long(sSDSDevicePacket.sequenceNo()));
                    arrayList2.add(sSDSDevicePacket);
                    continue;
                }
                arrayList.add(new Long(sSDSDevicePacket.sequenceNo()));
                arrayList2.add(sSDSDevicePacket.getDataBuffer());
                continue;
            }
            if (bl) {
                arrayList.add(new Long(l));
                arrayList2.add(sSDSDevicePacket);
                continue;
            }
            arrayList.add(new Long(l));
            arrayList2.add(sSDSDevicePacket.getDataBuffer());
        }
    }

    public TreeMap getSortedRawData(long l, Calendar calendar, Calendar calendar2, boolean bl) throws DataException {
        return this.getSortedRawData(l, calendar, calendar2, bl, false);
    }

    public TreeMap getSortedRawData(long l, Calendar calendar, Calendar calendar2, boolean bl, boolean bl2) throws DataException {
        TreeMap treeMap = new TreeMap();
        File file = new File(this.ingestProps.getProperty("io.storage.directory"));
        File[] fileArray = file.listFiles();
        if (file.exists() && fileArray != null && fileArray.length > 3) {
            File[] fileArray2 = file.listFiles(new SIAMRawDataFileFilter(l, calendar.getTimeInMillis()));
            for (int i = 0; i < fileArray2.length; ++i) {
                PacketInput packetInput = null;
                try {
                    packetInput = new PacketInput(fileArray2[i]);
                }
                catch (IOException iOException) {
                    logger.error("Could not open packetInput to the raw data files: " + iOException.getMessage());
                    iOException.printStackTrace();
                }
                this.readFromPacketInput(calendar, calendar2, bl, bl2, treeMap, packetInput);
            }
        } else {
            URL[] uRLArray = null;
            uRLArray = this.listURLs(l, calendar.getTimeInMillis());
            for (int i = 0; i < uRLArray.length; ++i) {
                PacketInput packetInput = null;
                try {
                    packetInput = new PacketInput(uRLArray[i]);
                }
                catch (IOException iOException) {
                    logger.error("Could not open packetInput to the raw data files: " + iOException.getMessage());
                    iOException.printStackTrace();
                }
                this.readFromPacketInput(calendar, calendar2, bl, bl2, treeMap, packetInput);
            }
        }
        return treeMap;
    }

    private void readFromPacketInput(Calendar calendar, Calendar calendar2, boolean bl, boolean bl2, TreeMap treeMap, PacketInput packetInput) {
        while (packetInput.hasMoreElements()) {
            long l;
            SSDSDevicePacket sSDSDevicePacket = null;
            try {
                sSDSDevicePacket = (SSDSDevicePacket)packetInput.nextElement();
            }
            catch (Exception exception) {
                logger.debug("Exception caught trying to read next packet element " + exception.getMessage());
            }
            if (sSDSDevicePacket == null || (l = sSDSDevicePacket.systemTime()) < calendar.getTimeInMillis() || l >= calendar2.getTimeInMillis()) continue;
            if (bl) {
                if (bl2) {
                    treeMap.put(new Long(sSDSDevicePacket.sequenceNo()), sSDSDevicePacket);
                    continue;
                }
                treeMap.put(new Long(sSDSDevicePacket.sequenceNo()), sSDSDevicePacket.getDataBuffer());
                continue;
            }
            if (bl2) {
                treeMap.put(new Long(l), sSDSDevicePacket);
                continue;
            }
            treeMap.put(new Long(l), sSDSDevicePacket.getDataBuffer());
        }
    }

    private URL[] listURLs(long l, long l2) {
        String string;
        URL[] uRLArray = null;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        URL uRL = null;
        try {
            uRL = new URL(this.ingestProps.getProperty("io.storage.directory.url"));
        }
        catch (MalformedURLException malformedURLException) {
            logger.error("Could not do new on URL: " + malformedURLException.getMessage());
        }
        BufferedReader bufferedReader = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            string = null;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        string = stringBuffer.toString();
        String string2 = null;
        String string3 = null;
        if (string.indexOf("<a href=") >= 0) {
            string2 = new String("<a href=");
            string3 = new String("</a>");
        } else if (string.indexOf("<a HREF=") >= 0) {
            string2 = new String("<a HREF=");
            string3 = new String("</a>");
        } else if (string.indexOf("<A HREF=") >= 0) {
            string2 = new String("<A HREF=");
            string3 = new String("</A>");
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        while (string != null && string2 != null && string3 != null) {
            int n = string.indexOf(string2);
            if (n < 0) {
                string = null;
                continue;
            }
            int n2 = string.indexOf(">", n);
            if (n2 >= 0) {
                int n3 = string.indexOf(string3, n2);
                if (n3 > 0) {
                    String string4 = string.substring(n2 + 1, n3);
                    if (string4 != null) {
                        arrayList2.add(string4);
                    }
                    string = string.substring(n3);
                    continue;
                }
                string = null;
                continue;
            }
            string = null;
        }
        Pattern pattern = Pattern.compile(new String(l + "_(\\d+)_(\\d+)_(\\d+)"));
        Matcher matcher = null;
        for (String string4 : arrayList2) {
            matcher = pattern.matcher(string4);
            if (!matcher.find()) continue;
            URL uRL2 = null;
            try {
                uRL2 = new URL(this.ingestProps.getProperty("io.storage.directory.url") + "/" + string4);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            if (uRL2 == null) continue;
            URLConnection uRLConnection = null;
            try {
                uRLConnection = uRL2.openConnection();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (uRLConnection == null || uRLConnection.getLastModified() <= l2) continue;
            arrayList.add(uRL2);
        }
        uRLArray = arrayList.toArray(new URL[arrayList.size()]);
        return uRLArray;
    }

    private class SIAMRawDataFileFilter
    implements FileFilter {
        long startTimeInMillis = 0L;
        long deviceID = 0L;

        public SIAMRawDataFileFilter(long l, long l2) {
            this.startTimeInMillis = l2;
            this.deviceID = l;
        }

        public boolean accept(File file) {
            boolean bl = false;
            String string = file.getName();
            string.trim();
            Object var4_4 = null;
            if (file.lastModified() > this.startTimeInMillis && file.getName().startsWith(this.deviceID + "_")) {
                return true;
            }
            return bl;
        }
    }

    private class RawDataFileFilter
    implements FileFilter {
        long startTimeInMillis = 0L;
        private String deviceIDString = null;
        private String parentIDString = "-*\\d+";
        private String metadataIDString = "\\d+";
        private String recordTypeString = "\\d+";
        private String stringDataPattern = null;
        private Pattern dataPattern = null;

        public RawDataFileFilter(Long l, Long l2, Long l3, Long l4, long l5) {
            if (l != null) {
                this.deviceIDString = l.toString();
            }
            if (l4 != null) {
                this.parentIDString = l4.toString();
            }
            if (l2 != null) {
                this.metadataIDString = l2.toString();
            }
            if (l3 != null) {
                this.recordTypeString = l3.toString();
            }
            this.startTimeInMillis = l5;
            this.stringDataPattern = new String(this.deviceIDString + "_" + this.metadataIDString + "_" + this.recordTypeString + "_" + this.parentIDString + "$");
            try {
                this.dataPattern = Pattern.compile(this.stringDataPattern);
            }
            catch (RuntimeException runtimeException) {
                logger.error("Could not compile pattern " + runtimeException.getMessage());
            }
        }

        public boolean accept(File file) {
            boolean bl = false;
            if (this.deviceIDString == null) {
                return false;
            }
            String string = file.getName();
            string.trim();
            Matcher matcher = this.dataPattern.matcher(string);
            if (file.lastModified() > this.startTimeInMillis && matcher.matches()) {
                return true;
            }
            return bl;
        }
    }
}

