/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.metadata.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import moos.ssds.metadata.DataProducer;
import moos.ssds.util.XmlDateFormat;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Serializer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class XmlBuilder {
    private Document document;
    private Collection rootElements = new ArrayList();
    private Package p;
    private static int objectToElementCount = 0;
    private static final int maxObjectToElementCount = 10000;
    private XmlDateFormat dateFormat = new XmlDateFormat();
    static Logger logger = Logger.getLogger(XmlBuilder.class);
    static Level level = Level.DEBUG;

    public XmlBuilder() {
        logger.setLevel(level);
        Element element = new Element("Metadata");
        this.document = new Document(element);
        this.p = DataProducer.class.getPackage();
        objectToElementCount = 0;
    }

    public void add(Object object) {
        this.rootElements.add(object);
    }

    public void remove(Object object) {
        this.rootElements.remove(object);
    }

    public void addAll(Collection collection) {
        this.rootElements.addAll(collection);
    }

    public void removeAll(Collection collection) {
        this.rootElements.removeAll(collection);
    }

    public Collection getRootElements() {
        return this.rootElements;
    }

    public String toXML() {
        return this.document.toXML();
    }

    public String toFormattedXML() throws IOException, UnsupportedEncodingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Serializer serializer = new Serializer(byteArrayOutputStream, "ISO-8859-1");
        serializer.setIndent(4);
        serializer.setMaxLength(65536);
        serializer.write(this.document);
        return byteArrayOutputStream.toString();
    }

    public String toString() {
        return this.document.toString();
    }

    public Document getDocument() {
        return this.document;
    }

    public void toFile(File file) throws IOException, UnsupportedEncodingException {
        this.toFile(file, "ISO-8859-1");
    }

    public void toFile(File file, String string) throws IOException, UnsupportedEncodingException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        this.print(bufferedOutputStream, string);
        ((OutputStream)bufferedOutputStream).close();
    }

    public void print(OutputStream outputStream, String string) throws IOException, UnsupportedEncodingException {
        Serializer serializer = new Serializer(outputStream, string);
        serializer.setIndent(4);
        serializer.setMaxLength(65536);
        serializer.write(this.document);
    }

    public void print(OutputStream outputStream) throws IOException, UnsupportedEncodingException {
        this.print(outputStream, "ISO-8859-1");
    }

    public void print() throws IOException, UnsupportedEncodingException {
        this.print(System.out);
    }

    public void marshal() {
        this.document.getRootElement().removeChildren();
        Element element = null;
        Object var2_22 = null;
        for (Object var2_22 : this.rootElements) {
            if (var2_22 == null) continue;
            try {
                element = this.objectToElement(var2_22);
                if (element == null || this.isEmptyElement(element)) continue;
                this.document.getRootElement().appendChild(element);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.deepSortChildrenElements(this.document.getRootElement());
    }

    private Element objectToElement(Object object) {
        logger.debug("Converting " + object.getClass().getName() + "(" + object + ") to XML");
        if (++objectToElementCount > 10000) {
            logger.warn("*** Called objectToElement " + objectToElementCount + " times.  Possible recursion in model with object " + object.getClass().getName());
        }
        Element element = null;
        Class<?> clazz = object.getClass();
        if (this.isClassInMetadataPackage(clazz)) {
            element = this.makeEmptyElement(object);
            Method[] methodArray = clazz.getMethods();
            Method method = null;
            for (int i = 0; i < methodArray.length; ++i) {
                method = methodArray[i];
                if (this.isMethodToSkip(method)) continue;
                if (method.getReturnType() == Collection.class) {
                    this.appendCollection(object, method, element);
                    continue;
                }
                this.appendElement(object, method, element);
            }
        }
        return element;
    }

    private boolean isClassInMetadataPackage(Class clazz) {
        boolean bl = false;
        try {
            bl = clazz.getPackage().equals(this.p);
        }
        catch (Exception exception) {
            logger.error("isPackageLocal(): Exception trying to getPackage() from class " + clazz.getClass().getName());
            bl = false;
        }
        return bl;
    }

    private Element makeEmptyElement(Object object) {
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        int n = string.lastIndexOf(".");
        string = string.substring(n + 1);
        return new Element(string);
    }

    private void appendCollection(Object object, Method method, Element object2) {
        Element element;
        Object object3;
        Object object4;
        Object object5 = this.getChildObject(object, method);
        Collection collection = (Collection)object5;
        String string = method.getName();
        if (string.equals("getInputs") || string.equals("getOutputs")) {
            if (!collection.isEmpty()) {
                object4 = new StringBuffer(this.getParameterName(method));
                ((StringBuffer)object4).setCharAt(0, Character.toLowerCase(((StringBuffer)object4).charAt(0)));
                object3 = ((StringBuffer)object4).substring(0, ((StringBuffer)object4).length() - 1);
                element = new Element((String)object3);
                ((ParentNode)object2).appendChild(element);
                object2 = element;
            }
        } else if (string.equals("getConsumers") && !collection.isEmpty()) {
            object4 = new Element("consumer");
            ((ParentNode)object2).appendChild((Node)object4);
            object2 = object4;
        }
        object4 = null;
        if (collection != null && !collection.isEmpty()) {
            object3 = collection.iterator();
            element = null;
            while (object3.hasNext()) {
                element = (Element)object3.next();
                if (element == null || this.isEmptyElement((Element)(object4 = this.objectToElement(element)))) continue;
                ((ParentNode)object2).appendChild((Node)object4);
            }
        }
    }

    private Object getChildObject(Object object, Method method) {
        Object object2 = null;
        try {
            object2 = method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return object2;
    }

    private String getParameterName(Method method) {
        String string = method.getName();
        String string2 = "";
        if (string.startsWith("get")) {
            string2 = string.substring(3);
        } else if (string.startsWith("is")) {
            string2 = string.substring(2);
        }
        return string2;
    }

    private void appendElement(Object object, Method method, Element element) {
        if (this.isAttributeType(method)) {
            this.appendPrimitiveType(object, method, element);
        } else if (this.isSpecialMethod(method)) {
            this.appendSpecial(object, method, element);
        } else {
            this.appendObject(object, method, element);
        }
    }

    private boolean isAttributeType(Method method) {
        boolean bl = false;
        Class<?> clazz = method.getReturnType();
        if (clazz.isPrimitive() || clazz.equals(String.class) || clazz.equals(Boolean.class) || clazz.equals(Character.class) || clazz.equals(Byte.class) || clazz.equals(Short.class) || clazz.equals(Integer.class) || clazz.equals(Long.class) || clazz.equals(Float.class) || clazz.equals(Double.class)) {
            bl = true;
        }
        return bl;
    }

    private void appendPrimitiveType(Object object, Method method, Element element) {
        logger.debug("appendPrimitiveType called with method name " + method.getName() + " on object of class " + object.getClass().getName());
        Object object2 = this.getChildObject(object, method);
        if (object2 != null) {
            StringBuffer stringBuffer = new StringBuffer(this.getParameterName(method));
            stringBuffer.setCharAt(0, Character.toLowerCase(stringBuffer.charAt(0)));
            String string = stringBuffer.toString();
            String string2 = String.valueOf(object2);
            if (!string2.equals("") && !string2.equals("NaN")) {
                if (string.equals("description")) {
                    Element element2 = new Element("description");
                    element2.appendChild(string2);
                    element.appendChild(element2);
                } else {
                    Attribute attribute = new Attribute(string, string2);
                    element.addAttribute(attribute);
                }
            }
        }
    }

    private boolean isSpecialMethod(Method method) {
        boolean bl = false;
        String string = method.getName();
        if (string.equals("getStartDate") || string.equals("getEndDate") || string.equals("getUrl") || string.equals("getUri") || string.equals("getDODSUrl")) {
            bl = true;
        }
        return bl;
    }

    private void appendSpecial(Object object, Method method, Element element) {
        String string = method.getName();
        Object object2 = this.getChildObject(object, method);
        if (object2 != null) {
            StringBuffer stringBuffer = new StringBuffer(this.getParameterName(method));
            stringBuffer.setCharAt(0, Character.toLowerCase(stringBuffer.charAt(0)));
            String string2 = stringBuffer.toString();
            String string3 = null;
            Attribute attribute = null;
            if (string.equals("getStartDate") || string.equals("getEndDate")) {
                string3 = this.dateFormat.format((Date)object2);
            } else if (string.equals("getUrl") || string.equals("getDODSUrl")) {
                string3 = ((URL)object2).toString();
            } else if (string.equals("getUri")) {
                string3 = ((URI)object2).toString();
            }
            attribute = new Attribute(string2, string3);
            element.addAttribute(attribute);
        }
    }

    private void appendObject(Object object, Method method, Element element) {
        Element element2;
        Object object2 = this.getChildObject(object, method);
        if (object2 != null && (element2 = this.objectToElement(object2)) != null && !this.isEmptyElement(element2)) {
            element.appendChild(element2);
        }
    }

    private boolean isEmptyElement(Element element) {
        boolean bl = true;
        if (element != null && (element.getChildCount() > 0 || element.getAttributeCount() > 0)) {
            bl = false;
        }
        return bl;
    }

    private boolean isMethodToSkip(Method method) {
        boolean bl = false;
        String string = method.getName();
        if (string.equals("getCreator") || string.equals("getDateRange") || string.equals("getUrl") || string.equals("getUriString") || string.equals("getParentDataProducer") || string.equals("getVersion") || !string.startsWith("get") && !string.startsWith("is") || string.equals("equals") || string.equals("hashCode")) {
            bl = true;
        }
        return bl;
    }

    private void deepSortChildrenElements(Element element) {
        Elements elements = element.getChildElements();
        for (int i = 0; i < elements.size(); ++i) {
            elements = element.getChildElements();
            Element element2 = elements.get(i);
            for (int j = 0; j < i; ++j) {
                String string = element2.getLocalName();
                string = string.toLowerCase();
                String string2 = elements.get(j).getLocalName();
                if (string.compareTo(string2 = string2.toLowerCase()) >= 0) continue;
                Node node = element.removeChild(i);
                node.detach();
                Node node2 = element.removeChild(j);
                node2.detach();
                element.insertChild(node, j);
                element.insertChild(node2, i);
                break;
            }
            this.deepSortChildrenElements(elements.get(i));
        }
    }
}

