/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.metadata.util;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import moos.ssds.metadata.DataContainer;
import moos.ssds.metadata.DataProducer;
import moos.ssds.util.XmlDateFormat;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.ValidityException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ObjectBuilder {
    Builder parser;
    private static String modelPackage = "moos.ssds.metadata";
    private Map objects = new HashMap();
    private URL url;
    private XmlDateFormat dateFormat = new XmlDateFormat();
    private boolean xmlInStringFormat = false;
    private String xmlDocument = null;
    private boolean buildFailed = false;
    private StringBuffer errorMessageBuffer = new StringBuffer();
    static Logger logger = Logger.getLogger(ObjectBuilder.class);
    private static Level level = Level.DEBUG;

    public ObjectBuilder(URL uRL) {
        this.url = uRL;
        this.xmlInStringFormat = false;
        logger.setLevel(level);
        logger.debug("ObjectBuilder constructor called with URL = " + uRL.toString());
    }

    public ObjectBuilder(String string) {
        this.xmlDocument = string;
        this.xmlInStringFormat = true;
    }

    public void unmarshal() {
        try {
            this.unmarshal(false);
        }
        catch (ValidityException validityException) {
            validityException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void unmarshal(boolean bl) throws ValidityException, Exception {
        logger.debug("Unmarshal called");
        try {
            this.parser = new Builder(bl);
        }
        catch (Exception exception) {
            logger.error("Exception caught while trying to create an XOM Builder:" + exception.getMessage());
        }
        if (this.xmlInStringFormat) {
            try {
                this.xmlToObjects(null);
            }
            catch (Exception exception) {
                logger.error("Exception caught while trying to convert XML to objects: " + exception.getMessage());
            }
        } else {
            try {
                logger.debug("Unmarshal called");
                this.xmlToObjects(this.url.toExternalForm());
            }
            catch (Exception exception) {
                logger.error("Exception caught while trying to convert XML to objects:" + exception.getMessage());
                this.errorMessageBuffer.append("Exception caught while trying to convert XML to objects:" + exception.getMessage());
                this.buildFailed = true;
            }
        }
    }

    public boolean didUnmarshalFail() {
        return this.buildFailed;
    }

    public String getErrorMessage() {
        return this.errorMessageBuffer.toString();
    }

    private void xmlToObjects(String string) throws Exception {
        logger.debug("xmlToObjects called with xml string " + string);
        Document document = null;
        try {
            document = this.xmlInStringFormat ? this.parser.build(this.xmlDocument, null) : this.parser.build(string);
        }
        catch (ValidityException validityException) {
            logger.error(this.getClass().getName() + ": " + string + " is not a valid XML document.  Validation errors:");
            for (int i = 0; i < validityException.getErrorCount(); ++i) {
                logger.error("line " + validityException.getLineNumber(i) + ": " + validityException.getValidityError(i));
            }
        }
        catch (ParsingException parsingException) {
            logger.error(this.getClass().getName() + ": Unable to parse" + string + ".");
        }
        catch (IOException iOException) {
            logger.error(this.getClass().getName() + ": Unable to open" + string + ". Exception cause is" + iOException.getMessage());
        }
        if (document != null) {
            Element element = document.getRootElement();
            logger.debug("Root element's localName is " + element.getLocalName());
            Elements elements = element.getChildElements();
            int n = elements.size();
            logger.debug("There are " + n + " child elements.");
            Object object = null;
            Class<?> clazz = null;
            boolean bl = false;
            Collection<Object> collection = null;
            for (int i = 0; i < n; ++i) {
                object = this.elementToObject(elements.get(i));
                clazz = object.getClass();
                bl = this.objects.keySet().contains(clazz);
                if (!bl) {
                    collection = new ArrayList();
                    this.objects.put(clazz, collection);
                }
                collection = (Collection)this.objects.get(clazz);
                collection.add(object);
            }
        }
    }

    private Object elementToObject(Element element) throws Exception, IllegalAccessException, ClassNotFoundException, InstantiationException {
        Attribute attribute;
        Node node;
        Object object;
        String string = element.getLocalName();
        logger.debug("elementToObject called with element with localName " + string);
        if (string.equalsIgnoreCase("device") && element.getAttribute("type") != null) {
            object = element.getAttribute("type");
            element.removeAttribute((Attribute)object);
            node = new Element("DeviceType");
            attribute = new Attribute("name", ((Attribute)object).getValue());
            node.addAttribute(attribute);
            element.appendChild(node);
        }
        if (string.equalsIgnoreCase("resource") && (element.getAttribute("type") != null || element.getAttribute("resourceType") != null)) {
            object = element.getAttribute("type");
            if (object == null) {
                object = element.getAttribute("resourceType");
            }
            element.removeAttribute((Attribute)object);
            node = new Element("ResourceType");
            attribute = new Attribute("name", ((Attribute)object).getValue());
            node.addAttribute(attribute);
            element.appendChild(node);
        }
        if (string.equals("commentTag")) {
            element.setLocalName("CommentTag");
            element.addAttribute(new Attribute("tagString", element.getValue()));
        }
        if ((string.equals("DataFile") || string.equals("DataStream")) && element.getAttribute("contentType") != null) {
            object = element.getAttribute("contentType");
            node = new Attribute("mimeType", ((Attribute)object).getValue());
            element.removeAttribute((Attribute)object);
            element.addAttribute((Attribute)node);
        }
        if (string.equals("DataFile")) {
            string = "DataContainer";
            element.setLocalName("DataContainer");
            object = new Attribute("dataContainerType", "File");
            element.addAttribute((Attribute)object);
        }
        if (string.equals("DataStream")) {
            string = "DataContainer";
            element.setLocalName("DataContainer");
            object = new Attribute("dataContainerType", "Stream");
            element.addAttribute((Attribute)object);
        }
        if (string.equals("Deployment")) {
            string = "DataProducer";
            element.setLocalName("DataProducer");
            object = new Attribute("dataProducerType", "Deployment");
            element.addAttribute((Attribute)object);
        }
        if (string.equals("ProcessRun")) {
            string = "DataProducer";
            element.setLocalName("DataProducer");
            object = new Attribute("dataProducerType", "ProcessRun");
            element.addAttribute((Attribute)object);
        }
        object = null;
        node = null;
        boolean bl = Character.isUpperCase(string.charAt(0));
        if (bl) {
            logger.debug(string + " appears to be an Object");
            object = Class.forName(modelPackage + "." + string);
            node = ((Class)object).newInstance();
            this.buildObject(node, element);
        }
        return node;
    }

    private void buildObject(Object object, Element element) throws Exception {
        logger.debug("buildObject called");
        this.buildFromElements(object, element);
        this.buildFromAttributes(object, element);
    }

    private void buildFromElements(Object object, Element element) throws Exception {
        logger.debug("buildFromElements called");
        String string = null;
        Element element2 = null;
        Object object2 = null;
        boolean bl = false;
        boolean bl2 = false;
        Class<?> clazz = object.getClass();
        logger.debug("parent object class is " + clazz.getName());
        Elements elements = element.getChildElements();
        logger.debug("childElements is " + elements.size() + " elements large");
        for (int i = 0; i < elements.size(); ++i) {
            bl2 = false;
            object2 = null;
            element2 = elements.get(i);
            string = element2.getLocalName();
            if ((string = this.convertNameIfNeeded(string)).equals("commentTag")) {
                string = "CommentTag";
                element2.setLocalName("CommentTag");
                element2.addAttribute(new Attribute("tagString", element2.getValue()));
            }
            logger.debug("childElement local name is " + string);
            bl = Character.isUpperCase(string.charAt(0));
            if (bl) {
                logger.debug(string + " appears to be an object");
                object2 = this.elementToObject(element2);
                if (string.equalsIgnoreCase("CommentTag")) {
                    this.add(object, "addCommentTag", element2);
                } else if (string.equalsIgnoreCase("DataContainerGroup")) {
                    this.add(object, "addDataContainerGroup", element2);
                } else if (string.equalsIgnoreCase("DataProducer")) {
                    this.add(object, "addChildDataProducer", element2);
                } else if (string.equalsIgnoreCase("DataProducerGroup")) {
                    this.add(object, "addDataProducerGroup", element2);
                } else if (string.equalsIgnoreCase("Event")) {
                    this.add(object, "addEvent", element2);
                } else if (string.equalsIgnoreCase("Keyword")) {
                    this.add(object, "addKeyword", element2);
                } else if (string.equalsIgnoreCase("RecordVariable")) {
                    this.add(object, "addRecordVariable", element2);
                } else if (string.equalsIgnoreCase("Resource")) {
                    this.add(object, "addResource", element2);
                } else if (string.equalsIgnoreCase("StandardUnit")) {
                    this.add(object, "addStandardUnit", element2);
                } else {
                    logger.debug("It appears that " + string + " is a property");
                    bl2 = true;
                }
            } else {
                logger.debug("It appears that " + string + " is not an object.");
                if (string.equalsIgnoreCase("input")) {
                    this.addInput(object, element2);
                } else if (string.equalsIgnoreCase("output")) {
                    this.addOutput(object, element2);
                } else if (string.equalsIgnoreCase("consumer")) {
                    this.addConsumer(object, element2);
                } else if (string.equalsIgnoreCase("endDate")) {
                    object2 = this.dateFormat.parse(element2.getValue());
                    bl2 = true;
                } else if (string.equalsIgnoreCase("startDate")) {
                    object2 = this.dateFormat.parse(element2.getValue());
                    bl2 = true;
                } else {
                    logger.debug(string + " is not a object or a special case");
                    object2 = element2.getValue();
                    bl2 = true;
                }
            }
            if (!bl2 || object2 == null) continue;
            logger.debug("It is a property and the childObject is not null");
            String string2 = this.toSetMethodName(element2);
            logger.debug("methodName is: " + string2);
            this.invokeSetMethod(object, string2, object2);
        }
    }

    private void buildFromAttributes(Object object, Element element) throws Exception {
        Attribute attribute = null;
        int n = element.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            attribute = element.getAttribute(i);
            if (this.isSpecialAttribute(attribute)) {
                this.processSpecialAttribute(object, attribute);
                continue;
            }
            this.processAttribute(object, attribute);
        }
    }

    private boolean isSpecialAttribute(Attribute attribute) {
        boolean bl = false;
        String string = attribute.getLocalName();
        if (string.equalsIgnoreCase("endDate") || string.equalsIgnoreCase("startDate") || string.equalsIgnoreCase("url") || string.equalsIgnoreCase("uri") || string.equalsIgnoreCase("DODSUrl")) {
            bl = true;
        }
        return bl;
    }

    private void processSpecialAttribute(Object object, Attribute attribute) throws NoSuchMethodException {
        Serializable serializable = null;
        String string = attribute.getLocalName();
        if (string.equalsIgnoreCase("endDate")) {
            serializable = this.dateFormat.parse(attribute.getValue());
        } else if (string.equalsIgnoreCase("startDate")) {
            serializable = this.dateFormat.parse(attribute.getValue());
        } else {
            if (string.equalsIgnoreCase("url") || string.equalsIgnoreCase("DODSUrl")) {
                try {
                    serializable = new URL(attribute.getValue());
                }
                catch (MalformedURLException malformedURLException) {
                    return;
                }
            }
            if (string.equalsIgnoreCase("uri")) {
                try {
                    serializable = new URI(attribute.getValue());
                }
                catch (URISyntaxException uRISyntaxException) {
                    return;
                }
            }
        }
        try {
            this.invokeSetMethod(object, this.toSetMethodName(attribute), serializable);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (Throwable throwable) {
            logger.error("Throwable caught: " + throwable.getMessage());
            this.errorMessageBuffer.append("Throwable caught: " + throwable.getMessage());
            this.buildFailed = true;
        }
    }

    private void processAttribute(Object object, Attribute attribute) throws InvocationTargetException {
        String string = this.toSetMethodName(attribute);
        Method[] methodArray = object.getClass().getMethods();
        Method method = null;
        Object object2 = null;
        Class<?>[] classArray = null;
        for (int i = 0; i < methodArray.length; ++i) {
            method = methodArray[i];
            if (!string.equals(method.getName())) continue;
            classArray = method.getParameterTypes();
            if (classArray[0].equals(Byte.TYPE) || classArray[0].equals(Byte.class)) {
                object2 = Byte.valueOf(attribute.getValue());
            } else if (classArray[0].equals(Integer.TYPE) || classArray[0].equals(Integer.class)) {
                object2 = Integer.valueOf(attribute.getValue());
            } else if (classArray[0].equals(Short.TYPE) || classArray[0].equals(Short.class)) {
                object2 = Short.valueOf(attribute.getValue());
            } else if (classArray[0].equals(Long.TYPE) || classArray[0].equals(Long.class)) {
                object2 = Long.valueOf(attribute.getValue());
            } else if (classArray[0].equals(Float.TYPE) || classArray[0].equals(Float.class)) {
                object2 = Float.valueOf(attribute.getValue());
            } else if (classArray[0].equals(Double.TYPE) || classArray[0].equals(Double.class)) {
                object2 = Double.valueOf(attribute.getValue());
            } else if (classArray[0].equals(Character.TYPE) || classArray[0].equals(Character.class)) {
                object2 = new Character(attribute.getValue().charAt(0));
            } else if (classArray[0].equals(Boolean.TYPE) || classArray[0].equals(Boolean.class)) {
                object2 = Boolean.valueOf(attribute.getValue());
            } else if (classArray[0].equals(String.class)) {
                object2 = attribute.getValue();
            }
            if (object2 == null) break;
            try {
                method.invoke(object, object2);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.buildFailed = true;
                this.errorMessageBuffer.append(invocationTargetException.getTargetException().getMessage());
                logger.error("Method invoke failed: " + invocationTargetException.getTargetException().getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            break;
        }
    }

    private void invokeSetMethod(Object object, String string, Object object2) throws NoSuchMethodException {
        Class[] classArray = new Class[]{object2.getClass()};
        Object[] objectArray = new Object[]{object2};
        try {
            Method method = object.getClass().getMethod(string.toString(), classArray);
            method.invoke(object, objectArray);
            logger.debug("...completed");
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.error("...FAILED: problem with " + object);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.error("...FAILED: Access Denied!!");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.buildFailed = true;
            logger.error("NoSuchMethodException: problem with " + object + " trying to find method " + string + "(" + classArray[0] + ")");
            this.errorMessageBuffer.append("NoSuchMethodException: problem with " + object + " trying to find method " + string + "(" + classArray[0] + ")");
            throw noSuchMethodException;
        }
    }

    private String toSetMethodName(Attribute attribute) {
        return this.toSetMethodName(attribute.getLocalName());
    }

    private String toSetMethodName(Element element) {
        return this.toSetMethodName(element.getLocalName());
    }

    private String toSetMethodName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string.substring(0, 1);
        stringBuffer.append("set" + string2.toUpperCase() + string.substring(1, string.length()));
        return stringBuffer.toString();
    }

    private void add(Object object, String string, Element element) {
        try {
            logger.debug("add with object, " + string + ", element called");
            Object object2 = this.elementToObject(element);
            this.add(object, string, object2);
        }
        catch (Exception exception) {
            logger.info(this.getClass().getName() + ": Unable to add the contents of " + element + " to " + object + " using " + string);
        }
    }

    private void add(Object object, String string, Object object2) {
        try {
            logger.debug("add with object, " + string + ", object called");
            this.add(object, string, object2, object2.getClass());
        }
        catch (Exception exception) {
            logger.info(this.getClass().getName() + ": Unable to add " + object2 + " to " + object + " using " + string + ". The reason is " + exception.getMessage());
        }
    }

    private void add(Object object, String string, Object object2, Class clazz) {
        try {
            Class[] classArray = new Class[]{clazz};
            Method method = object.getClass().getMethod(string, classArray);
            method.invoke(object, object2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addInput(Object object, Element element) throws Exception {
        logger.debug("addInput called with parentObject = " + object + " and element = " + element);
        Object object2 = null;
        Elements elements = element.getChildElements();
        Element element2 = null;
        for (int i = 0; i < elements.size(); ++i) {
            element2 = elements.get(i);
            object2 = this.elementToObject(element2);
            this.add(object, "addInput", object2, DataContainer.class);
        }
    }

    private void addOutput(Object object, Element element) throws Exception {
        logger.debug("addOutput called with parentObject = " + object + " and element = " + element);
        Object object2 = null;
        Elements elements = element.getChildElements();
        Element element2 = null;
        for (int i = 0; i < elements.size(); ++i) {
            element2 = elements.get(i);
            object2 = this.elementToObject(element2);
            this.add(object, "addOutput", object2, DataContainer.class);
        }
    }

    private void addConsumer(Object object, Element element) throws Exception {
        logger.debug("addConsumer called with parentObject = " + object + " and element = " + element);
        Object object2 = null;
        Elements elements = element.getChildElements();
        Element element2 = null;
        for (int i = 0; i < elements.size(); ++i) {
            element2 = elements.get(i);
            object2 = this.elementToObject(element2);
            this.add(object, "addConsumer", object2, DataProducer.class);
        }
    }

    private Collection retrieveObjects(String string) {
        ArrayList arrayList = null;
        try {
            arrayList = (ArrayList)this.objects.get(Class.forName(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(this.getClass().getName() + ": Unable to load class " + string);
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        return arrayList;
    }

    private String convertNameIfNeeded(String string) {
        if (string.equalsIgnoreCase("Deployment")) {
            return "DataProducer";
        }
        if (string.equalsIgnoreCase("ProcessRun")) {
            return "DataProducer";
        }
        if (string.equalsIgnoreCase("DataFile")) {
            return "DataContainer";
        }
        if (string.equalsIgnoreCase("DataStream")) {
            return "DataContainer";
        }
        return string;
    }

    public Collection listAll() {
        ArrayList arrayList = new ArrayList();
        Collection collection = this.objects.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.addAll((Collection)iterator.next());
        }
        return arrayList;
    }

    public Collection listDataProducers() {
        return this.retrieveObjects(modelPackage + ".DataProducer");
    }

    public Collection listDevices() {
        return this.retrieveObjects(modelPackage + ".Device");
    }
}

