/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.metadata.util;

import moos.ssds.metadata.util.MetadataException;

public class MetadataValidator {
    public static final int COMMENT_TAG_LENGTH = 10;
    public static final int NAME_LENGTH = 50;
    public static final int DESCRIPTION_LENGTH = 255;
    public static final int URI_STRING_LENGTH = 2048;
    public static final int RESOURCE_BLOB_LENGTH = 2048;
    public static final double MIN_LATITUDE = -90.0;
    public static final double MAX_LATITUDE = 90.0;
    public static final double MIN_LONGITUDE = -360.0;
    public static final double MAX_LONGITUDE = 360.0;
    public static final float DEPTH_MIN = 0.0f;

    public static void isStringShorterThan(String string, int n) throws MetadataException {
        if (string != null && string.length() > n) {
            throw new MetadataException("The string supplied was of length " + string.length() + " which is longer than " + n + " characters, please shorten");
        }
    }

    public static void isObjectNull(Object object) throws MetadataException {
        if (object == null) {
            throw new MetadataException("The incoming object was null, it cannot be");
        }
    }

    public static void isValueBetween(Double d, double d2, double d3) throws MetadataException {
        if (d != null && (d < d2 || d > d3)) {
            throw new MetadataException("The supplied value of " + d + " was not between " + d2 + " and " + d3 + ", please correct.");
        }
    }

    public static void isValueBetween(Float f, float f2, float f3) throws MetadataException {
        if (f != null && (f.floatValue() < f2 || f.floatValue() > f3)) {
            throw new MetadataException("The supplied value of " + f.floatValue() + " was not between " + f2 + " and " + f3 + ", please correct.");
        }
    }

    public static void isValueGreaterThan(Double d, double d2) throws MetadataException {
        if (d != null && d < d2) {
            throw new MetadataException("The supplied value of " + d + " was not greater than " + d2 + ", please correct.");
        }
    }

    public static void isValueGreaterThan(Float f, float f2) throws MetadataException {
        if (f != null && f.floatValue() < f2) {
            throw new MetadataException("The supplied value of " + f.floatValue() + " was not greater than " + f2 + ", please correct.");
        }
    }
}

