/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.metadata.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.StringTokenizer;
import moos.ssds.metadata.IMetadataObject;
import moos.ssds.metadata.util.MetadataException;
import moos.ssds.metadata.util.ObjectBuilder;
import moos.ssds.metadata.util.XmlBuilder;
import moos.ssds.util.XmlDateFormat;
import nu.xom.ValidityException;
import org.apache.log4j.Logger;

public class MetadataFactory {
    static Logger logger = Logger.getLogger(MetadataFactory.class);

    public static IMetadataObject createMetadataObjectFromStringRepresentation(String string, String string2) throws MetadataException {
        StringTokenizer stringTokenizer;
        String string3;
        IMetadataObject iMetadataObject = null;
        String string4 = string2;
        if (string4 == null) {
            string4 = "|";
        }
        if ((string3 = (stringTokenizer = new StringTokenizer(string, string4)).nextToken()) == null || string3.equals("")) {
            throw new MetadataException("No class was specified in the string, nothing could be instantiated");
        }
        if (!string3.startsWith("moos.ssds.metadata.")) {
            string3 = "moos.ssds.metadata." + string3;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MetadataException("ClassNotFoundException for " + string3 + ": " + classNotFoundException.getMessage());
        }
        try {
            iMetadataObject = (IMetadataObject)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new MetadataException("InstantiationException for " + string3 + ": " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MetadataException("IllegalAccessException for " + string3 + ": " + illegalAccessException.getMessage());
        }
        iMetadataObject.setValuesFromStringRepresentation(string, string4);
        return iMetadataObject;
    }

    public static Object getObject(String string) {
        Object var1_1 = null;
        try {
            Class clazz = MetadataFactory.findClassByName(string);
            var1_1 = clazz.newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return var1_1;
    }

    public static Object getObject(Class clazz, String string, String string2) throws IllegalArgumentException {
        XmlDateFormat xmlDateFormat = new XmlDateFormat();
        Object object = null;
        if (clazz == null) {
            throw new IllegalArgumentException("No Class was specified, could not create object");
        }
        try {
            if (clazz.equals(Byte.TYPE)) {
                object = string == null || string.equals("") ? null : new Byte(string);
            } else if (clazz.equals(Byte.class)) {
                object = string == null || string.equals("") ? null : new Byte(string);
            } else if (clazz.equals(Short.TYPE)) {
                object = string == null || string.equals("") ? null : new Short(string);
            } else if (clazz.equals(Short.class)) {
                object = string == null || string.equals("") ? null : new Short(string);
            } else if (clazz.equals(Integer.TYPE)) {
                object = string == null || string.equals("") ? null : new Integer(string);
            } else if (clazz.equals(Integer.class)) {
                object = string == null || string.equals("") ? null : new Integer(string);
            } else if (clazz.equals(Long.TYPE)) {
                object = string == null || string.equals("") ? null : new Long(string);
            } else if (clazz.equals(Long.class)) {
                object = string == null || string.equals("") ? null : new Long(string);
            } else if (clazz.equals(Float.TYPE)) {
                object = string == null || string.equals("") ? null : new Float(string);
            } else if (clazz.equals(Float.class)) {
                object = string == null || string.equals("") ? null : new Float(string);
            } else if (clazz.equals(Double.TYPE)) {
                object = string == null || string.equals("") ? null : new Double(string);
            } else if (clazz.equals(Double.class)) {
                object = string == null || string.equals("") ? null : new Double(string);
            } else if (clazz.equals(Character.TYPE)) {
                object = string == null || string.equals("") ? null : new Character(string.toCharArray()[0]);
            } else if (clazz.equals(Character.class)) {
                object = string == null || string.equals("") ? null : new Character(string.toCharArray()[0]);
            } else if (clazz.equals(Boolean.TYPE)) {
                object = string == null || string.equals("") ? null : new Boolean(string);
            } else if (clazz.equals(Boolean.class)) {
                object = string == null || string.equals("") ? null : new Boolean(string);
            } else {
                if (clazz.equals(String.class)) {
                    return string;
                }
                if (clazz.equals(Date.class)) {
                    object = string == null || string.equals("") ? null : xmlDateFormat.parse(string);
                } else if (clazz.equals(Calendar.class)) {
                    if (string == null || string.equals("")) {
                        object = null;
                    } else {
                        Date date = xmlDateFormat.parse(string);
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(date);
                        object = calendar;
                    }
                } else {
                    object = clazz.equals(URI.class) ? (string == null || string.equals("") ? null : new URI(string)) : (clazz.equals(URL.class) ? (string == null || string.equals("") ? null : new URL(string)) : MetadataFactory.createMetadataObjectFromStringRepresentation(string, string2));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Could not convert value " + string + " to a " + clazz.getName() + ": " + numberFormatException.getMessage());
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Could not convert value " + string + " to a " + clazz.getName() + ": " + throwable.getMessage());
        }
        return object;
    }

    public static Class findClassByName(String string) throws ClassNotFoundException {
        if (string.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (string.equals("int")) {
            return Integer.TYPE;
        }
        if (string.equals("byte")) {
            return Byte.TYPE;
        }
        if (string.equals("char")) {
            return Character.TYPE;
        }
        if (string.equals("short")) {
            return Short.TYPE;
        }
        if (string.equals("long")) {
            return Long.TYPE;
        }
        if (string.equals("float")) {
            return Float.TYPE;
        }
        if (string.equals("double")) {
            return Double.TYPE;
        }
        Class<?> clazz = null;
        if (string == null || string.equals("")) {
            return null;
        }
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null && string.indexOf(".") < 0) {
            String string2 = string.substring(0, 1);
            string2 = string2.toUpperCase();
            try {
                clazz = Class.forName(string2 + string.substring(1));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null) {
                try {
                    clazz = Class.forName("java.lang." + string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                try {
                    clazz = Class.forName("java.lang." + string2 + string.substring(1));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                try {
                    clazz = Class.forName("java.util." + string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                try {
                    clazz = Class.forName("java.util." + string2 + string.substring(1));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                try {
                    clazz = Class.forName("moos.ssds.metadata." + string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                try {
                    clazz = Class.forName("moos.ssds.metadata." + string2 + string.substring(1));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Could not find class with name " + string);
        }
        return clazz;
    }

    public static String createXMLFromObject(IMetadataObject iMetadataObject) throws MetadataException {
        if (iMetadataObject == null) {
            return null;
        }
        String string = null;
        XmlBuilder xmlBuilder = new XmlBuilder();
        xmlBuilder.add(iMetadataObject);
        xmlBuilder.marshal();
        try {
            string = xmlBuilder.toFormattedXML();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MetadataException("UnsupportedEncodingException caught: " + unsupportedEncodingException.getMessage());
        }
        catch (IOException iOException) {
            throw new MetadataException("IOException caught: " + iOException.getMessage());
        }
        return string;
    }

    public static Collection createMetadataObjectsFromXML(String string) throws MetadataException {
        if (string == null) {
            return null;
        }
        Collection collection = new ArrayList();
        ObjectBuilder objectBuilder = new ObjectBuilder(string);
        try {
            objectBuilder.unmarshal(false);
        }
        catch (ValidityException validityException) {
            throw new MetadataException("Validity Exception caught: " + validityException.getMessage());
        }
        catch (Exception exception) {
            throw new MetadataException("Exception caught: " + exception.getMessage());
        }
        collection = objectBuilder.listAll();
        return collection;
    }
}

