/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import moos.ssds.metadata.IDescription;
import moos.ssds.metadata.IMetadataObject;
import moos.ssds.metadata.StandardUnit;
import moos.ssds.metadata.util.MetadataException;
import moos.ssds.metadata.util.MetadataValidator;

public class StandardVariable
implements IMetadataObject,
IDescription {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String name;
    private String description;
    private String referenceScale;
    private Collection standardUnits = new ArrayList();
    private long version = -1L;

    public StandardVariable() {
        try {
            this.setDescription("");
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) throws MetadataException {
        MetadataValidator.isObjectNull(string);
        MetadataValidator.isStringShorterThan(string, 50);
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) throws MetadataException {
        MetadataValidator.isStringShorterThan(string, 255);
        this.description = string;
    }

    public String getReferenceScale() {
        return this.referenceScale;
    }

    public void setReferenceScale(String string) throws MetadataException {
        MetadataValidator.isObjectNull(string);
        MetadataValidator.isStringShorterThan(string, 50);
        this.referenceScale = string;
    }

    public Collection getStandardUnits() {
        return this.standardUnits;
    }

    protected void setStandardUnits(Collection collection) {
        this.standardUnits = collection;
    }

    public void addStandardUnit(StandardUnit standardUnit) {
        if (standardUnit == null) {
            return;
        }
        if (this.standardUnits == null) {
            this.standardUnits = new ArrayList();
        }
        if (!this.standardUnits.contains(standardUnit)) {
            this.standardUnits.add(standardUnit);
        }
    }

    public void removeStandardUnit(StandardUnit standardUnit) {
        if (standardUnit == null) {
            return;
        }
        if (this.standardUnits != null && this.standardUnits.contains(standardUnit)) {
            this.standardUnits.remove(standardUnit);
        }
    }

    public void clearStandardUnits() {
        this.standardUnits.clear();
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long l) {
        this.version = l;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof StandardVariable)) {
            return false;
        }
        StandardVariable standardVariable = (StandardVariable)object;
        if (this.name == null || standardVariable.getName() == null || this.referenceScale == null || standardVariable.getReferenceScale() == null) {
            return false;
        }
        return this.hashCode() == standardVariable.hashCode();
    }

    public int hashCode() {
        int n = 72;
        if (this.name != null) {
            n = 42 * n + this.name.hashCode();
        }
        if (this.referenceScale != null) {
            n = 9 * n + this.referenceScale.hashCode();
        }
        return n;
    }

    public String toStringRepresentation(String string) {
        if (string == null) {
            string = "|";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("StandardVariable");
        stringBuffer.append(string + "id=" + this.getId());
        stringBuffer.append(string + "name=" + this.getName());
        stringBuffer.append(string + "description=" + this.getDescription());
        stringBuffer.append(string + "referenceScale=" + this.getReferenceScale());
        return stringBuffer.toString();
    }

    public void setValuesFromStringRepresentation(String string, String string2) throws MetadataException {
        String string3 = string2;
        if (string3 == null) {
            string3 = "|";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
        String string4 = stringTokenizer.nextToken();
        if (!this.getClass().getName().equals(string4) && !this.getClass().getName().equals("moos.ssds.metadata." + string4)) {
            throw new MetadataException("The class specified by the first token (" + string4 + " does not match this class " + this.getClass().getName());
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            int n = string5.indexOf("=");
            String string6 = null;
            String string7 = null;
            if (n >= 0) {
                string6 = string5.substring(0, n);
                string7 = string5.substring(n + 1);
            } else {
                string6 = "";
                string7 = "";
            }
            if (string6.equalsIgnoreCase("id")) {
                try {
                    this.setId(new Long(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("Could not convert the value for id (" + string7 + ") to a Long");
                }
            }
            if (string6.equalsIgnoreCase("name")) {
                this.setName(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("description")) {
                this.setDescription(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("referenceScale")) {
                this.setReferenceScale(string7);
                continue;
            }
            throw new MetadataException("The attribute specified by " + string6 + " is not a recognized field of " + this.getClass().getName());
        }
    }
}

