/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.metadata;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import moos.ssds.metadata.IDescription;
import moos.ssds.metadata.IMetadataObject;
import moos.ssds.metadata.IResourceOwner;
import moos.ssds.metadata.Person;
import moos.ssds.metadata.Resource;
import moos.ssds.metadata.util.MetadataException;
import moos.ssds.metadata.util.MetadataValidator;

public class Software
implements IMetadataObject,
IDescription,
IResourceOwner {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String name;
    private String description;
    private String uriString;
    private String softwareVersion;
    private long version = -1L;
    private Person person;
    private Collection resources = new ArrayList();

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) throws MetadataException {
        MetadataValidator.isObjectNull(string);
        MetadataValidator.isStringShorterThan(string, 50);
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) throws MetadataException {
        MetadataValidator.isStringShorterThan(string, 255);
        this.description = string;
    }

    public String getUriString() {
        return this.uriString;
    }

    public void setUriString(String string) throws MetadataException {
        MetadataValidator.isStringShorterThan(string, 2048);
        this.uriString = string;
    }

    public URI getUri() {
        URI uRI = null;
        uRI = URI.create(this.uriString);
        return uRI;
    }

    public void setUri(URI uRI) throws MetadataException {
        this.setUriString(uRI.toASCIIString());
    }

    public URL getUrl() {
        URL uRL = null;
        try {
            uRL = this.getUri().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        return uRL;
    }

    public void setUrl(URL uRL) throws MetadataException {
        this.setUriString(uRL.toExternalForm());
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(String string) throws MetadataException {
        MetadataValidator.isObjectNull(string);
        this.softwareVersion = string;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public Collection getResources() {
        return this.resources;
    }

    protected void setResources(Collection collection) {
        this.resources = collection;
    }

    public void addResource(Resource resource) {
        if (resource == null) {
            return;
        }
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        if (!this.resources.contains(resource)) {
            this.resources.add(resource);
        }
    }

    public void removeResource(Resource resource) {
        if (resource == null) {
            return;
        }
        if (this.resources != null && this.resources.contains(resource)) {
            this.resources.remove(resource);
        }
    }

    public void clearResources() {
        this.resources.clear();
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long l) {
        this.version = l;
    }

    public String toStringRepresentation(String string) {
        if (string == null) {
            string = "|";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Software");
        stringBuffer.append(string + "id=" + this.getId());
        stringBuffer.append(string + "name=" + this.getName());
        stringBuffer.append(string + "description=" + this.getDescription());
        stringBuffer.append(string + "uriString=" + this.getUriString());
        stringBuffer.append(string + "softwareVersion=" + this.getSoftwareVersion());
        return stringBuffer.toString();
    }

    public void setValuesFromStringRepresentation(String string, String string2) throws MetadataException {
        String string3 = string2;
        if (string3 == null) {
            string3 = "|";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
        String string4 = stringTokenizer.nextToken();
        if (!this.getClass().getName().equals(string4) && !this.getClass().getName().equals("moos.ssds.metadata." + string4)) {
            throw new MetadataException("The class specified by the first token (" + string4 + " does not match this class " + this.getClass().getName());
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            int n = string5.indexOf("=");
            String string6 = null;
            String string7 = null;
            if (n >= 0) {
                string6 = string5.substring(0, n);
                string7 = string5.substring(n + 1);
            } else {
                string6 = "";
                string7 = "";
            }
            if (string6.equalsIgnoreCase("id")) {
                try {
                    this.setId(new Long(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("Could not convert the value for id (" + string7 + ") to a Long");
                }
            }
            if (string6.equalsIgnoreCase("name")) {
                this.setName(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("description")) {
                this.setDescription(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("uriString")) {
                this.setUriString(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("uri")) {
                this.setUri(URI.create(string7));
                continue;
            }
            if (string6.equalsIgnoreCase("url")) {
                URL uRL = null;
                try {
                    uRL = new URL(string7);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new MetadataException("The string " + string7 + " that was specified as the URL, could not be " + "converted to a URL: " + malformedURLException.getMessage());
                }
                this.setUrl(uRL);
                continue;
            }
            if (string6.equalsIgnoreCase("softwareVersion")) {
                this.setSoftwareVersion(string7);
                continue;
            }
            throw new MetadataException("The attribute specified by " + string6 + " is not a recognized field of " + this.getClass().getName());
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof Software)) {
            return false;
        }
        Software software = (Software)object;
        if (this.name == null || software.getName() == null || this.softwareVersion == null || software.getSoftwareVersion() == null) {
            return false;
        }
        return this.hashCode() == software.hashCode();
    }

    public int hashCode() {
        int n = 14;
        if (this.name != null) {
            n = 7 * n + this.name.hashCode();
        }
        if (this.softwareVersion != null) {
            n = 91 * n + this.softwareVersion.hashCode();
        }
        return n;
    }
}

