/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.metadata;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.StringTokenizer;
import moos.ssds.metadata.DateRange;
import moos.ssds.metadata.IDateRange;
import moos.ssds.metadata.IDescription;
import moos.ssds.metadata.IMetadataObject;
import moos.ssds.metadata.Keyword;
import moos.ssds.metadata.Person;
import moos.ssds.metadata.ResourceBLOB;
import moos.ssds.metadata.ResourceType;
import moos.ssds.metadata.util.MetadataException;
import moos.ssds.metadata.util.MetadataValidator;
import moos.ssds.util.XmlDateFormat;

public class Resource
implements IMetadataObject,
IDescription,
IDateRange {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String name;
    private String description;
    private Date startDate;
    private Date endDate;
    private IDateRange dateRange = new DateRange(this);
    private String uriString;
    private Long contentLength;
    private String mimeType;
    private long version = -1L;
    private Person person;
    private ResourceType resourceType;
    private ResourceBLOB resourceBLOB;
    private Collection keywords = new ArrayList();
    private XmlDateFormat xmlDateFormat = new XmlDateFormat();

    public Resource() {
    }

    public Resource(URL uRL) throws MetadataException {
        this.setUrl(uRL);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) throws MetadataException {
        MetadataValidator.isStringShorterThan(string, 50);
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) throws MetadataException {
        MetadataValidator.isStringShorterThan(string, 255);
        this.description = string;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date date) {
        this.startDate = date;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date date) {
        this.endDate = date;
    }

    public IDateRange getDateRange() {
        return this.dateRange;
    }

    public String getUriString() {
        return this.uriString;
    }

    public void setUriString(String string) throws MetadataException {
        MetadataValidator.isObjectNull(string);
        MetadataValidator.isStringShorterThan(string, 2048);
        this.uriString = string;
    }

    public URI getUri() {
        URI uRI = null;
        uRI = URI.create(this.uriString);
        return uRI;
    }

    public void setUri(URI uRI) throws MetadataException {
        this.setUriString(uRI.toASCIIString());
    }

    public URL getUrl() {
        URL uRL = null;
        try {
            uRL = this.getUri().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        return uRL;
    }

    public void setUrl(URL uRL) throws MetadataException {
        this.setUriString(uRL.toExternalForm());
    }

    public boolean isWebAccessible() {
        if (this.getUrl() == null) {
            return false;
        }
        boolean bl = false;
        String string = this.getUrl().getProtocol();
        if (string.equals("http") || string.equals("ftp")) {
            bl = true;
        }
        return bl;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(Long l) {
        this.contentLength = l;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String string) {
        this.mimeType = string;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public ResourceBLOB getResourceBLOB() {
        return this.resourceBLOB;
    }

    public void setResourceBLOB(ResourceBLOB resourceBLOB) {
        this.resourceBLOB = resourceBLOB;
    }

    public Collection getKeywords() {
        return this.keywords;
    }

    protected void setKeywords(Collection collection) {
        this.keywords = collection;
    }

    public void addKeyWord(Keyword keyword) {
        if (keyword == null) {
            return;
        }
        if (!this.keywords.contains(keyword)) {
            this.keywords.add(keyword);
        }
    }

    public void removeKeyWord(Keyword keyword) {
        if (keyword == null) {
            return;
        }
        if (this.keywords != null && this.keywords.contains(keyword)) {
            this.keywords.remove(keyword);
        }
    }

    public void clearKeywords() {
        this.keywords.clear();
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long l) {
        this.version = l;
    }

    public String toStringRepresentation(String string) {
        if (string == null) {
            string = "|";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Resource");
        stringBuffer.append(string + "id=" + this.getId());
        stringBuffer.append(string + "name=" + this.getName());
        stringBuffer.append(string + "description=" + this.getDescription());
        stringBuffer.append(string + "startDate=" + this.getStartDate());
        stringBuffer.append(string + "endDate=" + this.getEndDate());
        stringBuffer.append(string + "uriString=" + this.getUriString());
        stringBuffer.append(string + "contentLength=" + this.getContentLength());
        stringBuffer.append(string + "mimeType=" + this.getMimeType());
        return stringBuffer.toString();
    }

    public void setValuesFromStringRepresentation(String string, String string2) throws MetadataException {
        String string3 = string2;
        if (string3 == null) {
            string3 = "|";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
        String string4 = stringTokenizer.nextToken();
        if (!this.getClass().getName().equals(string4) && !this.getClass().getName().equals("moos.ssds.metadata." + string4)) {
            throw new MetadataException("The class specified by the first token (" + string4 + " does not match this class " + this.getClass().getName());
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            int n = string5.indexOf("=");
            String string6 = null;
            String string7 = null;
            if (n >= 0) {
                string6 = string5.substring(0, n);
                string7 = string5.substring(n + 1);
            } else {
                string6 = "";
                string7 = "";
            }
            if (string6.equalsIgnoreCase("id")) {
                try {
                    this.setId(new Long(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("Could not convert the value for id (" + string7 + ") to a Long");
                }
            }
            if (string6.equalsIgnoreCase("name")) {
                this.setName(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("description")) {
                this.setDescription(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("startDate")) {
                this.setStartDate(this.xmlDateFormat.parse(string7));
                continue;
            }
            if (string6.equalsIgnoreCase("endDate")) {
                this.setEndDate(this.xmlDateFormat.parse(string7));
                continue;
            }
            if (string6.equalsIgnoreCase("uriString")) {
                this.setUriString(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("uri")) {
                this.setUri(URI.create(string7));
                continue;
            }
            if (string6.equalsIgnoreCase("url")) {
                URL uRL = null;
                try {
                    uRL = new URL(string7);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new MetadataException("The string " + string7 + " that was specified as the URL, could not be " + "converted to a URL: " + malformedURLException.getMessage());
                }
                this.setUrl(uRL);
                continue;
            }
            if (string6.equalsIgnoreCase("contentLength")) {
                try {
                    this.setContentLength(Long.valueOf(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("The value specified for contentLength (" + string7 + ") could not be converted to a Long: " + numberFormatException.getMessage());
                }
            }
            if (string6.equalsIgnoreCase("mimeType")) {
                this.setMimeType(string7);
                continue;
            }
            throw new MetadataException("The attribute specified by " + string6 + " is not a recognized field of " + this.getClass().getName());
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof Resource)) {
            return false;
        }
        Resource resource = (Resource)object;
        if (this.uriString == null || resource.getUriString() == null) {
            return false;
        }
        return this.hashCode() == resource.hashCode();
    }

    public int hashCode() {
        int n = 53;
        if (this.uriString != null) {
            n = 4 * n + this.uriString.hashCode();
        }
        return n;
    }
}

