/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import moos.ssds.metadata.IMetadataObject;
import moos.ssds.metadata.RecordVariable;
import moos.ssds.metadata.util.MetadataException;
import moos.ssds.metadata.util.MetadataValidator;

public class RecordDescription
implements IMetadataObject {
    private static final long serialVersionUID = 1L;
    private Long id;
    private Long recordType;
    private String bufferStyle;
    private String bufferParseType;
    private String bufferItemSeparator;
    private String bufferLengthType;
    private String recordTerminator;
    private Boolean parseable = new Boolean(false);
    private String endian = "little";
    private long version = -1L;
    private Collection recordVariables = new ArrayList();
    public static final String BUFFER_STYLE_ASCII = "ASCII";
    public static final String BUFFER_STYLE_BINARY = "binary";
    public static final String BUFFER_LENGTH_TYPE_FIXED = "fixed";
    public static final String BUFFER_LENGTH_TYPE_VARIABLE = "variable";
    public static final String ENDIAN_BIG = "big";
    public static final String ENDIAN_LITTLE = "little";
    public static final String PARSE_TYPE_FIXED_POSITION = "fixed";
    public static final String PARSE_TYPE_ORDERED_POSITION = "ordered";
    public static final String PARSE_TYPE_UNIQUE_TOKEN = "unique_token";

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public Long getRecordType() {
        return this.recordType;
    }

    public void setRecordType(Long l) throws MetadataException {
        MetadataValidator.isObjectNull(l);
        this.recordType = l;
    }

    public String getBufferStyle() {
        return this.bufferStyle;
    }

    public void setBufferStyle(String string) throws MetadataException {
        if (!RecordDescription.isValidBufferStyle(string)) {
            throw new MetadataException("The bufferStyle of " + string + " does not match a recognized buffer style");
        }
        this.bufferStyle = string;
    }

    public String getBufferParseType() {
        return this.bufferParseType;
    }

    public void setBufferParseType(String string) throws MetadataException {
        if (!RecordDescription.isValidParseType(string)) {
            throw new MetadataException("The bufferParseType of " + string + " was not reckognized.");
        }
        this.bufferParseType = string;
    }

    public String getBufferItemSeparator() {
        return this.bufferItemSeparator;
    }

    public void setBufferItemSeparator(String string) {
        this.bufferItemSeparator = string;
    }

    public String getBufferLengthType() {
        return this.bufferLengthType;
    }

    public void setBufferLengthType(String string) throws MetadataException {
        if (!RecordDescription.isValidBufferLengthType(string)) {
            throw new MetadataException("The bufferLengthType of " + string + " is not reckognized");
        }
        this.bufferLengthType = string;
    }

    public String getRecordTerminator() {
        return this.recordTerminator;
    }

    public void setRecordTerminator(String string) {
        this.recordTerminator = string;
    }

    public Boolean isParseable() {
        return this.parseable;
    }

    public void setParseable(Boolean bl) {
        this.parseable = bl;
    }

    public String getEndian() {
        return this.endian;
    }

    public void setEndian(String string) throws MetadataException {
        if (!RecordDescription.isValidEndian(string)) {
            throw new MetadataException("The endian of " + string + " is not recognized");
        }
        this.endian = string;
    }

    public Collection getRecordVariables() {
        return this.recordVariables;
    }

    protected void setRecordVariables(Collection collection) {
        this.recordVariables = collection;
    }

    public void addRecordVariable(RecordVariable recordVariable) {
        if (recordVariable == null) {
            return;
        }
        if (!this.recordVariables.contains(recordVariable)) {
            this.recordVariables.add(recordVariable);
        }
    }

    public void removeRecordVariable(RecordVariable recordVariable) {
        if (recordVariable == null) {
            return;
        }
        if (this.recordVariables != null && this.recordVariables.contains(recordVariable)) {
            this.recordVariables.remove(recordVariable);
        }
    }

    public void clearRecordVariables() {
        this.recordVariables.clear();
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long l) {
        this.version = l;
    }

    public static boolean isValidBufferStyle(String string) {
        boolean bl = true;
        if (string == null) {
            bl = true;
        } else if (!string.equals(BUFFER_STYLE_ASCII) && !string.equals(BUFFER_STYLE_BINARY)) {
            bl = false;
        }
        return bl;
    }

    public static boolean isValidBufferLengthType(String string) {
        boolean bl = true;
        if (string == null) {
            bl = true;
        } else if (!string.equals("fixed") && !string.equals(BUFFER_LENGTH_TYPE_VARIABLE)) {
            bl = false;
        }
        return bl;
    }

    public static boolean isValidEndian(String string) {
        boolean bl = true;
        if (string == null) {
            bl = true;
        } else if (!string.equals(ENDIAN_BIG) && !string.equals(ENDIAN_LITTLE)) {
            bl = false;
        }
        return bl;
    }

    public static boolean isValidParseType(String string) {
        boolean bl = true;
        if (string == null) {
            bl = true;
        } else if (!(string.equals("fixed") || string.equals(PARSE_TYPE_ORDERED_POSITION) || string.equals(PARSE_TYPE_UNIQUE_TOKEN))) {
            bl = false;
        }
        return bl;
    }

    public String toStringRepresentation(String string) {
        if (string == null) {
            string = "|";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RecordDescription");
        stringBuffer.append(string + "id=" + this.getId());
        stringBuffer.append(string + "recordType=" + this.getRecordType());
        stringBuffer.append(string + "bufferStyle=" + this.getBufferStyle());
        stringBuffer.append(string + "bufferParseType=" + this.getBufferParseType());
        stringBuffer.append(string + "bufferItemSeparator=" + this.getBufferItemSeparator());
        stringBuffer.append(string + "bufferLengthType=" + this.getBufferLengthType());
        stringBuffer.append(string + "recordTerminator=" + this.getRecordTerminator());
        stringBuffer.append(string + "parseable=" + this.isParseable());
        stringBuffer.append(string + "endian=" + this.getEndian());
        return stringBuffer.toString();
    }

    public void setValuesFromStringRepresentation(String string, String string2) throws MetadataException {
        String string3 = string2;
        if (string3 == null) {
            string3 = "|";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
        String string4 = stringTokenizer.nextToken();
        if (!this.getClass().getName().equals(string4) && !this.getClass().getName().equals("moos.ssds.metadata." + string4)) {
            throw new MetadataException("The class specified by the first token (" + string4 + " does not match this class " + this.getClass().getName());
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            int n = string5.indexOf("=");
            String string6 = null;
            String string7 = null;
            if (n >= 0) {
                string6 = string5.substring(0, n);
                string7 = string5.substring(n + 1);
            } else {
                string6 = "";
                string7 = "";
            }
            if (string6.equalsIgnoreCase("id")) {
                try {
                    this.setId(new Long(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("Could not convert the value for id (" + string7 + ") to a Long");
                }
            }
            if (string6.equalsIgnoreCase("recordType")) {
                try {
                    this.setRecordType(Long.valueOf(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("The value specified for recordType (" + string7 + ") could not be converted to a Long: " + numberFormatException.getMessage());
                }
            }
            if (string6.equalsIgnoreCase("bufferStyle")) {
                this.setBufferStyle(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("bufferParseType")) {
                this.setBufferParseType(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("bufferItemSeparator")) {
                this.setBufferItemSeparator(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("bufferLengthType")) {
                this.setBufferLengthType(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("recordTerminator")) {
                this.setRecordTerminator(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("parseable")) {
                if (!string7.equalsIgnoreCase("true") && !string7.equalsIgnoreCase("false")) {
                    throw new MetadataException("Could not convert the specified value for parseable (" + string7 + ") to a boolean (valid options are 'true' or 'false')");
                }
                this.setParseable(Boolean.valueOf(string7));
                continue;
            }
            if (string6.equalsIgnoreCase("endian")) {
                this.setEndian(string7);
                continue;
            }
            throw new MetadataException("The attribute specified by " + string6 + " is not a recognized field of " + this.getClass().getName());
        }
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

