/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import moos.ssds.metadata.IMetadataObject;
import moos.ssds.metadata.UserGroup;
import moos.ssds.metadata.util.MetadataException;
import moos.ssds.metadata.util.MetadataValidator;

public class Person
implements IMetadataObject {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String firstname;
    private String surname;
    private String organization;
    private String username;
    private transient String password;
    private String email;
    private String phone;
    private String address1;
    private String address2;
    private String city;
    private String state;
    private String zipcode;
    private String status;
    private Collection userGroups = new ArrayList();
    public static final String STATUS_ACTIVE = "active";
    public static final String STATUS_INACTIVE = "inactive";
    private long version = -1L;

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String string) throws MetadataException {
        MetadataValidator.isStringShorterThan(string, 50);
        this.firstname = string;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String string) throws MetadataException {
        MetadataValidator.isStringShorterThan(string, 50);
        this.surname = string;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String string) throws MetadataException {
        MetadataValidator.isStringShorterThan(string, 50);
        this.organization = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) throws MetadataException {
        if (string == null || string.equals("")) {
            throw new MetadataException("username cannot be empty");
        }
        MetadataValidator.isStringShorterThan(string, 50);
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) throws MetadataException {
        MetadataValidator.isStringShorterThan(string, 50);
        this.password = string;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String string) throws MetadataException {
        MetadataValidator.isStringShorterThan(string, 50);
        this.email = string;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String string) throws MetadataException {
        MetadataValidator.isStringShorterThan(string, 50);
        this.phone = string;
    }

    public String getAddress1() {
        return this.address1;
    }

    public void setAddress1(String string) throws MetadataException {
        MetadataValidator.isStringShorterThan(string, 255);
        this.address1 = string;
    }

    public String getAddress2() {
        return this.address2;
    }

    public void setAddress2(String string) throws MetadataException {
        MetadataValidator.isStringShorterThan(string, 255);
        this.address2 = string;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String string) throws MetadataException {
        MetadataValidator.isStringShorterThan(string, 50);
        this.city = string;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String string) throws MetadataException {
        MetadataValidator.isStringShorterThan(string, 50);
        this.state = string;
    }

    public String getZipcode() {
        return this.zipcode;
    }

    public void setZipcode(String string) throws MetadataException {
        MetadataValidator.isStringShorterThan(string, 50);
        this.zipcode = string;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) throws MetadataException {
        if (!Person.isValidStatus(string)) {
            throw new MetadataException("The status specified (" + string + ") is not valid");
        }
        this.status = string;
    }

    public static boolean isValidStatus(String string) {
        boolean bl = true;
        if (string == null || !string.equals(STATUS_ACTIVE) && !string.equals(STATUS_INACTIVE)) {
            bl = false;
        }
        return bl;
    }

    public Collection getUserGroups() {
        return this.userGroups;
    }

    protected void setUserGroups(Collection collection) {
        this.userGroups = collection;
    }

    public void addUserGroup(UserGroup userGroup) {
        if (userGroup == null) {
            return;
        }
        if (!this.userGroups.contains(userGroup)) {
            this.userGroups.add(userGroup);
        }
    }

    public void removeUserGroup(UserGroup userGroup) {
        if (userGroup == null) {
            return;
        }
        if (this.userGroups != null && this.userGroups.contains(userGroup)) {
            this.userGroups.remove(userGroup);
        }
    }

    public void clearResources() {
        this.userGroups.clear();
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long l) {
        this.version = l;
    }

    public String toString() {
        return this.username;
    }

    public String toStringRepresentation(String string) {
        if (string == null) {
            string = "|";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Person");
        stringBuffer.append(string + "id=" + this.getId());
        stringBuffer.append(string + "firstname=" + this.getFirstname());
        stringBuffer.append(string + "surname=" + this.getSurname());
        stringBuffer.append(string + "organization=" + this.getOrganization());
        stringBuffer.append(string + "username=" + this.getUsername());
        stringBuffer.append(string + "email=" + this.getEmail());
        stringBuffer.append(string + "phone=" + this.getPhone());
        stringBuffer.append(string + "address1=" + this.getAddress1());
        stringBuffer.append(string + "address2=" + this.getAddress2());
        stringBuffer.append(string + "city=" + this.getCity());
        stringBuffer.append(string + "state=" + this.getState());
        stringBuffer.append(string + "zipcode=" + this.getZipcode());
        stringBuffer.append(string + "status=" + this.getStatus());
        return stringBuffer.toString();
    }

    public void setValuesFromStringRepresentation(String string, String string2) throws MetadataException {
        String string3 = string2;
        if (string3 == null) {
            string3 = "|";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
        String string4 = stringTokenizer.nextToken();
        if (!this.getClass().getName().equals(string4) && !this.getClass().getName().equals("moos.ssds.metadata." + string4)) {
            throw new MetadataException("The class specified by the first token (" + string4 + " does not match this class " + this.getClass().getName());
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            int n = string5.indexOf("=");
            String string6 = null;
            String string7 = null;
            if (n >= 0) {
                string6 = string5.substring(0, n);
                string7 = string5.substring(n + 1);
            } else {
                string6 = "";
                string7 = "";
            }
            if (string6.equalsIgnoreCase("id")) {
                try {
                    this.setId(new Long(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("Could not convert the value for id (" + string7 + ") to a Long");
                }
            }
            if (string6.equalsIgnoreCase("firstname")) {
                this.setFirstname(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("surname")) {
                this.setSurname(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("organization")) {
                this.setOrganization(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("username")) {
                this.setUsername(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("password")) {
                this.setPassword(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("email")) {
                this.setEmail(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("phone")) {
                this.setPhone(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("address1")) {
                this.setAddress1(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("address2")) {
                this.setAddress2(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("city")) {
                this.setCity(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("state")) {
                this.setState(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("zipcode")) {
                this.setZipcode(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("status")) {
                this.setStatus(string7);
                continue;
            }
            throw new MetadataException("The attribute specified by " + string6 + " is not a recognized field of " + this.getClass().getName());
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof Person)) {
            return false;
        }
        Person person = (Person)object;
        if (this.username == null || person.getUsername() == null) {
            return false;
        }
        return this.hashCode() == person.hashCode();
    }

    public int hashCode() {
        int n = 14;
        if (this.username != null) {
            n = 14 + this.username.hashCode();
        }
        return n;
    }
}

