/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import moos.ssds.metadata.CommentTag;
import moos.ssds.metadata.IMetadataObject;
import moos.ssds.metadata.util.MetadataException;
import moos.ssds.metadata.util.MetadataValidator;

public class HeaderDescription
implements IMetadataObject {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String description;
    private long byteOffset = 0L;
    private int numHeaderLines = 0;
    private long version = -1L;
    private Collection commentTags = new ArrayList();

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) throws MetadataException {
        MetadataValidator.isStringShorterThan(string, 255);
        this.description = string;
    }

    public long getByteOffset() {
        return this.byteOffset;
    }

    public void setByteOffset(long l) {
        this.byteOffset = l;
    }

    public void setByteOffset(String string) {
        this.setByteOffset(Long.parseLong(string));
    }

    public boolean hasByteOffset() {
        return this.byteOffset > 0L;
    }

    public int getNumHeaderLines() {
        return this.numHeaderLines;
    }

    public void setNumHeaderLines(int n) {
        this.numHeaderLines = n;
    }

    public void setNumHeaderLines(String string) {
        this.setNumHeaderLines(Integer.parseInt(string));
    }

    public boolean hasHeaderLines() {
        return this.numHeaderLines != 0;
    }

    public Collection getCommentTags() {
        return this.commentTags;
    }

    protected void setCommentTags(Collection collection) {
        this.commentTags = collection;
    }

    public Collection getCommentTagsAsStrings() {
        Iterator iterator = this.commentTags.iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        CommentTag commentTag = null;
        while (iterator.hasNext()) {
            commentTag = (CommentTag)iterator.next();
            arrayList.add(commentTag.getTagString());
        }
        return arrayList;
    }

    public boolean hasCommentTags() {
        return this.commentTags.size() > 0;
    }

    public void addCommentTag(CommentTag commentTag) {
        if (commentTag == null) {
            return;
        }
        if (!this.commentTags.contains(commentTag)) {
            this.commentTags.add(commentTag);
        }
    }

    public void addCommentTag(String string) {
        CommentTag commentTag = new CommentTag(string);
        this.addCommentTag(commentTag);
    }

    public void removeCommentTag(CommentTag commentTag) {
        if (commentTag == null) {
            return;
        }
        if (this.commentTags != null && this.commentTags.contains(commentTag)) {
            this.commentTags.remove(commentTag);
        }
    }

    public void removeCommentTag(String string) {
        CommentTag commentTag = new CommentTag(string);
        this.removeCommentTag(commentTag);
    }

    public void clearCommentTags() {
        this.commentTags.clear();
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long l) {
        this.version = l;
    }

    public String toStringRepresentation(String string) {
        if (string == null) {
            string = "|";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HeaderDescription");
        stringBuffer.append(string + "id=" + this.getId());
        stringBuffer.append(string + "description=" + this.getDescription());
        stringBuffer.append(string + "byteOffset=" + this.getByteOffset());
        stringBuffer.append(string + "numHeaderLines=" + this.getNumHeaderLines());
        return stringBuffer.toString();
    }

    public void setValuesFromStringRepresentation(String string, String string2) throws MetadataException {
        String string3 = string2;
        if (string3 == null) {
            string3 = "|";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
        String string4 = stringTokenizer.nextToken();
        if (!this.getClass().getName().equals(string4) && !this.getClass().getName().equals("moos.ssds.metadata." + string4)) {
            throw new MetadataException("The class specified by the first token (" + string4 + " does not match this class " + this.getClass().getName());
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            int n = string5.indexOf("=");
            String string6 = null;
            String string7 = null;
            if (n >= 0) {
                string6 = string5.substring(0, n);
                string7 = string5.substring(n + 1);
            } else {
                string6 = "";
                string7 = "";
            }
            if (string6.equalsIgnoreCase("id")) {
                try {
                    this.setId(new Long(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("Could not convert the value for id (" + string7 + ") to a Long");
                }
            }
            if (string6.equalsIgnoreCase("description")) {
                this.setDescription(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("byteOffset")) {
                try {
                    this.setByteOffset(Long.parseLong(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("The value specified for byteOffset (" + string7 + ") could not be converted to a Long: " + numberFormatException.getMessage());
                }
            }
            if (string6.equalsIgnoreCase("numHeaderLines")) {
                try {
                    this.setNumHeaderLines(Integer.parseInt(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("The value specified for numHeaderLines (" + string7 + ") could not be converted to a Long: " + numberFormatException.getMessage());
                }
            }
            throw new MetadataException("The attribute specified by " + string6 + " is not a recognized field of " + this.getClass().getName());
        }
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

