/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.metadata;

import java.util.Date;
import java.util.StringTokenizer;
import moos.ssds.metadata.DateRange;
import moos.ssds.metadata.IDateRange;
import moos.ssds.metadata.IDescription;
import moos.ssds.metadata.IMetadataObject;
import moos.ssds.metadata.util.MetadataException;
import moos.ssds.metadata.util.MetadataValidator;
import moos.ssds.util.DateUtils;
import moos.ssds.util.XmlDateFormat;

public class Event
implements IMetadataObject,
IDescription,
IDateRange {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String name;
    private String description;
    private Date startDate;
    private Date endDate;
    private IDateRange dateRange = new DateRange(this);
    private long version = -1L;
    private XmlDateFormat xmlDateFormat = new XmlDateFormat();

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) throws MetadataException {
        MetadataValidator.isObjectNull(string);
        MetadataValidator.isStringShorterThan(string, 50);
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) throws MetadataException {
        MetadataValidator.isStringShorterThan(string, 255);
        this.description = string;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date date) {
        this.startDate = date;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date date) {
        this.endDate = date;
    }

    public IDateRange getDateRange() {
        return this.dateRange;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long l) {
        this.version = l;
    }

    public String toStringRepresentation(String string) {
        if (string == null) {
            string = "|";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Event");
        stringBuffer.append(string + "id=" + this.getId());
        stringBuffer.append(string + "name=" + this.getName());
        stringBuffer.append(string + "description=" + this.getDescription());
        stringBuffer.append(string + "startDate=" + this.xmlDateFormat.format(this.startDate));
        stringBuffer.append(string + "endDate=" + this.xmlDateFormat.format(this.endDate));
        return stringBuffer.toString();
    }

    public void setValuesFromStringRepresentation(String string, String string2) throws MetadataException {
        String string3 = string2;
        if (string3 == null) {
            string3 = "|";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
        String string4 = stringTokenizer.nextToken();
        if (!this.getClass().getName().equals(string4) && !this.getClass().getName().equals("moos.ssds.metadata." + string4)) {
            throw new MetadataException("The class specified by the first token (" + string4 + " does not match this class " + this.getClass().getName());
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            int n = string5.indexOf("=");
            String string6 = null;
            String string7 = null;
            if (n >= 0) {
                string6 = string5.substring(0, n);
                string7 = string5.substring(n + 1);
            } else {
                string6 = "";
                string7 = "";
            }
            if (string6.equalsIgnoreCase("id")) {
                try {
                    this.setId(new Long(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("Could not convert the value for id (" + string7 + ") to a Long");
                }
            }
            if (string6.equalsIgnoreCase("name")) {
                this.setName(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("description")) {
                this.setDescription(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("startDate")) {
                this.setStartDate(this.xmlDateFormat.parse(string7));
                continue;
            }
            if (string6.equalsIgnoreCase("endDate")) {
                this.setEndDate(this.xmlDateFormat.parse(string7));
                continue;
            }
            throw new MetadataException("The attribute specified by " + string6 + " is not a recognized field of " + this.getClass().getName());
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof Event)) {
            return false;
        }
        Event event = (Event)object;
        if (this.name == null || event.getName() == null || this.startDate == null || event.getStartDate() == null || this.endDate == null || event.getEndDate() == null) {
            return false;
        }
        return this.hashCode() == event.hashCode();
    }

    public int hashCode() {
        int n = 3;
        if (this.name != null) {
            n += this.name.hashCode();
        }
        if (this.startDate != null) {
            n = 3 * n + new String(DateUtils.roundDateDownToSeconds(this.startDate).getTime() + "").hashCode();
        }
        if (this.endDate != null) {
            n = 5 * n + new String(DateUtils.roundDateDownToSeconds(this.endDate).getTime() + "").hashCode();
        }
        return n;
    }
}

