/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import moos.ssds.metadata.DeviceType;
import moos.ssds.metadata.IDescription;
import moos.ssds.metadata.IMetadataObject;
import moos.ssds.metadata.IResourceOwner;
import moos.ssds.metadata.Person;
import moos.ssds.metadata.Resource;
import moos.ssds.metadata.util.MetadataException;
import moos.ssds.metadata.util.MetadataValidator;
import org.doomdark.uuid.UUID;
import org.doomdark.uuid.UUIDGenerator;

public class Device
implements IMetadataObject,
IDescription,
IResourceOwner {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String uuid = null;
    private String name;
    private String description;
    private String mfgName;
    private String mfgModel;
    private String mfgSerialNumber;
    private String infoUrlList;
    private long version = -1L;
    private Person person;
    private DeviceType deviceType;
    private Collection resources = new ArrayList();

    public Device() {
        this.description = "";
        this.generateOwnUuid();
    }

    public Device(String string) throws MetadataException {
        this.setUuid(string);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String string) throws MetadataException {
        if (string == null || string.equals("")) {
            throw new MetadataException("uuidString cannot be null");
        }
        UUID uUID = null;
        try {
            uUID = UUID.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MetadataException("Could not convert " + string + " to a valid UUID: " + numberFormatException.getMessage());
        }
        if (uUID == null) {
            throw new MetadataException("Could not convert " + string + " to a UUID");
        }
        this.uuid = string;
    }

    public byte[] getUuidAsBytes() {
        byte[] byArray = null;
        if (this.getUuid() != null) {
            try {
                byArray = UUID.valueOf(this.uuid).toByteArray();
            }
            catch (NumberFormatException numberFormatException) {
                byArray = null;
            }
        }
        return byArray;
    }

    public void setUuidAsBytes(byte[] byArray) {
        UUID uUID = new UUID(byArray);
        if (uUID != null) {
            this.uuid = uUID.toString();
        }
    }

    public boolean generateOwnUuid() {
        boolean bl = false;
        UUID uUID = null;
        if (this.getUuid() != null) {
            try {
                uUID = UUID.valueOf(this.getUuid());
            }
            catch (NumberFormatException numberFormatException) {
                uUID = null;
            }
        }
        if (uUID != null) {
            return false;
        }
        UUIDGenerator uUIDGenerator = UUIDGenerator.getInstance();
        uUID = uUIDGenerator.generateTimeBasedUUID();
        this.uuid = uUID.toString();
        bl = true;
        return bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) throws MetadataException {
        MetadataValidator.isStringShorterThan(string, 50);
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) throws MetadataException {
        MetadataValidator.isStringShorterThan(string, 255);
        this.description = string;
    }

    public String getMfgName() {
        return this.mfgName;
    }

    public void setMfgName(String string) {
        this.mfgName = string;
    }

    public String getMfgModel() {
        return this.mfgModel;
    }

    public void setMfgModel(String string) {
        this.mfgModel = string;
    }

    public String getMfgSerialNumber() {
        return this.mfgSerialNumber;
    }

    public void setMfgSerialNumber(String string) {
        this.mfgSerialNumber = string;
    }

    public String getInfoUrlList() {
        return this.infoUrlList;
    }

    public void setInfoUrlList(String string) throws MetadataException {
        MetadataValidator.isStringShorterThan(string, 2048);
        this.infoUrlList = string;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public Collection getResources() {
        return this.resources;
    }

    protected void setResources(Collection collection) {
        this.resources = collection;
    }

    public void addResource(Resource resource) {
        if (resource == null) {
            return;
        }
        if (!this.resources.contains(resource)) {
            this.resources.add(resource);
        }
    }

    public void removeResource(Resource resource) {
        if (resource == null) {
            return;
        }
        if (this.resources != null && this.resources.contains(resource)) {
            this.resources.remove(resource);
        }
    }

    public void clearResources() {
        this.resources.clear();
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long l) {
        this.version = l;
    }

    public String toStringRepresentation(String string) {
        if (string == null) {
            string = "|";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Device");
        stringBuffer.append(string + "id=" + this.getId());
        stringBuffer.append(string + "uuid=" + this.getUuid());
        stringBuffer.append(string + "name=" + this.getName());
        stringBuffer.append(string + "description=" + this.getDescription());
        stringBuffer.append(string + "mfgName=" + this.getMfgName());
        stringBuffer.append(string + "mfgModel=" + this.getMfgModel());
        stringBuffer.append(string + "mfgSerialNumber=" + this.getMfgSerialNumber());
        stringBuffer.append(string + "infoUrlList=" + this.getInfoUrlList());
        return stringBuffer.toString();
    }

    public void setValuesFromStringRepresentation(String string, String string2) throws MetadataException {
        String string3 = string2;
        if (string3 == null) {
            string3 = "|";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
        String string4 = stringTokenizer.nextToken();
        if (!this.getClass().getName().equals(string4) && !this.getClass().getName().equals("moos.ssds.metadata." + string4)) {
            throw new MetadataException("The class specified by the first token (" + string4 + " does not match this class " + this.getClass().getName());
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            int n = string5.indexOf("=");
            String string6 = null;
            String string7 = null;
            if (n >= 0) {
                string6 = string5.substring(0, n);
                string7 = string5.substring(n + 1);
            } else {
                string6 = "";
                string7 = "";
            }
            if (string6.equalsIgnoreCase("id")) {
                try {
                    this.setId(new Long(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("Could not convert the value for id (" + string7 + ") to a Long");
                }
            }
            if (string6.equalsIgnoreCase("uuid")) {
                this.setUuid(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("name")) {
                this.setName(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("description")) {
                this.setDescription(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("mfgName")) {
                this.setMfgName(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("mfgModel")) {
                this.setMfgModel(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("mfgSerialNumber")) {
                this.setMfgSerialNumber(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("infoUrlList")) {
                this.setInfoUrlList(string7);
                continue;
            }
            throw new MetadataException("The attribute specified by " + string6 + " is not a recognized field of " + this.getClass().getName());
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof Device)) {
            return false;
        }
        Device device = (Device)object;
        if (this.uuid == null || device.getUuid() == null) {
            return false;
        }
        return this.hashCode() == device.hashCode();
    }

    public int hashCode() {
        int n = 11;
        if (this.uuid != null) {
            n = 31 * n + this.uuid.hashCode();
        }
        return n;
    }
}

