/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.metadata;

import java.io.Serializable;
import java.util.Date;
import moos.ssds.metadata.IDateRange;

public class DateRange
implements Serializable,
IDateRange {
    private static final long serialVersionUID = 1L;
    private Date startDate = null;
    private Date endDate;
    private boolean proxy = false;
    private IDateRange dateRange = null;
    public static final int BEFORE = -1;
    public static final int AFTER = 1;
    public static final int DURING = 0;

    public DateRange() {
        this.proxy = false;
    }

    public DateRange(IDateRange iDateRange) {
        this.setDateRange(iDateRange);
    }

    public Date getStartDate() {
        if (this.proxy) {
            return this.dateRange.getStartDate();
        }
        return this.startDate;
    }

    public void setStartDate(Date date) {
        if (this.proxy) {
            this.dateRange.setStartDate(date);
        } else {
            this.startDate = date;
        }
    }

    public Date getEndDate() {
        if (this.proxy) {
            return this.dateRange.getEndDate();
        }
        return this.endDate;
    }

    public void setEndDate(Date date) {
        if (this.proxy) {
            this.dateRange.setEndDate(date);
        } else {
            this.endDate = date;
        }
    }

    public IDateRange getDateRange() {
        if (this.proxy) {
            return this.dateRange;
        }
        return this;
    }

    public void setDateRange(IDateRange iDateRange) {
        this.dateRange = iDateRange;
        this.proxy = this.dateRange != null;
    }

    public boolean before(Date date) {
        return date.after(this.getEndDate());
    }

    public boolean after(Date date) {
        return date.before(this.getStartDate());
    }

    public boolean during(Date date) {
        boolean bl = false;
        if (date.after(this.getStartDate()) && date.before(this.getEndDate())) {
            bl = true;
        }
        return bl;
    }

    public int relation(Date date) {
        int n = 0;
        if (this.before(date)) {
            n = -1;
        } else if (this.after(date)) {
            n = 1;
        }
        return n;
    }

    public long duration() {
        if (this.getEndDate() != null && this.getStartDate() != null) {
            return this.getEndDate().getTime() - this.getStartDate().getTime();
        }
        return 0L;
    }

    public long durationSeconds() {
        if (this.duration() != 0L) {
            return this.duration() / 1000L;
        }
        return 0L;
    }

    public float durationHours() {
        if (this.duration() != 0L) {
            int n = (int)((float)this.duration() / 60.0f / 60.0f);
            return (float)n / 1000.0f;
        }
        return 0.0f;
    }

    public float durationDays() {
        if (this.duration() != 0L) {
            int n = (int)((float)this.duration() / 60.0f / 60.0f / 24.0f);
            return (float)n / 1000.0f;
        }
        return 0.0f;
    }
}

