/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.metadata;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import moos.ssds.metadata.DataContainer;
import moos.ssds.metadata.DataProducerGroup;
import moos.ssds.metadata.DateRange;
import moos.ssds.metadata.Device;
import moos.ssds.metadata.Event;
import moos.ssds.metadata.IDateRange;
import moos.ssds.metadata.IDescription;
import moos.ssds.metadata.IMetadataObject;
import moos.ssds.metadata.IResourceOwner;
import moos.ssds.metadata.Keyword;
import moos.ssds.metadata.Person;
import moos.ssds.metadata.Resource;
import moos.ssds.metadata.Software;
import moos.ssds.metadata.util.MetadataException;
import moos.ssds.metadata.util.MetadataValidator;
import moos.ssds.util.XmlDateFormat;
import org.apache.log4j.Logger;

public class DataProducer
implements IMetadataObject,
IDescription,
IResourceOwner,
IDateRange {
    private PropertyChangeSupport changeSupport = null;
    private static final long serialVersionUID = 1L;
    private Long id;
    private String name;
    private String description;
    private String dataProducerType = "Deployment";
    private Date startDate;
    private Date endDate;
    private IDateRange dateRange = new DateRange(this);
    private String role;
    private Double nominalLatitude = null;
    private Float nominalLatitudeAccuracy = null;
    private Double nominalLongitude = null;
    private Float nominalLongitudeAccuracy = null;
    private Float nominalDepth = null;
    private Float nominalDepthAccuracy = null;
    private Float nominalBenthicAltitude = null;
    private Float nominalBenthicAltitudeAccuracy = null;
    private Float xoffset = null;
    private Float yoffset = null;
    private Float zoffset = null;
    private String orientationDescription = null;
    private String x3DOrientationText = null;
    private String hostName;
    private Person person;
    private Device device;
    private Software software;
    private DataProducer parentDataProducer;
    private Collection childDataProducers = new ArrayList();
    private Collection dataProducerGroups = new ArrayList();
    private Collection inputs = new ArrayList();
    private Collection outputs = new ArrayList();
    private Collection resources = new ArrayList();
    private Collection keywords = new ArrayList();
    private Collection events = new ArrayList();
    private long version = -1L;
    public static final String TYPE_DEPLOYMENT = "Deployment";
    public static final String TYPE_PROCESS_RUN = "ProcessRun";
    public static final String ROLE_SENSOR = "sensor";
    public static final String ROLE_INSTRUMENT = "instrument";
    public static final String ROLE_PLATFORM = "platform";
    public static final String ROLE_OBSERVATORY = "observatory";
    private XmlDateFormat xmlDateFormat = new XmlDateFormat();
    static Logger logger = Logger.getLogger(DataProducer.class);

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) throws MetadataException {
        MetadataValidator.isObjectNull(string);
        MetadataValidator.isStringShorterThan(string, 2048);
        String string2 = string;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("name", string2, string);
        }
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) throws MetadataException {
        MetadataValidator.isStringShorterThan(string, 255);
        String string2 = this.description;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("description", string2, string);
        }
        this.description = string;
    }

    public String getDataProducerType() {
        return this.dataProducerType;
    }

    public void setDataProducerType(String string) throws MetadataException {
        if (!DataProducer.isValidDataProducerType(string)) {
            throw new MetadataException("The specified dataProducerType (" + string + ") does not match a constant defined in the class");
        }
        String string2 = this.dataProducerType;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("dataProducerType", string2, string);
        }
        this.dataProducerType = string;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public long startDateAsEsecs() {
        return this.startDate.getTime() / 1000L;
    }

    public long endDateAsEsecs() {
        return this.startDate.getTime() / 1000L;
    }

    public void setStartDate(Date date) {
        Date date2 = this.startDate;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("startDate", date2, date);
        }
        this.startDate = date;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date date) {
        Date date2 = this.endDate;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("endDate", date2, date);
        }
        this.endDate = date;
    }

    public IDateRange getDateRange() {
        return this.dateRange;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String string) throws MetadataException {
        if (!DataProducer.isValidRole(string)) {
            throw new MetadataException("The role specified (" + string + ") does not match a constant defined in this class");
        }
        String string2 = this.role;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("role", string2, string);
        }
        this.role = string;
    }

    public Double getNominalLatitude() {
        return this.nominalLatitude;
    }

    public void setNominalLatitude(Double d) throws MetadataException {
        MetadataValidator.isValueBetween(d, -90.0, 90.0);
        Double d2 = this.nominalLatitude;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("nominalLatitude", d2, d);
        }
        this.nominalLatitude = d;
    }

    public Float getNominalLatitudeAccuracy() {
        return this.nominalLatitudeAccuracy;
    }

    public void setNominalLatitudeAccuracy(Float f) {
        Float f2 = this.nominalLatitudeAccuracy;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("nominalLatitudeAccuracy", f2, f);
        }
        this.nominalLatitudeAccuracy = f;
    }

    public Double getNominalLongitude() {
        return this.nominalLongitude;
    }

    public void setNominalLongitude(Double d) throws MetadataException {
        MetadataValidator.isValueBetween(d, -360.0, 360.0);
        Double d2 = this.nominalLongitude;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("nominalLongitude", d2, d);
        }
        this.nominalLongitude = d;
    }

    public Float getNominalLongitudeAccuracy() {
        return this.nominalLongitudeAccuracy;
    }

    public void setNominalLongitudeAccuracy(Float f) {
        Float f2 = this.nominalLongitudeAccuracy;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("nominalLongitudeAccuracy", f2, f);
        }
        this.nominalLongitudeAccuracy = f;
    }

    public Float getNominalDepth() {
        return this.nominalDepth;
    }

    public void setNominalDepth(Float f) throws MetadataException {
        Float f2 = this.nominalDepth;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("nominalDepth", f2, f);
        }
        this.nominalDepth = f;
    }

    public Float getNominalDepthAccuracy() {
        return this.nominalDepthAccuracy;
    }

    public void setNominalDepthAccuracy(Float f) {
        Float f2 = this.nominalDepthAccuracy;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("nominalDepthAccuracy", f2, f);
        }
        this.nominalDepthAccuracy = f;
    }

    public Float getNominalBenthicAltitude() {
        return this.nominalBenthicAltitude;
    }

    public void setNominalBenthicAltitude(Float f) {
        Float f2 = this.nominalBenthicAltitude;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("nominalBenthicAltitude", f2, f);
        }
        this.nominalBenthicAltitude = f;
    }

    public Float getNominalBenthicAltitudeAccuracy() {
        return this.nominalBenthicAltitudeAccuracy;
    }

    public void setNominalBenthicAltitudeAccuracy(Float f) {
        Float f2 = this.nominalBenthicAltitudeAccuracy;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("nominalBenthicAltitudeAccuracy", f2, f);
        }
        this.nominalBenthicAltitudeAccuracy = f;
    }

    public Float getXoffset() {
        return this.xoffset;
    }

    public void setXoffset(Float f) {
        Float f2 = this.xoffset;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("xoffset", f2, f);
        }
        this.xoffset = f;
    }

    public Float getYoffset() {
        return this.yoffset;
    }

    public void setYoffset(Float f) {
        Float f2 = f;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("yoffset", f2, f);
        }
        this.yoffset = f;
    }

    public Float getZoffset() {
        return this.zoffset;
    }

    public void setZoffset(Float f) {
        Float f2 = this.zoffset;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("zoffset", f2, f);
        }
        this.zoffset = f;
    }

    public String getOrientationDescription() {
        return this.orientationDescription;
    }

    public void setOrientationDescription(String string) {
        String string2 = this.orientationDescription;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("orientationDescription", string2, string);
        }
        this.orientationDescription = string;
    }

    public String getX3DOrientationText() {
        return this.x3DOrientationText;
    }

    public void setX3DOrientationText(String string) {
        String string2 = this.x3DOrientationText;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("x3DOrientationText", string2, string);
        }
        this.x3DOrientationText = string;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String string) {
        String string2 = this.hostName;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("hostName", string2, string);
        }
        this.hostName = string;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        Person person2 = this.person;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("person", person2, person);
        }
        this.person = person;
    }

    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        Device device2 = this.device;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("device", device2, device);
        }
        this.device = device;
    }

    public Software getSoftware() {
        return this.software;
    }

    public void setSoftware(Software software) {
        Software software2 = this.software;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("software", software2, software);
        }
        this.software = software;
    }

    public DataProducer getParentDataProducer() {
        return this.parentDataProducer;
    }

    public void setParentDataProducer(DataProducer dataProducer) {
        DataProducer dataProducer2 = this.parentDataProducer;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("parentDataProducer", dataProducer2, dataProducer);
        }
        this.parentDataProducer = dataProducer;
    }

    public Collection getChildDataProducers() {
        return this.childDataProducers;
    }

    public void setChildDataProducers(Collection collection) {
        this.childDataProducers = collection;
    }

    public void addChildDataProducer(DataProducer dataProducer) {
        if (dataProducer == null) {
            return;
        }
        if (dataProducer.equals(this)) {
            return;
        }
        dataProducer.setParentDataProducer(this);
        if (!this.childDataProducers.contains(dataProducer)) {
            this.childDataProducers.add(dataProducer);
        }
    }

    public void removeChildDataProducer(DataProducer dataProducer) {
        if (dataProducer == null) {
            return;
        }
        dataProducer.setParentDataProducer(null);
        if (this.childDataProducers != null && this.childDataProducers.contains(dataProducer)) {
            this.childDataProducers.remove(dataProducer);
        }
    }

    public void clearChildDataProducers() {
        for (DataProducer dataProducer : this.childDataProducers) {
            dataProducer.setParentDataProducer(null);
        }
        this.childDataProducers.clear();
    }

    public Collection getDataProducerGroups() {
        return this.dataProducerGroups;
    }

    protected void setDataProducerGroups(Collection collection) {
        this.dataProducerGroups = collection;
    }

    public void addDataProducerGroup(DataProducerGroup dataProducerGroup) {
        if (dataProducerGroup == null) {
            return;
        }
        if (!this.dataProducerGroups.contains(dataProducerGroup)) {
            this.dataProducerGroups.add(dataProducerGroup);
        }
    }

    public void removeDataProducerGroup(DataProducerGroup dataProducerGroup) {
        if (dataProducerGroup == null) {
            return;
        }
        if (this.dataProducerGroups != null && this.dataProducerGroups.contains(dataProducerGroup)) {
            this.dataProducerGroups.remove(dataProducerGroup);
        }
    }

    public void clearDataProducerGroups() {
        this.dataProducerGroups.clear();
    }

    public Collection getInputs() {
        return this.inputs;
    }

    protected void setInputs(Collection collection) {
        this.inputs = collection;
    }

    public void addInput(DataContainer dataContainer) {
        if (dataContainer == null) {
            return;
        }
        if (!dataContainer.getConsumers().contains(this)) {
            dataContainer.getConsumers().add(this);
        }
        if (!this.inputs.contains(dataContainer)) {
            this.inputs.add(dataContainer);
        }
    }

    public void removeInput(DataContainer dataContainer) {
        if (dataContainer == null) {
            return;
        }
        if (this.inputs != null && this.inputs.contains(dataContainer)) {
            if (dataContainer.getConsumers().contains(this)) {
                dataContainer.getConsumers().remove(this);
            }
            this.inputs.remove(dataContainer);
        }
    }

    public void clearInputs() {
        for (DataContainer dataContainer : this.inputs) {
            dataContainer.getConsumers().remove(this);
        }
        this.dataProducerGroups.clear();
    }

    public Collection getOutputs() {
        return this.outputs;
    }

    protected void setOutputs(Collection collection) {
        this.outputs = collection;
    }

    public void addOutput(DataContainer dataContainer) {
        if (dataContainer == null) {
            return;
        }
        if (dataContainer.getCreator() != null) {
            dataContainer.getCreator().getOutputs().remove(dataContainer);
        }
        dataContainer.setCreator(this);
        if (!this.outputs.contains(dataContainer)) {
            this.outputs.add(dataContainer);
        }
    }

    public void removeOutput(DataContainer dataContainer) {
        if (dataContainer == null) {
            return;
        }
        dataContainer.setCreator(null);
        if (this.outputs != null && this.outputs.contains(dataContainer)) {
            this.outputs.remove(dataContainer);
        }
    }

    public void clearOutputs() {
        if (this.outputs != null) {
            Iterator iterator = this.outputs.iterator();
            while (iterator.hasNext()) {
                ((DataContainer)iterator.next()).setCreator(null);
            }
            this.outputs.clear();
        }
    }

    public Collection getResources() {
        return this.resources;
    }

    protected void setResources(Collection collection) {
        this.resources = collection;
    }

    public void addResource(Resource resource) {
        if (resource == null) {
            return;
        }
        if (!this.resources.contains(resource)) {
            this.resources.add(resource);
        }
    }

    public void removeResource(Resource resource) {
        if (resource == null) {
            return;
        }
        if (this.resources != null && this.resources.contains(resource)) {
            this.resources.remove(resource);
        }
    }

    public void clearResources() {
        this.resources.clear();
    }

    public Collection getKeywords() {
        return this.keywords;
    }

    protected void setKeywords(Collection collection) {
        this.keywords = collection;
    }

    public void addKeyWord(Keyword keyword) {
        if (keyword == null) {
            return;
        }
        if (!this.keywords.contains(keyword)) {
            this.keywords.add(keyword);
        }
    }

    public void removeKeyWord(Keyword keyword) {
        if (keyword == null) {
            return;
        }
        if (this.keywords != null && this.keywords.contains(keyword)) {
            this.keywords.remove(keyword);
        }
    }

    public void clearKeywords() {
        this.keywords.clear();
    }

    public Collection getEvents() {
        return this.events;
    }

    protected void setEvents(Collection collection) {
        this.events = collection;
    }

    public void addEvent(Event event) {
        if (event == null) {
            return;
        }
        if (!this.events.contains(event)) {
            this.events.add(event);
        }
    }

    public void removeEvent(Event event) {
        if (event == null) {
            return;
        }
        if (this.events != null && this.events.contains(event)) {
            this.events.remove(event);
        }
    }

    public void clearEvents() {
        this.events.clear();
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long l) {
        this.version = l;
    }

    public static boolean isValidDataProducerType(String string) {
        boolean bl = true;
        if (string == null || !string.equals(TYPE_DEPLOYMENT) && !string.equals(TYPE_PROCESS_RUN)) {
            bl = false;
        }
        return bl;
    }

    public static boolean isValidRole(String string) {
        boolean bl = true;
        if (string == null || !string.equals(ROLE_INSTRUMENT) && !string.equals(ROLE_OBSERVATORY) && !string.equals(ROLE_PLATFORM) && !string.equals(ROLE_SENSOR)) {
            bl = false;
        }
        return bl;
    }

    public String toStringRepresentation(String string) {
        if (string == null) {
            string = "|";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DataProducer");
        stringBuffer.append(string + "id=" + this.getId());
        stringBuffer.append(string + "name=" + this.getName());
        stringBuffer.append(string + "description=" + this.getDescription());
        stringBuffer.append(string + "dataProducerType=" + this.getDataProducerType());
        stringBuffer.append(string + "startDate=" + this.xmlDateFormat.format(this.startDate));
        stringBuffer.append(string + "endDate=" + this.xmlDateFormat.format(this.endDate));
        stringBuffer.append(string + "role=" + this.getRole());
        stringBuffer.append(string + "nominalLatitude=" + this.getNominalLatitude());
        stringBuffer.append(string + "nominalLatitudeAccuracy=" + this.getNominalLatitudeAccuracy());
        stringBuffer.append(string + "nominalLongitude=" + this.getNominalLongitude());
        stringBuffer.append(string + "nominalLongitudeAccuracy=" + this.getNominalLongitudeAccuracy());
        stringBuffer.append(string + "nominalDepth=" + this.getNominalDepth());
        stringBuffer.append(string + "nominalDepthAccuracy=" + this.getNominalDepthAccuracy());
        stringBuffer.append(string + "nominalBenthicAltitude=" + this.getNominalBenthicAltitude());
        stringBuffer.append(string + "nominalBenthicAltitudeAccuracy=" + this.getNominalBenthicAltitudeAccuracy());
        stringBuffer.append(string + "xoffset=" + this.getXoffset());
        stringBuffer.append(string + "yoffset=" + this.getYoffset());
        stringBuffer.append(string + "zoffset=" + this.getZoffset());
        stringBuffer.append(string + "orientationDescription=" + this.getOrientationDescription());
        stringBuffer.append(string + "x3DOrientation=" + this.getX3DOrientationText());
        stringBuffer.append(string + "hostName=" + this.getHostName());
        return stringBuffer.toString();
    }

    public void setValuesFromStringRepresentation(String string, String string2) throws MetadataException {
        String string3 = string2;
        if (string3 == null) {
            string3 = "|";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
        String string4 = stringTokenizer.nextToken();
        if (!this.getClass().getName().equals(string4) && !this.getClass().getName().equals("moos.ssds.metadata." + string4)) {
            throw new MetadataException("The class specified by the first token (" + string4 + " does not match this class " + this.getClass().getName());
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            int n = string5.indexOf("=");
            String string6 = null;
            String string7 = null;
            if (n >= 0) {
                string6 = string5.substring(0, n);
                string7 = string5.substring(n + 1);
            } else {
                string6 = "";
                string7 = "";
            }
            if (string6.equalsIgnoreCase("id")) {
                try {
                    this.setId(new Long(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("Could not convert the value for id (" + string7 + ") to a Long");
                }
            }
            if (string6.equalsIgnoreCase("name")) {
                this.setName(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("description")) {
                this.setDescription(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("dataProducerType")) {
                this.setDataProducerType(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("startDate")) {
                this.setStartDate(this.xmlDateFormat.parse(string7));
                continue;
            }
            if (string6.equalsIgnoreCase("endDate")) {
                this.setEndDate(this.xmlDateFormat.parse(string7));
                continue;
            }
            if (string6.equalsIgnoreCase("role")) {
                this.setRole(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("nominalLatitude")) {
                try {
                    this.setNominalLatitude(Double.valueOf(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("The value specified for nominalLatitude (" + string7 + ") could not be converted to a Double: " + numberFormatException.getMessage());
                }
            }
            if (string6.equalsIgnoreCase("nominalLatitudeAccuracy")) {
                try {
                    this.setNominalLatitudeAccuracy(Float.valueOf(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("The value specified for nominalLatitudeAccuracy (" + string7 + ") could not be converted to a Float: " + numberFormatException.getMessage());
                }
            }
            if (string6.equalsIgnoreCase("nominalLongitude")) {
                try {
                    this.setNominalLongitude(Double.valueOf(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("The value specified for nominalLongitude (" + string7 + ") could not be converted to a Double: " + numberFormatException.getMessage());
                }
            }
            if (string6.equalsIgnoreCase("nominalLongitudeAccuracy")) {
                try {
                    this.setNominalLongitudeAccuracy(Float.valueOf(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("The value specified for nominalLongitudeAccuracy (" + string7 + ") could not be converted to a Float: " + numberFormatException.getMessage());
                }
            }
            if (string6.equalsIgnoreCase("nominalDepth")) {
                try {
                    this.setNominalDepth(Float.valueOf(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("The value specified for nominalDepth (" + string7 + ") could not be converted to a Float: " + numberFormatException.getMessage());
                }
            }
            if (string6.equalsIgnoreCase("nominalDepthAccuracy")) {
                try {
                    this.setNominalDepthAccuracy(Float.valueOf(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("The value specified for nominalDepthAccuracy (" + string7 + ") could not be converted to a Float: " + numberFormatException.getMessage());
                }
            }
            if (string6.equalsIgnoreCase("nominalBenthicAltitude")) {
                try {
                    this.setNominalBenthicAltitude(Float.valueOf(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("The value specified for nominalBenthicAltitude (" + string7 + ") could not be converted to a Float: " + numberFormatException.getMessage());
                }
            }
            if (string6.equalsIgnoreCase("nominalBenthicAltitudeAccuracy")) {
                try {
                    this.setNominalBenthicAltitudeAccuracy(Float.valueOf(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("The value specified for nominalBenthicAltitudeAccuracy (" + string7 + ") could not be converted to a Float: " + numberFormatException.getMessage());
                }
            }
            if (string6.equalsIgnoreCase("xoffset")) {
                try {
                    this.setXoffset(Float.valueOf(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("The value specified for xoffset (" + string7 + ") could not be converted to a Float: " + numberFormatException.getMessage());
                }
            }
            if (string6.equalsIgnoreCase("yoffset")) {
                try {
                    this.setYoffset(Float.valueOf(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("The value specified for yoffset (" + string7 + ") could not be converted to a Float: " + numberFormatException.getMessage());
                }
            }
            if (string6.equalsIgnoreCase("zoffset")) {
                try {
                    this.setZoffset(Float.valueOf(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("The value specified for zoffset (" + string7 + ") could not be converted to a Float: " + numberFormatException.getMessage());
                }
            }
            if (string6.equalsIgnoreCase("orientationDescription")) {
                this.setOrientationDescription(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("x3DOrientationText")) {
                this.setX3DOrientationText(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("hostName")) {
                this.setHostName(string7);
                continue;
            }
            throw new MetadataException("The attribute specified by " + string6 + " is not a recognized field of " + this.getClass().getName());
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof DataProducer)) {
            return false;
        }
        DataProducer dataProducer = (DataProducer)object;
        if (!this.dataProducerType.equals(dataProducer.getDataProducerType())) {
            return false;
        }
        if (this.name == null || dataProducer.getName() == null || this.dataProducerType == null || dataProducer.getDataProducerType() == null) {
            return false;
        }
        return this.hashCode() == dataProducer.hashCode();
    }

    public int hashCode() {
        int n = 9;
        if (this.dataProducerType != null) {
            n += this.dataProducerType.hashCode();
        }
        if (this.name != null) {
            n = 7 * n + this.name.hashCode();
        }
        if (this.outputs != null && this.outputs.size() > 0) {
            Iterator iterator = this.outputs.iterator();
            while (iterator.hasNext()) {
                n += iterator.next().hashCode();
            }
        }
        return n;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
            this.changeSupport.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null && propertyChangeListener != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }
}

