/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.metadata;

import java.util.StringTokenizer;
import moos.ssds.metadata.IDescription;
import moos.ssds.metadata.IMetadataObject;
import moos.ssds.metadata.util.MetadataException;
import moos.ssds.metadata.util.MetadataValidator;

public class DataContainerGroup
implements IMetadataObject,
IDescription {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String name;
    private String description;
    private long version = -1L;

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) throws MetadataException {
        MetadataValidator.isObjectNull(string);
        MetadataValidator.isStringShorterThan(string, 50);
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) throws MetadataException {
        MetadataValidator.isStringShorterThan(string, 255);
        this.description = string;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long l) {
        this.version = l;
    }

    public String toStringRepresentation(String string) {
        if (string == null) {
            string = "|";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DataContainerGroup");
        stringBuffer.append(string + "id=" + this.getId());
        stringBuffer.append(string + "name=" + this.getName());
        stringBuffer.append(string + "description=" + this.getDescription());
        return stringBuffer.toString();
    }

    public void setValuesFromStringRepresentation(String string, String string2) throws MetadataException {
        String string3 = string2;
        if (string3 == null) {
            string3 = "|";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
        String string4 = stringTokenizer.nextToken();
        if (!this.getClass().getName().equals(string4) && !this.getClass().getName().equals("moos.ssds.metadata." + string4)) {
            throw new MetadataException("The class specified by the first token (" + string4 + " does not match this class " + this.getClass().getName());
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            int n = string5.indexOf("=");
            String string6 = null;
            String string7 = null;
            if (n >= 0) {
                string6 = string5.substring(0, n);
                string7 = string5.substring(n + 1);
            } else {
                string6 = "";
                string7 = "";
            }
            if (string6.equalsIgnoreCase("id")) {
                try {
                    this.setId(new Long(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("Could not convert the value for id (" + string7 + ") to a Long");
                }
            }
            if (string6.equalsIgnoreCase("name")) {
                this.setName(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("description")) {
                this.setDescription(string7);
                continue;
            }
            throw new MetadataException("The attribute specified by " + string6 + " is not a recognized field of " + this.getClass().getName());
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof DataContainerGroup)) {
            return false;
        }
        DataContainerGroup dataContainerGroup = (DataContainerGroup)object;
        if (this.name == null || dataContainerGroup.getName() == null) {
            return false;
        }
        return this.hashCode() == dataContainerGroup.hashCode();
    }

    public int hashCode() {
        int n = 3;
        if (this.name != null) {
            n += this.name.hashCode();
        }
        return n;
    }
}

