/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.metadata;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.StringTokenizer;
import moos.ssds.metadata.DataContainerGroup;
import moos.ssds.metadata.DataProducer;
import moos.ssds.metadata.DateRange;
import moos.ssds.metadata.HeaderDescription;
import moos.ssds.metadata.IDateRange;
import moos.ssds.metadata.IDescription;
import moos.ssds.metadata.IMetadataObject;
import moos.ssds.metadata.IResourceOwner;
import moos.ssds.metadata.Keyword;
import moos.ssds.metadata.Person;
import moos.ssds.metadata.RecordDescription;
import moos.ssds.metadata.RecordVariable;
import moos.ssds.metadata.Resource;
import moos.ssds.metadata.util.MetadataException;
import moos.ssds.metadata.util.MetadataValidator;
import moos.ssds.util.XmlDateFormat;
import org.apache.log4j.Logger;

public class DataContainer
implements IMetadataObject,
IDescription,
IResourceOwner,
IDateRange {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String name;
    private String description;
    private String dataContainerType = "File";
    private Date startDate;
    private Date endDate;
    private IDateRange dateRange = new DateRange(this);
    private Boolean original = new Boolean(false);
    private String uriString;
    private Long contentLength;
    private String mimeType;
    private Long numberOfRecords;
    private Boolean dodsAccessible = new Boolean(false);
    private String dodsUrlString;
    private Boolean noNetCDF = new Boolean(true);
    private Double minLatitude;
    private Double maxLatitude;
    private Double minLongitude;
    private Double maxLongitude;
    private Float minDepth;
    private Float maxDepth;
    private Person person;
    private HeaderDescription headerDescription;
    private RecordDescription recordDescription;
    private Collection dataContainerGroups = new ArrayList();
    private Collection keywords = new ArrayList();
    private Collection resources = new ArrayList();
    private DataProducer creator;
    private Collection consumers = new ArrayList();
    private long version = -1L;
    private XmlDateFormat xmlDateFormat = new XmlDateFormat();
    public static final String TYPE_FILE = "File";
    public static final String TYPE_STREAM = "Stream";
    static Logger logger = Logger.getLogger(DataContainer.class);

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) throws MetadataException {
        MetadataValidator.isStringShorterThan(string, 50);
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) throws MetadataException {
        MetadataValidator.isStringShorterThan(string, 255);
        this.description = string;
    }

    public String getDataContainerType() {
        return this.dataContainerType;
    }

    public void setDataContainerType(String string) throws MetadataException {
        if (!DataContainer.isValidDataContainerType(string)) {
            throw new MetadataException("The type passed in " + string + " does not match one of the constants " + "defined for DataContainer");
        }
        this.dataContainerType = string;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date date) {
        this.startDate = date;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date date) {
        this.endDate = date;
    }

    public IDateRange getDateRange() {
        return this.dateRange;
    }

    public Boolean isOriginal() {
        return this.original;
    }

    public void setOriginal(Boolean bl) {
        this.original = bl;
    }

    public String getUriString() {
        return this.uriString;
    }

    public void setUriString(String string) throws MetadataException {
        MetadataValidator.isObjectNull(string);
        MetadataValidator.isStringShorterThan(string, 2048);
        this.uriString = string;
    }

    public URI getUri() {
        URI uRI = null;
        uRI = URI.create(this.uriString);
        return uRI;
    }

    public void setUri(URI uRI) throws MetadataException {
        this.setUriString(uRI.toASCIIString());
    }

    public URL getUrl() {
        URL uRL = null;
        try {
            uRL = this.getUri().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        return uRL;
    }

    public void setUrl(URL uRL) throws MetadataException {
        this.setUriString(uRL.toExternalForm());
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(Long l) {
        this.contentLength = l;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String string) {
        this.mimeType = string;
    }

    public Long getNumberOfRecords() {
        return this.numberOfRecords;
    }

    public void setNumberOfRecords(Long l) {
        this.numberOfRecords = l;
    }

    public Boolean isDodsAccessible() {
        return this.dodsAccessible;
    }

    public void setDodsAccessible(Boolean bl) {
        this.dodsAccessible = bl;
    }

    public String getDODSUrlString() {
        return this.dodsUrlString;
    }

    public void setDODSUrlString(String string) throws MetadataException {
        MetadataValidator.isStringShorterThan(string, 2048);
        this.dodsUrlString = string;
    }

    public URL getDODSUrl() {
        if (this.dodsUrlString != null) {
            URI uRI = null;
            uRI = URI.create(this.dodsUrlString);
            URL uRL = null;
            try {
                uRL = uRI.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                uRL = null;
            }
            return uRL;
        }
        return null;
    }

    public void setDODSUrl(URL uRL) throws MetadataException {
        this.setDODSUrlString(uRL.toExternalForm());
    }

    public Boolean isNoNetCDF() {
        return this.noNetCDF;
    }

    public void setNoNetCDF(Boolean bl) {
        this.noNetCDF = bl;
    }

    public Double getMinLatitude() {
        return this.minLatitude;
    }

    public void setMinLatitude(Double d) throws MetadataException {
        MetadataValidator.isValueBetween(d, -90.0, 90.0);
        this.minLatitude = d;
    }

    public Double getMaxLatitude() {
        return this.maxLatitude;
    }

    public void setMaxLatitude(Double d) throws MetadataException {
        MetadataValidator.isValueBetween(d, -90.0, 90.0);
        this.maxLatitude = d;
    }

    public Double getMinLongitude() {
        return this.minLongitude;
    }

    public void setMinLongitude(Double d) throws MetadataException {
        MetadataValidator.isValueBetween(d, -360.0, 360.0);
        this.minLongitude = d;
    }

    public Double getMaxLongitude() {
        return this.maxLongitude;
    }

    public void setMaxLongitude(Double d) throws MetadataException {
        MetadataValidator.isValueBetween(d, -360.0, 360.0);
        this.maxLongitude = d;
    }

    public Float getMinDepth() {
        return this.minDepth;
    }

    public void setMinDepth(Float f) throws MetadataException {
        MetadataValidator.isValueGreaterThan(f, 0.0f);
        this.minDepth = f;
    }

    public Float getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(Float f) throws MetadataException {
        MetadataValidator.isValueGreaterThan(f, 0.0f);
        this.maxDepth = f;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public HeaderDescription getHeaderDescription() {
        return this.headerDescription;
    }

    public void setHeaderDescription(HeaderDescription headerDescription) {
        this.headerDescription = headerDescription;
    }

    public RecordDescription getRecordDescription() {
        return this.recordDescription;
    }

    public void setRecordDescription(RecordDescription recordDescription) {
        this.recordDescription = recordDescription;
    }

    public Collection getRecordVariables() {
        Collection collection = new ArrayList();
        if (this.recordDescription != null) {
            collection = this.recordDescription.getRecordVariables();
        }
        return collection;
    }

    public void addRecordVariable(RecordVariable recordVariable) {
        if (recordVariable != null) {
            if (this.recordDescription == null) {
                this.recordDescription = new RecordDescription();
                try {
                    this.recordDescription.setRecordType(new Long(0L));
                }
                catch (MetadataException metadataException) {
                    // empty catch block
                }
            }
            this.recordDescription.addRecordVariable(recordVariable);
        }
    }

    public Collection getDataContainerGroups() {
        return this.dataContainerGroups;
    }

    protected void setDataContainerGroups(Collection collection) {
        this.dataContainerGroups = collection;
    }

    public void addDataContainerGroup(DataContainerGroup dataContainerGroup) {
        if (dataContainerGroup == null) {
            return;
        }
        if (this.dataContainerGroups == null) {
            this.dataContainerGroups = new ArrayList();
        }
        if (!this.dataContainerGroups.contains(dataContainerGroup)) {
            this.dataContainerGroups.add(dataContainerGroup);
        }
    }

    public void removeDataContainerGroup(DataContainerGroup dataContainerGroup) {
        if (dataContainerGroup == null) {
            return;
        }
        if (this.dataContainerGroups != null && this.dataContainerGroups.contains(dataContainerGroup)) {
            this.dataContainerGroups.remove(dataContainerGroup);
        }
    }

    public void clearDataContainerGroups() {
        this.dataContainerGroups.clear();
    }

    public Collection getKeywords() {
        return this.keywords;
    }

    protected void setKeywords(Collection collection) {
        this.keywords = collection;
    }

    public void addKeyword(Keyword keyword) {
        if (keyword == null) {
            return;
        }
        if (this.keywords == null) {
            this.keywords = new ArrayList();
        }
        if (!this.keywords.contains(keyword)) {
            this.keywords.add(keyword);
        }
    }

    public void removeKeyWord(Keyword keyword) {
        if (keyword == null) {
            return;
        }
        if (this.keywords != null && this.keywords.contains(keyword)) {
            this.keywords.remove(keyword);
        }
    }

    public void clearKeywords() {
        this.keywords.clear();
    }

    public Collection getResources() {
        return this.resources;
    }

    protected void setResources(Collection collection) {
        this.resources = collection;
    }

    public void addResource(Resource resource) {
        if (resource == null) {
            return;
        }
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        if (!this.resources.contains(resource)) {
            this.resources.add(resource);
        }
    }

    public void removeResource(Resource resource) {
        if (resource == null) {
            return;
        }
        if (this.resources != null && this.resources.contains(resource)) {
            this.resources.remove(resource);
        }
    }

    public void clearResources() {
        this.resources.clear();
    }

    public DataProducer getCreator() {
        return this.creator;
    }

    public void setCreator(DataProducer dataProducer) {
        this.creator = dataProducer;
    }

    public Collection getConsumers() {
        return this.consumers;
    }

    protected void setConsumers(Collection collection) {
        this.consumers = collection;
    }

    public void addConsumer(DataProducer dataProducer) {
        if (dataProducer == null) {
            return;
        }
        if (this.consumers == null) {
            this.consumers = new ArrayList();
        }
        if (!dataProducer.getInputs().contains(this)) {
            dataProducer.getInputs().add(this);
        }
        if (!this.consumers.contains(dataProducer)) {
            this.consumers.add(dataProducer);
        }
    }

    public void removeConsumer(DataProducer dataProducer) {
        if (dataProducer == null) {
            return;
        }
        if (this.consumers != null && this.consumers.contains(dataProducer)) {
            if (dataProducer.getInputs().contains(this)) {
                dataProducer.getInputs().remove(this);
            }
            this.consumers.remove(dataProducer);
        }
    }

    public void clearConsumers() {
        for (DataProducer dataProducer : this.consumers) {
            dataProducer.getInputs().remove(this);
        }
        this.consumers.clear();
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long l) {
        this.version = l;
    }

    public static boolean isValidDataContainerType(String string) {
        boolean bl = true;
        if (string == null || !string.equals(TYPE_FILE) && !string.equals(TYPE_STREAM)) {
            bl = false;
        }
        return bl;
    }

    public String toStringRepresentation(String string) {
        if (string == null) {
            string = "|";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DataContainer");
        stringBuffer.append(string + "id=" + this.getId());
        stringBuffer.append(string + "name=" + this.getName());
        stringBuffer.append(string + "description=" + this.getDescription());
        stringBuffer.append(string + "dataContainerType=" + this.getDataContainerType());
        stringBuffer.append(string + "startDate=" + this.xmlDateFormat.format(this.startDate));
        stringBuffer.append(string + "endDate=" + this.xmlDateFormat.format(this.endDate));
        stringBuffer.append(string + "original=" + this.isOriginal());
        stringBuffer.append(string + "uriString=" + this.getUriString());
        stringBuffer.append(string + "contentLength=" + this.getContentLength());
        stringBuffer.append(string + "mimeType=" + this.getMimeType());
        stringBuffer.append(string + "numberOfRecords=" + this.getNumberOfRecords());
        stringBuffer.append(string + "dodsAccessible=" + this.isDodsAccessible());
        stringBuffer.append(string + "dodsUrlString=" + this.getDODSUrlString());
        stringBuffer.append(string + "noNetCDF=" + this.isNoNetCDF());
        stringBuffer.append(string + "minLatitude=" + this.getMinLatitude());
        stringBuffer.append(string + "maxLatitude=" + this.getMaxLatitude());
        stringBuffer.append(string + "minLongitude=" + this.getMinLongitude());
        stringBuffer.append(string + "maxLongitude=" + this.getMaxLongitude());
        stringBuffer.append(string + "minDepth=" + this.getMinDepth());
        stringBuffer.append(string + "maxDepth=" + this.getMaxDepth());
        return stringBuffer.toString();
    }

    public void setValuesFromStringRepresentation(String string, String string2) throws MetadataException {
        String string3 = string2;
        if (string3 == null) {
            string3 = "|";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
        String string4 = stringTokenizer.nextToken();
        if (!this.getClass().getName().equals(string4) && !this.getClass().getName().equals("moos.ssds.metadata." + string4)) {
            throw new MetadataException("The class specified by the first token (" + string4 + " does not match this class " + this.getClass().getName());
        }
        while (stringTokenizer.hasMoreTokens()) {
            URL uRL;
            String string5 = stringTokenizer.nextToken();
            int n = string5.indexOf("=");
            String string6 = null;
            String string7 = null;
            if (n >= 0) {
                string6 = string5.substring(0, n);
                string7 = string5.substring(n + 1);
            } else {
                string6 = "";
                string7 = "";
            }
            if (string6.equalsIgnoreCase("id")) {
                try {
                    this.setId(new Long(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("Could not convert the value for id (" + string7 + ") to a Long");
                }
            }
            if (string6.equalsIgnoreCase("name")) {
                this.setName(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("description")) {
                this.setDescription(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("dataContainerType")) {
                this.setDataContainerType(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("startDate")) {
                this.setStartDate(this.xmlDateFormat.parse(string7));
                continue;
            }
            if (string6.equalsIgnoreCase("endDate")) {
                this.setEndDate(this.xmlDateFormat.parse(string7));
                continue;
            }
            if (string6.equalsIgnoreCase("original")) {
                if (!string7.equalsIgnoreCase("true") && !string7.equalsIgnoreCase("false")) {
                    throw new MetadataException("Could not convert the specified value for original (" + string7 + ") to a boolean (valid options are 'true' or 'false')");
                }
                this.setOriginal(Boolean.valueOf(string7));
                continue;
            }
            if (string6.equalsIgnoreCase("uriString")) {
                this.setUriString(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("uri")) {
                this.setUri(URI.create(string7));
                continue;
            }
            if (string6.equalsIgnoreCase("url")) {
                uRL = null;
                try {
                    uRL = new URL(string7);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new MetadataException("The string " + string7 + " that was specified as the URL, could not be " + "converted to a URL: " + malformedURLException.getMessage());
                }
                this.setUrl(uRL);
                continue;
            }
            if (string6.equalsIgnoreCase("contentLength")) {
                try {
                    this.setContentLength(Long.valueOf(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("The value specified for contentLength (" + string7 + ") could not be converted to a Long: " + numberFormatException.getMessage());
                }
            }
            if (string6.equalsIgnoreCase("mimeType")) {
                this.setMimeType(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("numberOfRecords")) {
                try {
                    this.setNumberOfRecords(Long.valueOf(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("The value specified for numberOfRecords (" + string7 + ") could not be converted to a Long: " + numberFormatException.getMessage());
                }
            }
            if (string6.equalsIgnoreCase("dodsAccessible")) {
                if (!string7.equalsIgnoreCase("true") && !string7.equalsIgnoreCase("false")) {
                    throw new MetadataException("Could not convert the specified value for dodsAccessible (" + string7 + ") to a boolean (valid options are 'true' or 'false')");
                }
                this.setDodsAccessible(Boolean.valueOf(string7));
                continue;
            }
            if (string6.equalsIgnoreCase("dodsUrlString")) {
                this.setDODSUrlString(string7);
                continue;
            }
            if (string6.equalsIgnoreCase("dodsUrl")) {
                uRL = null;
                try {
                    uRL = new URL(string7);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new MetadataException("The string " + string7 + " that was specified as the DODS URL, could not be " + "converted to a URL: " + malformedURLException.getMessage());
                }
                this.setDODSUrl(uRL);
                continue;
            }
            if (string6.equalsIgnoreCase("noNetCDF")) {
                if (!string7.equalsIgnoreCase("true") && !string7.equalsIgnoreCase("false")) {
                    throw new MetadataException("Could not convert the specified value for noNetCDF (" + string7 + ") to a boolean (valid options are 'true' or 'false')");
                }
                this.setNoNetCDF(Boolean.valueOf(string7));
                continue;
            }
            if (string6.equalsIgnoreCase("minLatitude")) {
                try {
                    this.setMinLatitude(Double.valueOf(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("The value specified for minLatitude (" + string7 + ") could not be converted to a Double: " + numberFormatException.getMessage());
                }
            }
            if (string6.equalsIgnoreCase("maxLatitude")) {
                try {
                    this.setMaxLatitude(Double.valueOf(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("The value specified for maxLatitude (" + string7 + ") could not be converted to a Double: " + numberFormatException.getMessage());
                }
            }
            if (string6.equalsIgnoreCase("minLongitude")) {
                try {
                    this.setMinLongitude(Double.valueOf(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("The value specified for minLongitude (" + string7 + ") could not be converted to a Double: " + numberFormatException.getMessage());
                }
            }
            if (string6.equalsIgnoreCase("maxLongitude")) {
                try {
                    this.setMaxLongitude(Double.valueOf(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("The value specified for maxLongitude (" + string7 + ") could not be converted to a Double: " + numberFormatException.getMessage());
                }
            }
            if (string6.equalsIgnoreCase("minDepth")) {
                try {
                    this.setMinDepth(Float.valueOf(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("The value specified for minDepth (" + string7 + ") could not be converted to a Float: " + numberFormatException.getMessage());
                }
            }
            if (string6.equalsIgnoreCase("maxDepth")) {
                try {
                    this.setMaxDepth(Float.valueOf(string7));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException("The value specified for maxDepth (" + string7 + ") could not be converted to a Float: " + numberFormatException.getMessage());
                }
            }
            throw new MetadataException("The attribute specified by " + string6 + " is not a recognized field of " + this.getClass().getName());
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof DataContainer)) {
            return false;
        }
        DataContainer dataContainer = (DataContainer)object;
        if (this.uriString == null || dataContainer.getUriString() == null) {
            return false;
        }
        return this.hashCode() == dataContainer.hashCode();
    }

    public int hashCode() {
        int n = 62;
        if (this.uriString != null) {
            n += this.uriString.hashCode();
        }
        return n;
    }
}

