/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.rpc;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;

public abstract class ServiceFactory {
    private static ServiceFactory factory;
    public static final String SERVICEFACTORY_PROPERTY = "javax.xml.rpc.ServiceFactory";
    private static final String JBOSS_SERVICE_FACTORY = "org.jboss.webservice.client.ServiceFactoryImpl";
    private static final String AXIS_SERVICE_FACTORY = "org.jboss.axis.client.ServiceFactory";

    protected ServiceFactory() {
    }

    public static synchronized ServiceFactory newInstance() throws ServiceException {
        if (factory == null) {
            PropertyAccessAction action = new PropertyAccessAction(SERVICEFACTORY_PROPERTY, JBOSS_SERVICE_FACTORY);
            String factoryName = (String)AccessController.doPrivileged(action);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> factoryClass = null;
                try {
                    factoryClass = loader.loadClass(factoryName);
                    factory = (ServiceFactory)factoryClass.newInstance();
                }
                catch (ClassNotFoundException ignore) {
                    factoryName = AXIS_SERVICE_FACTORY;
                    factoryClass = loader.loadClass(factoryName);
                    factory = (ServiceFactory)factoryClass.newInstance();
                }
            }
            catch (Throwable e) {
                throw new ServiceException("Failed to create factory: " + factoryName, e);
            }
        }
        return factory;
    }

    public abstract Service loadService(Class var1) throws ServiceException;

    public abstract Service loadService(URL var1, Class var2, Properties var3) throws ServiceException;

    public abstract Service loadService(URL var1, QName var2, Properties var3) throws ServiceException;

    public abstract Service createService(QName var1) throws ServiceException;

    public abstract Service createService(URL var1, QName var2) throws ServiceException;

    private static class PropertyAccessAction
    implements PrivilegedAction {
        private String name;
        private String defaultValue;

        PropertyAccessAction(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public Object run() {
            return System.getProperty(this.name, this.defaultValue);
        }
    }
}

