/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.XMLParseException;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.jboss.mx.modelmbean.ModelMBeanConstants;
import org.jboss.mx.util.Serialization;
import org.jboss.util.xml.JBossEntityResolver;

public class DescriptorSupport
implements Descriptor {
    private Map fieldMap;
    private static final int DEFAULT_SIZE = 20;
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    static /* synthetic */ Class class$java$util$HashMap;

    public DescriptorSupport() {
        this.fieldMap = Collections.synchronizedMap(new HashMap(20));
    }

    public DescriptorSupport(int initialSize) throws MBeanException {
        if (initialSize <= 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("initialSize <= 0"));
        }
        this.fieldMap = Collections.synchronizedMap(new HashMap(initialSize));
    }

    public DescriptorSupport(DescriptorSupport descriptor) {
        if (descriptor != null) {
            String[] fieldNames = descriptor.getFieldNames();
            this.fieldMap = Collections.synchronizedMap(new HashMap(fieldNames.length));
            this.setFields(fieldNames, descriptor.getFieldValues(fieldNames));
        } else {
            this.fieldMap = Collections.synchronizedMap(new HashMap(20));
        }
    }

    public DescriptorSupport(String[] fieldNames, Object[] fieldValues) throws RuntimeOperationsException {
        this.fieldMap = Collections.synchronizedMap(new HashMap(20));
        this.setFields(fieldNames, fieldValues);
    }

    public DescriptorSupport(String[] fields) {
        if (fields == null) {
            this.fieldMap = Collections.synchronizedMap(new HashMap(20));
            return;
        }
        int j = 0;
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i] == null || fields[i].length() == 0) continue;
            ++j;
        }
        this.fieldMap = Collections.synchronizedMap(new HashMap(j));
        String[] names = new String[j];
        Object[] values = new String[j];
        j = 0;
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i] == null || fields[i].length() == 0) continue;
            try {
                int index = fields[i].indexOf(61);
                if (index == -1) {
                    throw new IllegalArgumentException("Invalid field " + fields[i]);
                }
                names[j] = fields[i].substring(0, index);
                values[j] = index == fields[i].length() - 1 ? null : fields[i].substring(index + 1, fields[i].length());
                ++j;
                continue;
            }
            catch (RuntimeException e) {
                throw new RuntimeOperationsException(e, "Error in field " + i);
            }
        }
        this.setFields(names, values);
    }

    public DescriptorSupport(String xmlString) throws MBeanException, RuntimeOperationsException, XMLParseException {
        block6: {
            if (xmlString == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Null xmlString"));
            }
            this.fieldMap = Collections.synchronizedMap(new HashMap(20));
            try {
                SAXReader saxReader = new SAXReader();
                saxReader.setEntityResolver(new JBossEntityResolver());
                Document document = saxReader.read(new StringReader(xmlString));
                Element root = document.getRootElement();
                String rootName = root.getName();
                if (rootName.equalsIgnoreCase("Descriptor")) {
                    Iterator i = root.elementIterator();
                    while (i.hasNext()) {
                        Element element = (Element)i.next();
                        if (!element.getName().equals("field")) continue;
                        Attribute attr = element.attribute("name");
                        if (attr != null) {
                            String name = attr.getText();
                            String value = element.getTextTrim();
                            this.setField(name, value);
                            continue;
                        }
                        throw new XMLParseException("Cannot find attribute 'name' in " + element);
                    }
                    break block6;
                }
                IllegalArgumentException ex = new IllegalArgumentException("Root element must be Descriptor, saw: " + rootName);
                throw new RuntimeOperationsException(ex);
            }
            catch (DocumentException e) {
                throw new XMLParseException(e, "Cannot parse XML string: " + xmlString);
            }
        }
    }

    public Object getFieldValue(String inFieldName) {
        try {
            this.checkFieldName(inFieldName);
            return this.fieldMap.get(new FieldName(inFieldName));
        }
        catch (RuntimeException e) {
            throw new RuntimeOperationsException(e, e.toString());
        }
    }

    public void setField(String inFieldName, Object fieldValue) {
        try {
            this.checkFieldName(inFieldName);
            this.validateField(inFieldName, fieldValue);
            this.fieldMap.put(new FieldName(inFieldName), fieldValue);
        }
        catch (RuntimeException e) {
            throw new RuntimeOperationsException(e, e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getFields() {
        String[] fieldStrings = new String[this.fieldMap.size()];
        Iterator it = this.fieldMap.keySet().iterator();
        Map map = this.fieldMap;
        synchronized (map) {
            for (int i = 0; i < this.fieldMap.size(); ++i) {
                FieldName key = (FieldName)it.next();
                Object value = this.fieldMap.get(key);
                if (value != null) {
                    if (value instanceof String) {
                        fieldStrings[i] = key + "=" + value;
                        continue;
                    }
                    fieldStrings[i] = key + "=(" + value + ")";
                    continue;
                }
                fieldStrings[i] = key + "=";
            }
        }
        return fieldStrings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getFieldNames() {
        String[] fields = new String[this.fieldMap.size()];
        Iterator it = this.fieldMap.keySet().iterator();
        Map map = this.fieldMap;
        synchronized (map) {
            for (int i = 0; i < this.fieldMap.size(); ++i) {
                FieldName key = (FieldName)it.next();
                fields[i] = key.getName();
            }
        }
        return fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getFieldValues(String[] fieldNames) {
        if (this.fieldMap.size() == 0) {
            return new Object[0];
        }
        Object[] values = null;
        if (fieldNames == null) {
            values = new Object[this.fieldMap.size()];
            Iterator it = this.fieldMap.values().iterator();
            Map map = this.fieldMap;
            synchronized (map) {
                for (int i = 0; i < this.fieldMap.size(); ++i) {
                    values[i] = it.next();
                }
            }
        } else {
            values = new Object[fieldNames.length];
            for (int i = 0; i < fieldNames.length; ++i) {
                values[i] = fieldNames[i] == null || fieldNames[i].equals("") ? null : this.fieldMap.get(new FieldName(fieldNames[i]));
            }
        }
        return values;
    }

    public void setFields(String[] fieldNames, Object[] fieldValues) {
        if (fieldNames == null || fieldValues == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("fieldNames or fieldValues was null."));
        }
        if (fieldNames.length == 0 && fieldValues.length == 0) {
            return;
        }
        if (fieldNames.length != fieldValues.length) {
            throw new RuntimeOperationsException(new IllegalArgumentException("fieldNames and fieldValues array size must match."));
        }
        try {
            for (int i = 0; i < fieldNames.length; ++i) {
                String name = fieldNames[i];
                this.checkFieldName(name);
                this.validateField(name, fieldValues[i]);
                this.fieldMap.put(new FieldName(name), fieldValues[i]);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeOperationsException(e);
        }
    }

    public synchronized Object clone() {
        try {
            DescriptorSupport clone = (DescriptorSupport)super.clone();
            clone.fieldMap = Collections.synchronizedMap(new HashMap(this.fieldMap));
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeOperationsException(new RuntimeException(e.getMessage()), e.toString());
        }
    }

    public void removeField(String fieldName) {
        if (fieldName == null || fieldName.equals("")) {
            return;
        }
        this.fieldMap.remove(new FieldName(fieldName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() throws RuntimeOperationsException {
        try {
            this.validateString("name", true);
            this.validateString("descriptorType", true);
            Map map = this.fieldMap;
            synchronized (map) {
                Iterator i = this.fieldMap.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    FieldName name = (FieldName)entry.getKey();
                    Object value = entry.getValue();
                    this.validateField(name.getName(), value);
                }
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public String toXMLString() throws RuntimeOperationsException {
        if (this.fieldMap.size() == 0) {
            return "<Descriptor></Descriptor>";
        }
        try {
            Document document = DocumentHelper.createDocument();
            Element root = document.addElement("Descriptor");
            String[] names = this.getFieldNames();
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                Object value = this.getFieldValue(name);
                Element field = root.addElement("field");
                field.addAttribute("name", name);
                field.addText(value.toString());
            }
            StringWriter sw = new StringWriter();
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter(sw, format);
            writer.write(document);
            writer.close();
            return sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeOperationsException(new RuntimeException(e), "Cannot get XML representation");
        }
    }

    public String toString() {
        String[] names = this.getFieldNames();
        Object[] values = this.getFieldValues(names);
        StringBuffer sbuf = new StringBuffer(500);
        sbuf.append(this.getClass()).append('@').append(System.identityHashCode(this)).append('[');
        if (names.length == 0) {
            return "<empty descriptor>";
        }
        for (int i = 0; i < values.length; ++i) {
            sbuf.append(names[i]);
            sbuf.append("=");
            sbuf.append(values[i]);
            if (i >= values.length - 1) continue;
            sbuf.append(",");
        }
        sbuf.append(']');
        return sbuf.toString();
    }

    private void checkFieldName(String inFieldName) {
        if (inFieldName == null || inFieldName.equals("")) {
            throw new IllegalArgumentException("null or empty field name");
        }
    }

    private void validateField(String inFieldName, Object value) {
        String fieldName = inFieldName;
        if (fieldName.equalsIgnoreCase("name")) {
            this.validateString(inFieldName, value, true);
        } else if (fieldName.equalsIgnoreCase("descriptorType")) {
            this.validateString(inFieldName, value, true);
        } else if (fieldName.equalsIgnoreCase("class")) {
            this.validateString(inFieldName, value, false);
        } else if (fieldName.equalsIgnoreCase("role")) {
            this.validateString(inFieldName, value, false);
        } else if (fieldName.equalsIgnoreCase("getMethod")) {
            this.validateString(inFieldName, value, false);
        } else if (fieldName.equalsIgnoreCase("setMethod")) {
            this.validateString(inFieldName, value, false);
        } else if (fieldName.equalsIgnoreCase("persistPeriod")) {
            this.validateNumeric(inFieldName, value);
        } else if (fieldName.equalsIgnoreCase("currencyTimeLimit")) {
            this.validateNumeric(inFieldName, value);
        } else if (fieldName.equalsIgnoreCase("lastUpdatedTimeStamp")) {
            this.validateNumeric(inFieldName, value);
        } else if (fieldName.equalsIgnoreCase("lastUpdatedTimeStamp2")) {
            this.validateNumeric(inFieldName, value);
        } else if (fieldName.equalsIgnoreCase("lastReturnedTimestamp")) {
            this.validateNumeric(inFieldName, value);
        } else if (fieldName.equalsIgnoreCase("log")) {
            this.validateBoolean(inFieldName, value);
        } else if (fieldName.equalsIgnoreCase("visibility")) {
            this.validateNumeric(inFieldName, value, 1, 4);
        } else if (fieldName.equalsIgnoreCase("severity")) {
            this.validateNumeric(inFieldName, value, 1, 6);
        } else if (fieldName.equalsIgnoreCase("persistPolicy")) {
            this.validatePersistPolicy(inFieldName, value);
        }
    }

    private void validateString(String fieldName, boolean mandatory) {
        Object value = this.fieldMap.get(new FieldName(fieldName));
        this.validateString(fieldName, value, mandatory);
    }

    private void validateString(String fieldName, Object value, boolean mandatory) {
        if (value == null && mandatory) {
            throw new IllegalArgumentException("Expected a value for mandatory field '" + fieldName + "'");
        }
        if (value == null) {
            throw new IllegalArgumentException("Expected a value for field '" + fieldName + "'");
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Expected a String for field '" + fieldName + "'");
        }
        String string = (String)value;
        if (string.length() == 0) {
            throw new IllegalArgumentException("Empty value for field '" + fieldName + "'");
        }
    }

    private void validatePersistPolicy(String fieldName, Object value) {
        this.validateString(fieldName, value, false);
        String string = (String)value;
        String[] policies = ModelMBeanConstants.PERSIST_POLICIES;
        for (int i = 0; i < policies.length; ++i) {
            if (!policies[i].equalsIgnoreCase(string)) continue;
            return;
        }
        throw new IllegalArgumentException("Invalid value " + value + " for field '" + fieldName + "' expected one of " + Arrays.asList(policies));
    }

    private void validateBoolean(String fieldName, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Expected a value for field '" + fieldName + "'");
        }
        if (value instanceof String) {
            String string = (String)value;
            if (string.equalsIgnoreCase("T") || string.equalsIgnoreCase("F")) {
                return;
            }
            if (string.equalsIgnoreCase("TRUE") || string.equalsIgnoreCase("FALSE")) {
                return;
            }
        } else if (value instanceof Boolean) {
            return;
        }
        throw new IllegalArgumentException("Invalid value " + value + " for field '" + fieldName + "'");
    }

    private long validateNumeric(String fieldName, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Expected a value for field '" + fieldName + "'");
        }
        Long number = null;
        if (value instanceof String) {
            number = new Long((String)value);
        } else if (value instanceof Number) {
            number = new Long(((Number)value).longValue());
        }
        if (number != null && number >= -1L) {
            return number;
        }
        throw new IllegalArgumentException("Invalid value " + value + " for field '" + fieldName + "'");
    }

    private void validateNumeric(String fieldName, Object value, int min, int max) {
        long result = this.validateNumeric(fieldName, value);
        if (result >= (long)min && result <= (long)max) {
            return;
        }
        throw new IllegalArgumentException("Invalid value " + value + " for field '" + fieldName + "'");
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = ois.readFields();
        HashMap serMap = (HashMap)getField.get("descriptor", null);
        if (serMap == null) {
            throw new StreamCorruptedException("Null descriptor?");
        }
        this.fieldMap = Collections.synchronizedMap(new HashMap());
        Iterator it = serMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            FieldName key = new FieldName((String)entry.getKey());
            this.fieldMap.put(key, entry.getValue());
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField putField = oos.putFields();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream tstOOS = new ObjectOutputStream(baos);
        HashMap serMap = new HashMap();
        Iterator it = this.fieldMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = ((FieldName)entry.getKey()).name;
            Object value = entry.getValue();
            if (!(value instanceof Serializable)) continue;
            try {
                baos.reset();
                tstOOS.writeObject(value);
                serMap.put(key, value);
            }
            catch (Exception ignore) {}
        }
        baos.close();
        tstOOS.close();
        putField.put("descriptor", serMap);
        oos.writeFields();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        switch (Serialization.version) {
            case 10: {
                serialVersionUID = 8071560848919417985L;
                break;
            }
            default: {
                serialVersionUID = -6292969195866300415L;
            }
        }
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("descriptor", class$java$util$HashMap == null ? (class$java$util$HashMap = DescriptorSupport.class$("java.util.HashMap")) : class$java$util$HashMap)};
    }

    private class FieldName
    implements Serializable {
        static final long serialVersionUID = 2645619836053638810L;
        private String name;
        private int hashCode;

        public FieldName(String aName) {
            if (aName == null) {
                throw new IllegalArgumentException("null name");
            }
            this.name = aName;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = this.name.toLowerCase().hashCode();
                return this.hashCode;
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof FieldName) {
                return this.name.equalsIgnoreCase(((FieldName)obj).name);
            }
            if (obj instanceof String) {
                return this.name.equalsIgnoreCase((String)obj);
            }
            return false;
        }

        public String toString() {
            return this.name;
        }
    }
}

