/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import ncsa.hdf.hdf5lib.H5;
import visad.DisplayImpl;
import visad.util.ComboFileFilter;
import visad.util.ExtensionFileFilter;
import visad.util.McIDASFileFilter;

public class Util {
    public static boolean isApproximatelyEqual(float a, float b, float epsilon) {
        if (Float.isNaN(a)) {
            return Float.isNaN(b);
        }
        if (Float.isNaN(b)) {
            return false;
        }
        if (Math.abs(a - b) < epsilon) {
            return true;
        }
        if ((double)a == 0.0 || (double)b == 0.0) {
            return false;
        }
        return Math.abs(1.0f - a / b) < 1.1920929E-7f;
    }

    public static boolean isApproximatelyEqual(float a, float b) {
        return Util.isApproximatelyEqual((double)a, (double)b, 1.0E-5);
    }

    public static boolean isApproximatelyEqual(double a, double b, double epsilon) {
        if (Double.isNaN(a)) {
            return Double.isNaN(b);
        }
        if (Double.isNaN(b)) {
            return false;
        }
        if (Math.abs(a - b) < epsilon) {
            return true;
        }
        if (a == 0.0 || b == 0.0) {
            return false;
        }
        return Math.abs(1.0 - a / b) < 2.220446049250313E-16;
    }

    public static boolean isApproximatelyEqual(double a, double b) {
        return Util.isApproximatelyEqual(a, b, 1.0E-9);
    }

    public static JFileChooser getVisADFileChooser() {
        ExtensionFileFilter biorad = new ExtensionFileFilter("pic", "BioRad PIC images");
        ExtensionFileFilter bmp = new ExtensionFileFilter("bmp", "BMP images");
        ExtensionFileFilter fits = new ExtensionFileFilter("fits", "FITS datasets");
        ExtensionFileFilter flashpix = new ExtensionFileFilter("flashpix", "FlashPix images");
        ExtensionFileFilter gif = new ExtensionFileFilter("gif", "GIF images");
        ExtensionFileFilter hdf5 = new ExtensionFileFilter(new String[]{"hdf", "hdf5"}, "HDF-5 datasets");
        ExtensionFileFilter hdfeos = new ExtensionFileFilter(new String[]{"hdf", "hdfeos"}, "HDF-EOS datasets");
        ExtensionFileFilter jpeg = new ExtensionFileFilter(new String[]{"jpg", "jpeg", "jpe"}, "JPEG images");
        McIDASFileFilter mcidas = new McIDASFileFilter();
        ExtensionFileFilter netcdf = new ExtensionFileFilter(new String[]{"nc", "ncf", "netcdf", "cdf"}, "netCDF datasets");
        ExtensionFileFilter png = new ExtensionFileFilter("png", "PNG images");
        ExtensionFileFilter pnm = new ExtensionFileFilter("pnm", "PNM images");
        ExtensionFileFilter serial = new ExtensionFileFilter(new String[]{"svd", "vad", "visad"}, "Serialized VisAD data");
        ExtensionFileFilter tiff = new ExtensionFileFilter(new String[]{"tiff", "tif"}, "TIFF images");
        ExtensionFileFilter text = new ExtensionFileFilter(new String[]{"csv", "tsv", "bsv", "txt"}, "ASCII text data");
        ExtensionFileFilter vis5d = new ExtensionFileFilter("v5d", "Vis5D datasets");
        ComboFileFilter combo = new ComboFileFilter(new FileFilter[]{biorad, bmp, fits, flashpix, gif, hdf5, hdfeos, jpeg, mcidas, netcdf, png, pnm, serial, tiff, text, vis5d}, "All VisAD file types");
        JFileChooser dialog = new JFileChooser(System.getProperty("user.dir"));
        dialog.addChoosableFileFilter(biorad);
        dialog.addChoosableFileFilter(bmp);
        dialog.addChoosableFileFilter(fits);
        dialog.addChoosableFileFilter(flashpix);
        dialog.addChoosableFileFilter(gif);
        dialog.addChoosableFileFilter(hdf5);
        dialog.addChoosableFileFilter(hdfeos);
        dialog.addChoosableFileFilter(jpeg);
        dialog.addChoosableFileFilter(mcidas);
        dialog.addChoosableFileFilter(netcdf);
        dialog.addChoosableFileFilter(png);
        dialog.addChoosableFileFilter(pnm);
        dialog.addChoosableFileFilter(serial);
        dialog.addChoosableFileFilter(tiff);
        dialog.addChoosableFileFilter(text);
        dialog.addChoosableFileFilter(vis5d);
        dialog.addChoosableFileFilter(combo);
        return dialog;
    }

    public static void adjustTextField(JTextField field) {
        Dimension msize = field.getMaximumSize();
        Dimension psize = field.getPreferredSize();
        msize.height = psize.height;
        field.setMaximumSize(msize);
    }

    public static void centerWindow(Window window) {
        Dimension s = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension w = window.getSize();
        ((Component)window).setLocation(s.width / 2 - w.width / 2, s.height / 2 - w.height / 2);
    }

    public static boolean canDoHDF5() {
        boolean success = false;
        try {
            H5.J2C(0);
            success = true;
        }
        catch (NoClassDefFoundError err) {
        }
        catch (UnsatisfiedLinkError err) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return success;
    }

    public static boolean canDoJPEG() {
        return Util.canDoClass("com.sun.image.codec.jpeg.JPEGCodec") != null;
    }

    public static boolean canDoJAI() {
        return Util.canDoClass("javax.media.jai.JAI") != null;
    }

    public static boolean canDoPython() {
        return Util.canDoClass("org.python.util.PythonInterpreter") != null;
    }

    public static boolean canDoQuickTime() {
        return Util.canDoClass("quicktime.QTSession") != null;
    }

    public static boolean canDoJava3D() {
        return Util.canDoJava3D("1.0");
    }

    public static boolean canDoJava3D(String version) {
        Package p;
        boolean b;
        Class testClass = Util.canDoClass("javax.vecmath.Point3d");
        boolean bl = testClass != null ? Util.canDoClass("javax.media.j3d.SceneGraphObject") != null : (b = false);
        if (b && (p = testClass.getPackage()) != null) {
            try {
                b = p.isCompatibleWith(version);
            }
            catch (NumberFormatException nfe) {
                b = false;
            }
        }
        return b;
    }

    private static Class canDoClass(String classname) {
        Class<?> c = null;
        try {
            c = Class.forName(classname);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return c;
    }

    public static void captureDisplay(DisplayImpl display, String filename) {
        final DisplayImpl disp = display;
        final File fn = new File(filename);
        Runnable savedisp = new Runnable(){

            public void run() {
                BufferedImage image = disp.getImage();
                try {
                    JPEGEncodeParam param = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)image);
                    param.setQuality(1.0f, true);
                    FileOutputStream fout = new FileOutputStream(fn);
                    JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)fout);
                    encoder.encode(image, param);
                    fout.close();
                }
                catch (Exception err) {
                    System.err.println("Error whilst saving JPEG: " + err);
                }
            }
        };
        Thread t = new Thread(savedisp);
        t.start();
    }

    public static boolean arraysEqual(Object[] o1, Object[] o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.length != o2.length) {
            return false;
        }
        int i = 0;
        while (i < o1.length) {
            if (!o1[i].equals(o2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void invoke(boolean wait, Runnable r) {
        Util.invoke(wait, false, r);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void invoke(boolean wait, boolean printStackTraces, Runnable r) {
        if (wait) {
            if (Thread.currentThread().getName().startsWith("AWT-EventQueue")) {
                r.run();
                return;
            } else {
                try {
                    SwingUtilities.invokeAndWait(r);
                    return;
                }
                catch (InterruptedException exc) {
                    if (!printStackTraces) return;
                    exc.printStackTrace();
                    return;
                }
                catch (InvocationTargetException exc) {
                    if (!printStackTraces) return;
                    exc.getTargetException().printStackTrace();
                }
            }
            return;
        } else {
            SwingUtilities.invokeLater(r);
        }
    }
}

