/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import visad.ProjectionControl;
import visad.VisADException;

public class ProjWidget
extends JPanel {
    ProjectionControl control;
    JComboBox savedViewList;
    JButton save;
    double[][] savedViews;

    public ProjWidget(ProjectionControl pc) {
        this.control = pc;
        this.savedViews = new double[1][];
        this.savedViews[0] = this.control.getMatrix();
        this.setLayout(new BoxLayout(this, 0));
        this.savedViewList = new JComboBox();
        this.savedViewList.setEditable(false);
        this.savedViewList.addItem("Position 1");
        this.savedViewList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int index = ProjWidget.this.savedViewList.getSelectedIndex();
                try {
                    ProjWidget.this.control.setMatrix(ProjWidget.this.savedViews[index]);
                }
                catch (VisADException exc) {
                }
                catch (RemoteException exc) {
                    // empty catch block
                }
            }
        });
        this.save = new JButton("Save");
        this.save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int num = ProjWidget.this.savedViews.length;
                double[][] d = new double[num + 1][];
                System.arraycopy(ProjWidget.this.savedViews, 0, d, 0, num);
                d[num] = ProjWidget.this.control.getMatrix();
                ProjWidget.this.savedViews = d;
                ProjWidget.this.savedViewList.addItem("Position " + (num + 1));
                ProjWidget.this.savedViewList.setSelectedIndex(num);
            }
        });
        this.add(this.savedViewList);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(this.save);
    }
}

