/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import visad.DataImpl;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.util.ExtensionFileFilter;
import visad.util.Util;

public class DataConverter {
    protected static final ExtensionFileFilter filter = new ExtensionFileFilter("class", "Java classes");
    protected Vector forms = new Vector();
    protected DataImpl data;
    protected File lastDir;
    protected JFrame frame;
    protected JTextArea area;
    protected JScrollPane scroll;
    protected JButton read;
    protected JButton write;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$visad$data$FormNode;
    static /* synthetic */ Class class$java$lang$String;

    public DataConverter() {
        this(new File("../data"), "visad");
    }

    public DataConverter(File dir, String prefix) {
        this.findForms(dir, prefix);
        this.doGUI();
    }

    protected void doGUI() {
        this.frame = new JFrame("VisAD Data Converter");
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        this.frame.setContentPane(pane);
        this.area = new JTextArea("VisAD Data Converter\n\n");
        this.area.setEditable(false);
        this.scroll = new JScrollPane(this.area);
        pane.add(this.scroll);
        final JPopupMenu readMenu = new JPopupMenu();
        this.read = new JButton("Import");
        this.read.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataConverter.this.popup(DataConverter.this.read, readMenu);
            }
        });
        final JPopupMenu writeMenu = new JPopupMenu();
        this.write = new JButton("Export");
        this.write.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataConverter.this.popup(DataConverter.this.write, writeMenu);
            }
        });
        int i = 0;
        while (i < this.forms.size()) {
            final FormNode form = (FormNode)this.forms.elementAt(i);
            String label = form.getClass().getName();
            String[] suffixes = this.getSuffixes(form);
            if (suffixes != null) {
                label = label + " (*." + suffixes[0];
                int j = 1;
                while (j < suffixes.length) {
                    label = label + ", *." + suffixes[j];
                    ++j;
                }
                label = label + ")";
            }
            JMenuItem readItem = new JMenuItem(label);
            readItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DataConverter.this.importData(form);
                }
            });
            readMenu.add(readItem);
            JMenuItem writeItem = new JMenuItem(label);
            writeItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DataConverter.this.exportData(form);
                }
            });
            writeMenu.add(writeItem);
            ++i;
        }
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.read);
        p.add(this.write);
        pane.add(p);
        ((Component)this.frame).setSize(500, 300);
        Util.centerWindow(this.frame);
        this.frame.show();
    }

    protected void popup(JButton button, JPopupMenu menu) {
        Dimension b = this.read.getSize();
        Point loc = button.getLocationOnScreen();
        Dimension s = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension m = menu.getPreferredSize();
        int xpos = s.width - loc.x - m.width - b.width - 2;
        int ypos = s.height - loc.y - m.height - 30;
        if (xpos > 0) {
            xpos = 0;
        }
        if (ypos > 0) {
            ypos = 0;
        }
        menu.show(button, b.width + xpos, ypos);
    }

    protected void importData(FormNode form) {
        final FormNode loader = form;
        final File file = this.doDialog(form, false);
        if (file == null) {
            return;
        }
        Thread t = new Thread(new Runnable(){

            public void run() {
                DataConverter.this.setBusy(true);
                DataConverter.this.print("Importing " + file.getPath() + ": ");
                try {
                    DataConverter.this.data = loader.open(file.getPath());
                    if (DataConverter.this.data == null) {
                        DataConverter.this.println("Data is null");
                    } else {
                        DataConverter.this.println("OK");
                        DataConverter.this.println(DataConverter.this.data.getType().prettyString());
                    }
                }
                catch (Throwable tt) {
                    DataConverter.this.println("Error");
                    DataConverter.this.println(tt);
                }
                DataConverter.this.setBusy(false);
            }
        });
        t.start();
    }

    protected void exportData(FormNode form) {
        final FormNode saver = form;
        final File file = this.doDialog(form, true);
        if (file == null) {
            return;
        }
        Thread t = new Thread(new Runnable(){

            public void run() {
                DataConverter.this.setBusy(true);
                DataConverter.this.print("Exporting " + file.getPath() + ": ");
                try {
                    saver.save(file.getPath(), DataConverter.this.data, true);
                    DataConverter.this.println("OK");
                }
                catch (Throwable tt) {
                    DataConverter.this.println("Error");
                    DataConverter.this.println(tt);
                }
                DataConverter.this.setBusy(false);
            }
        });
        t.start();
    }

    protected File doDialog(FormNode form, boolean save) {
        JFileChooser chooser = this.lastDir == null ? new JFileChooser() : new JFileChooser(this.lastDir);
        String[] suffixes = this.getSuffixes(form);
        if (suffixes != null) {
            chooser.setFileFilter(new ExtensionFileFilter(suffixes, form.getClass().getName()));
        }
        int retVal = save ? chooser.showSaveDialog(this.frame) : chooser.showOpenDialog(this.frame);
        this.lastDir = chooser.getCurrentDirectory();
        return retVal == 0 ? chooser.getSelectedFile() : null;
    }

    protected String[] getSuffixes(FormNode form) {
        if (!(form instanceof FormFileInformer)) {
            return null;
        }
        FormFileInformer ffi = (FormFileInformer)((Object)form);
        String[] suffixes = ffi.getDefaultSuffixes();
        return suffixes == null || suffixes.length == 0 || suffixes[0].trim().equals("") ? null : suffixes;
    }

    protected void setBusy(boolean busy) {
        this.read.setEnabled(!busy);
        this.write.setEnabled(!busy);
        this.frame.setCursor(busy ? Cursor.getPredefinedCursor(3) : Cursor.getDefaultCursor());
    }

    protected void print(String text) {
        this.area.append(text);
        JViewport view = this.scroll.getViewport();
        Dimension size = view.getViewSize();
        view.setViewPosition(new Point(0, size.height));
    }

    protected void println(String text) {
        this.print(text + "\n\n");
    }

    protected void println() {
        this.print("\n\n");
    }

    protected void println(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        this.print(sw.toString() + "\n\n");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void findForms(File f, String prefix) {
        if (f.isDirectory()) {
            File[] list = f.listFiles(filter);
            String name = f.getName();
            String pre = "".equals(prefix) ? name : prefix + "." + name;
            int i = 0;
            while (i < list.length) {
                this.findForms(list[i], pre);
                ++i;
            }
            return;
        }
        try {
            String name = f.getName();
            String qual = "".equals(prefix) ? name : prefix + "." + name;
            qual = qual.substring(0, qual.length() - 6);
            Class<?> c = Class.forName(qual);
            boolean isForm = false;
            Class<?> q = c;
            while (q != (class$java$lang$Object == null ? DataConverter.class$("java.lang.Object") : class$java$lang$Object) && q != null) {
                if (q == (class$visad$data$FormNode == null ? DataConverter.class$("visad.data.FormNode") : class$visad$data$FormNode)) {
                    isForm = true;
                    break;
                }
                q = q.getSuperclass();
            }
            if (!isForm) return;
            FormNode form = null;
            try {
                form = (FormNode)c.newInstance();
            }
            catch (InstantiationException exc) {
            }
            catch (IllegalAccessException exc) {
            }
            catch (IllegalArgumentException exc) {
                // empty catch block
            }
            try {
                Constructor<?> con = c.getConstructor(class$java$lang$String == null ? (class$java$lang$String = DataConverter.class$("java.lang.String")) : class$java$lang$String);
                form = (FormNode)con.newInstance(name);
            }
            catch (NoSuchMethodException exc) {
            }
            catch (SecurityException exc) {
            }
            catch (InstantiationException exc) {
            }
            catch (IllegalAccessException exc) {
            }
            catch (IllegalArgumentException exc) {
            }
            catch (InvocationTargetException exc) {
                // empty catch block
            }
            if (form == null) return;
            this.forms.add(form);
            return;
        }
        catch (ClassNotFoundException exc) {
            return;
        }
        catch (NoClassDefFoundError err) {
            return;
        }
        catch (UnsatisfiedLinkError err) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        new DataConverter();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

