/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import visad.VisADException;
import visad.util.ColorChangeEvent;
import visad.util.ColorChangeListener;
import visad.util.ColorMap;
import visad.util.ColorPreview;
import visad.util.RGBAMap;
import visad.util.RGBMap;

public class ColorWidget
extends Applet
implements ColorChangeListener {
    private boolean previewVisible;
    private ColorMap map;
    private ColorPreview colorPreview;
    private Vector listeners = new Vector();
    private Object listeners_lock = new Object();

    public ColorWidget() throws RemoteException, VisADException {
        this(true);
    }

    public ColorWidget(boolean preview) throws RemoteException, VisADException {
        this(new RGBMap(), preview);
    }

    public ColorWidget(ColorMap map) {
        this(map, true);
    }

    public ColorWidget(ColorMap map, boolean preview) {
        this.map = map;
        this.previewVisible = preview;
        if (preview) {
            this.colorPreview = new ColorPreview(map);
        }
        this.setLayout(new BoxLayout(this, 1));
        this.setColorMap(map);
    }

    public static void main(String[] argv) throws RemoteException, VisADException {
        JFrame frame = new JFrame("VisAD Color Widget");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        ColorWidget w = new ColorWidget(new RGBAMap());
        frame.add(w);
        ((Component)frame).setSize(w.getPreferredSize());
        ((Component)frame).setVisible(true);
    }

    public void addColorChangeListener(ColorChangeListener c) {
        Object object = this.listeners_lock;
        synchronized (object) {
            if (!this.listeners.contains(c)) {
                this.listeners.addElement(c);
            }
        }
    }

    public void removeColorChangeListener(ColorChangeListener c) {
        Object object = this.listeners_lock;
        synchronized (object) {
            if (this.listeners.contains(c)) {
                this.listeners.removeElement(c);
            }
        }
    }

    protected void notifyListeners(ColorChangeEvent e) {
        Vector listeners_clone = null;
        Object object = this.listeners_lock;
        synchronized (object) {
            listeners_clone = (Vector)this.listeners.clone();
        }
        int i = 0;
        while (i < listeners_clone.size()) {
            ColorChangeListener c = (ColorChangeListener)listeners_clone.elementAt(i);
            c.colorChanged(e);
            ++i;
        }
    }

    public void colorChanged(ColorChangeEvent e) {
        this.notifyListeners(e);
    }

    public void setColorMap(ColorMap map) {
        if (this.map != null) {
            this.map.removeColorChangeListener(this);
        }
        this.map = map;
        map.addColorChangeListener(this);
        this.removeAll();
        this.add(map);
        if (this.previewVisible) {
            if (this.colorPreview == null) {
                this.colorPreview = new ColorPreview(map);
            }
            this.add(this.colorPreview);
        }
        this.validate();
        int res = map.getMapResolution();
        this.notifyListeners(new ColorChangeEvent(map, 0.0f, res));
    }

    public void showPreview() {
        if (this.previewVisible) {
            return;
        }
        this.previewVisible = true;
        this.setColorMap(this.map);
    }

    public void hidePreview() {
        if (!this.previewVisible) {
            return;
        }
        this.previewVisible = false;
        this.setColorMap(this.map);
    }

    public ColorMap getColorMap() {
        return this.map;
    }

    public Dimension getPreferredSize() {
        Dimension d = this.map.getPreferredSize();
        if (this.previewVisible) {
            Dimension n;
            Dimension p = this.colorPreview.getPreferredSize();
            d = n = new Dimension(d.width, d.height + p.height);
        }
        return d;
    }
}

