/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import visad.VisADException;
import visad.util.CodeEditor;
import visad.util.TextFrame;
import visad.util.Util;

public class CodeFrame
extends TextFrame {
    public CodeFrame(CodeEditor editor) {
        super(editor);
        this.addMenuItem("Command", "Run", "commandRun", 'r');
        this.addMenuItem("Command", "Compile", "commandCompile", 'c');
    }

    protected void layoutGUI() {
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        this.setContentPane(pane);
        JPanel immediate = new JPanel();
        immediate.setLayout(new BoxLayout(immediate, 0));
        final JTextField textLine = new JTextField();
        Util.adjustTextField(textLine);
        textLine.setToolTipText("Enter a command and press enter to execute it immediately");
        final CodeEditor fTextPane = (CodeEditor)this.textPane;
        textLine.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    fTextPane.exec(textLine.getText());
                }
                catch (VisADException exc) {
                    CodeFrame.this.showError(exc.getMessage());
                }
            }
        });
        immediate.add(new JLabel("Immediate: "));
        immediate.add(textLine);
        pane.add(this.textPane);
        pane.add(immediate);
        this.setTitle("VisAD Source Code Editor");
    }

    public void commandRun() {
        try {
            ((CodeEditor)this.textPane).run();
        }
        catch (VisADException exc) {
            this.showError(exc.getMessage());
        }
    }

    public void commandCompile() {
        try {
            ((CodeEditor)this.textPane).compile();
        }
        catch (VisADException exc) {
            this.showError(exc.getMessage());
        }
    }
}

