/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import java.rmi.RemoteException;
import visad.BaseColorControl;
import visad.ControlEvent;
import visad.ControlListener;
import visad.VisADException;
import visad.util.ColorChangeEvent;
import visad.util.ColorMap;
import visad.util.Util;

public class BaseRGBMap
extends ColorMap
implements ControlListener,
MouseListener,
MouseMotionListener {
    public static boolean USE_COLOR_CURSORS = false;
    public static final int DEFAULT_RESOLUTION = 256;
    private BaseColorControl ctl;
    private int valLeft = 0;
    private int valRight = 0;
    private Object mutex = new Object();
    private static final int RED = 0;
    private static final int GREEN = 1;
    private static final int BLUE = 2;
    private static final int ALPHA = 3;
    private int state = 0;
    private int resolution = 256;
    private boolean hasAlpha;
    private static Cursor[] cursor = null;
    private static final Color bluish = new Color(80, 80, 255);
    private Dimension preferredSize = null;
    private int oldX;
    private int oldY;
    private Object mouseMutex = new Object();
    private float updateLeft = 0.0f;
    private float updateRight = 1.0f;

    public BaseRGBMap(boolean hasAlpha) throws RemoteException, VisADException {
        this(BaseRGBMap.defaultTable(256, hasAlpha));
    }

    public BaseRGBMap(int resolution, boolean hasAlpha) throws RemoteException, VisADException {
        this(BaseRGBMap.defaultTable(resolution, hasAlpha));
    }

    public BaseRGBMap(float[][] vals, boolean hasAlpha) throws RemoteException, VisADException {
        this(vals != null ? vals : BaseRGBMap.defaultTable(256, hasAlpha));
    }

    public BaseRGBMap(float[][] vals) throws RemoteException, VisADException {
        if (vals == null) {
            vals = BaseRGBMap.defaultTable(256, true);
        }
        this.setValues(vals);
        if (USE_COLOR_CURSORS) {
            this.buildCursors();
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.ctl.addControlListener(this);
    }

    public BaseRGBMap(BaseColorControl ctl) {
        this.ctl = ctl;
        this.hasAlpha = ctl.getNumberOfComponents() == 4;
        this.resolution = ctl.getNumberOfColors();
        if (USE_COLOR_CURSORS) {
            this.buildCursors();
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        ctl.addControlListener(this);
    }

    static float[][] defaultTable(int resolution, boolean hasAlpha) {
        int components = hasAlpha ? 4 : 3;
        float[][] tbl = new float[components][resolution];
        return BaseColorControl.initTableVis5D(tbl);
    }

    static Cursor buildRGBACursor(int rgba) {
        String name;
        int color;
        if (rgba < 0 || rgba > 3) {
            rgba = 0;
        }
        int[] pixel = new int[225];
        int i = 0;
        while (i < pixel.length) {
            pixel[i] = 0;
            ++i;
        }
        switch (rgba) {
            case 0: {
                color = Color.red.getRGB();
                break;
            }
            case 1: {
                color = Color.green.getRGB();
                break;
            }
            case 2: {
                color = bluish.getRGB();
                break;
            }
            default: {
                color = Color.gray.getRGB();
            }
        }
        int i2 = 119;
        while (i2 >= 105) {
            pixel[i2] = color;
            --i2;
        }
        int i3 = 0;
        while (i3 < 15) {
            pixel[i3 * 15 + 7] = color;
            ++i3;
        }
        MemoryImageSource ip = new MemoryImageSource(15, 15, pixel, 0, 15);
        Image img = Toolkit.getDefaultToolkit().createImage(ip);
        Point pt = new Point(img.getWidth(null) / 2, img.getHeight(null) / 2);
        switch (rgba) {
            case 0: {
                name = "crossRed";
                break;
            }
            case 1: {
                name = "crossGreen";
                break;
            }
            case 2: {
                name = "crossBlue";
                break;
            }
            default: {
                name = "crossAlpha";
            }
        }
        return Toolkit.getDefaultToolkit().createCustomCursor(img, pt, name);
    }

    private void buildCursors() {
        if (cursor != null) {
            return;
        }
        String jVersion = System.getProperty("java.version");
        if (jVersion == null) {
            return;
        }
        if (jVersion.length() < 3) {
            return;
        }
        if (jVersion.charAt(0) < '1') {
            return;
        }
        if (jVersion.charAt(1) != '.') {
            return;
        }
        if (jVersion.charAt(0) == '1' && jVersion.charAt(2) < '3') {
            return;
        }
        cursor = new Cursor[4];
        BaseRGBMap.cursor[0] = BaseRGBMap.buildRGBACursor(0);
        BaseRGBMap.cursor[1] = BaseRGBMap.buildRGBACursor(1);
        BaseRGBMap.cursor[2] = BaseRGBMap.buildRGBACursor(2);
        BaseRGBMap.cursor[3] = BaseRGBMap.buildRGBACursor(3);
        this.setCursor(cursor[this.state]);
    }

    public void setValues(float[][] newVal) throws RemoteException, VisADException {
        if (newVal == null) {
            throw new VisADException("Can't set table to null");
        }
        if (newVal.length >= 3 && newVal.length <= 4 && newVal[0].length > 4) {
            this.hasAlpha = newVal.length > 3;
            this.resolution = newVal[0].length;
        } else if (newVal[0].length >= 3 && newVal[0].length <= 4 && newVal.length > 4) {
            this.hasAlpha = newVal[0].length > 3;
            this.resolution = newVal.length;
            float[][] tmpVal = new float[this.hasAlpha ? 4 : 3][this.resolution];
            int i = 0;
            while (i < this.resolution) {
                tmpVal[0][i] = newVal[i][0];
                tmpVal[1][i] = newVal[i][1];
                tmpVal[2][i] = newVal[i][2];
                if (this.hasAlpha) {
                    tmpVal[3][i] = newVal[i][3];
                }
                ++i;
            }
            newVal = tmpVal;
        } else {
            throw new VisADException("Cannot set table with dimensions [" + newVal.length + "][" + newVal[0].length + "]");
        }
        if (this.ctl == null) {
            this.ctl = new BaseColorControl(null, this.hasAlpha ? 4 : 3);
        }
        this.ctl.setTable(newVal);
        this.sendUpdate(0, this.resolution - 1);
    }

    public int getMapResolution() {
        return this.resolution;
    }

    public int getMapDimension() {
        return this.ctl.getNumberOfComponents();
    }

    public float[][] getColorMap() {
        return this.ctl.getTable();
    }

    public float[][] getTuples(float firstVal, float lastVal, int num) {
        float[][] colors;
        int rEnd;
        if (num <= 0 || firstVal > lastVal || num == 1 && !Util.isApproximatelyEqual(firstVal, lastVal)) {
            return null;
        }
        float floatIdx = firstVal * (float)(this.resolution - 1);
        int startIndex = (int)Math.floor(floatIdx);
        floatIdx = lastVal * (float)(this.resolution - 1);
        int endIndex = (int)Math.floor(floatIdx);
        float partialEnd = floatIdx - (float)endIndex;
        boolean isPartialEnd = partialEnd != 0.0f;
        float[][] tuples = new float[num][this.hasAlpha ? 4 : 3];
        int rStart = startIndex;
        if (rStart < 0) {
            rStart = 0;
        } else if (rStart >= this.resolution) {
            rStart = this.resolution - 1;
        }
        int n = rEnd = isPartialEnd ? endIndex + 1 : endIndex;
        if (rEnd >= this.resolution) {
            rEnd = this.resolution - 1;
        } else if (rEnd < 0) {
            rEnd = 0;
        }
        int rLen = rEnd - rStart + 1;
        try {
            colors = this.ctl.lookupRange(rStart, rEnd);
        }
        catch (Exception e) {
            System.err.println("Error in " + this.getClass().getName() + ": " + e.getClass().getName() + ": " + e.getMessage());
            return null;
        }
        float stepVal = (lastVal - firstVal) / (float)num;
        int i = 0;
        while (i < num) {
            boolean isPartial;
            float thisVal = firstVal + (float)i * stepVal;
            floatIdx = thisVal * (float)(this.resolution - 1);
            int index = (int)Math.floor(floatIdx);
            float partial = floatIdx - (float)index;
            boolean bl = isPartial = partial != 0.0f;
            if ((index -= rStart) < 0 || index >= rLen || index == rLen - 1 && isPartial) {
                tuples[i][2] = 0.0f;
                tuples[i][1] = 0.0f;
                tuples[i][0] = 0.0f;
                if (this.hasAlpha) {
                    tuples[i][3] = 0.0f;
                }
            } else if (isPartial) {
                tuples[i][0] = colors[0][index] * (1.0f - partial) + colors[0][index + 1] * partial;
                tuples[i][1] = colors[1][index] * (1.0f - partial) + colors[1][index + 1] * partial;
                tuples[i][2] = colors[2][index] * (1.0f - partial) + colors[2][index + 1] * partial;
                if (this.hasAlpha) {
                    tuples[i][3] = colors[3][index] * (1.0f - partial) + colors[3][index + 1] * partial;
                }
            } else {
                tuples[i][0] = colors[0][index];
                tuples[i][1] = colors[1][index];
                tuples[i][2] = colors[2][index];
                if (this.hasAlpha) {
                    tuples[i][3] = colors[3][index];
                }
            }
            ++i;
        }
        return tuples;
    }

    public float[] getTuple(float value) {
        float[][] v = this.getTuples(value, value, 1);
        return v == null ? null : v[0];
    }

    public float[][] getRGBTuples(float startVal, float endVal, int num) {
        float[][] t = this.getTuples(startVal, endVal, num);
        if (t[0].length > 3) {
            float[][] f = new float[t.length][3];
            int i = t.length - 1;
            while (i >= 0) {
                f[i][0] = t[i][0];
                f[i][1] = t[i][1];
                f[i][2] = t[i][2];
                --i;
            }
            t = f;
        }
        return t;
    }

    public float[] getRGBTuple(float value) {
        float[] t = this.getTuple(value);
        if (t.length > 3) {
            float[] f = new float[]{t[0], t[1], t[2]};
            t = f;
        }
        return t;
    }

    protected void sendUpdate(int left, int right) {
        this.notifyListeners(new ColorChangeEvent(this, left, right));
        if (left != 0) {
            --left;
        }
        if (right != this.resolution - 1) {
            ++right;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (left < this.valLeft) {
                this.valLeft = left;
            }
            if (right > this.valRight) {
                this.valRight = right;
            }
        }
        this.validate();
        this.repaint();
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        float[][] colors;
        if ((evt.getModifiers() & 0x10) == 0 && evt.getModifiers() != 0) {
            return;
        }
        int width = this.getBounds().width;
        int height = this.getBounds().height;
        int x = evt.getX();
        int y = evt.getY();
        if (x < 0) {
            x = 0;
        } else if (x >= width) {
            x = width - 1;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= height) {
            y = height - 1;
        }
        float step = (float)(this.resolution - 1) / (float)width;
        int pos = (int)Math.floor((double)((float)x * step) + 0.5);
        try {
            colors = this.ctl.lookupRange(pos, pos);
        }
        catch (Exception e) {
            System.err.println("Error in " + this.getClass().getName() + ": " + e.getClass().getName() + ": " + e.getMessage());
            return;
        }
        colors[this.state][0] = 1.0f - (float)y / (float)height;
        try {
            this.ctl.setRange(pos, pos, colors);
        }
        catch (Exception e) {
            System.err.println("Error in " + this.getClass().getName() + ": " + e.getClass().getName() + ": " + e.getMessage());
            return;
        }
        this.oldX = x;
        this.oldY = y;
        this.sendUpdate(pos, pos);
    }

    public void mouseReleased(MouseEvent evt) {
        if ((evt.getModifiers() & (8 | 4)) == 0) {
            return;
        }
        this.state = (this.state + 1) % (this.hasAlpha ? 4 : 3);
        if (cursor != null) {
            this.setCursor(cursor[this.state]);
        }
    }

    public void mouseDragged(MouseEvent evt) {
        if ((evt.getModifiers() & 0x10) == 0 && evt.getModifiers() != 0) {
            return;
        }
        this.drag(evt.getX(), evt.getY(), this.oldX, this.oldY);
        this.oldX = evt.getX();
        this.oldY = evt.getY();
    }

    private void drag(int x, int y, int oldx, int oldy) {
        float[][] colors;
        int finish;
        int start;
        int width = this.getBounds().width;
        int height = this.getBounds().height;
        if (x < 0) {
            x = 0;
        } else if (x >= width) {
            x = width - 1;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= height) {
            y = height - 1;
        }
        if (oldx < 0) {
            oldx = 0;
        } else if (oldx >= width) {
            oldx = width - 1;
        }
        if (oldy < 0) {
            oldy = 0;
        } else if (oldy >= height) {
            oldy = height - 1;
        }
        int notelow = -1;
        int notehi = -1;
        float step = (float)(this.resolution - 1) / (float)width;
        int oldPos = (int)Math.floor((double)((float)oldx * step) + 0.5);
        int newPos = (int)Math.floor((double)((float)x * step) + 0.5);
        float oldVal = 1.0f - (float)oldy / (float)height;
        float newVal = 1.0f - (float)y / (float)height;
        if (newPos > oldPos) {
            start = oldPos;
            finish = newPos;
        } else {
            start = newPos;
            finish = oldPos;
        }
        try {
            colors = this.ctl.lookupRange(start, finish);
        }
        catch (Exception e) {
            System.err.println("Error in " + this.getClass().getName() + ": " + e.getClass().getName() + ": " + e.getMessage());
            return;
        }
        if (x == oldx) {
            colors[this.state][0] = newVal;
            notelow = notehi = newPos;
        } else {
            int adj;
            float hiVal;
            float loVal;
            if (newPos > oldPos) {
                loVal = newVal;
                hiVal = oldVal;
                adj = 1;
            } else {
                loVal = oldVal;
                hiVal = newVal;
                adj = 0;
            }
            int total = finish - start;
            int i = adj;
            while (i < total + adj) {
                float v;
                colors[this.state][i] = v = (hiVal * (float)(total - i) + loVal * (float)i) / (float)total;
                ++i;
            }
            notelow = start + adj;
            notehi = finish + (1 - adj);
        }
        try {
            this.ctl.setRange(start, finish, colors);
        }
        catch (Exception e) {
            System.err.println("Error in " + this.getClass().getName() + ": " + e.getClass().getName() + ": " + e.getMessage());
            return;
        }
        if (notelow > -1 && notehi > -1) {
            this.sendUpdate(notelow, notehi);
        }
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void paint(Graphics g) {
        Object object = this.mutex;
        synchronized (object) {
            this.valLeft = 0;
            this.valRight = this.resolution - 1;
        }
        this.update(g);
    }

    public void update(Graphics g) {
        float[][] colors;
        int maxRight = this.resolution - 1;
        int left = 0;
        int right = maxRight;
        Object object = this.mutex;
        synchronized (object) {
            if (this.valLeft > this.valRight) {
                return;
            }
            left = this.valLeft;
            right = this.valRight;
            this.valLeft = maxRight;
            this.valRight = 0;
        }
        int numColors = this.ctl.getNumberOfColors() - 1;
        if (left < 0) {
            left = 0;
        } else if (left > numColors) {
            left = numColors;
        }
        if (right < 0) {
            right = 0;
        } else if (right > numColors) {
            right = numColors;
        }
        if (left > 0) {
            --left;
        }
        if (right < maxRight) {
            ++right;
        }
        int maxWidth = this.getBounds().width - 1;
        int maxHeight = this.getBounds().height - 1;
        int leftPixel = left * maxWidth / maxRight;
        int rightPixel = right * maxWidth / maxRight;
        g.setColor(Color.black);
        g.fillRect(leftPixel, 0, rightPixel - leftPixel + 1, maxHeight + 1);
        if (left > 0) {
            --left;
        }
        if (right < maxRight) {
            ++right;
        }
        leftPixel = left * maxWidth / maxRight;
        rightPixel = right * maxWidth / maxRight;
        try {
            colors = this.ctl.lookupRange(left, right < maxRight ? right + 1 : maxRight);
        }
        catch (Exception e) {
            System.err.println("Error in " + this.getClass().getName() + ": " + e.getClass().getName() + ": " + e.getMessage());
            colors = null;
        }
        if (colors == null) {
            return;
        }
        int prevEnd = leftPixel;
        int prevRed = (int)Math.floor((1.0f - colors[0][0]) * (float)maxHeight);
        int prevGreen = (int)Math.floor((1.0f - colors[1][0]) * (float)maxHeight);
        int prevBlue = (int)Math.floor((1.0f - colors[2][0]) * (float)maxHeight);
        int prevAlpha = this.hasAlpha ? (int)Math.floor((1.0f - colors[3][0]) * (float)maxHeight) : 0;
        int alpha = 0;
        int i = 1;
        while (i < colors[0].length) {
            int lineEnd = (left + i) * maxWidth / maxRight;
            int red = (int)Math.floor((1.0f - colors[0][i]) * (float)maxHeight);
            int green = (int)Math.floor((1.0f - colors[1][i]) * (float)maxHeight);
            int blue = (int)Math.floor((1.0f - colors[2][i]) * (float)maxHeight);
            if (this.hasAlpha) {
                alpha = (int)Math.floor((1.0f - colors[3][i]) * (float)maxHeight);
            }
            g.setColor(Color.red);
            g.drawLine(prevEnd, prevRed, lineEnd, red);
            g.setColor(Color.green);
            g.drawLine(prevEnd, prevGreen, lineEnd, green);
            g.setColor(bluish);
            g.drawLine(prevEnd, prevBlue, lineEnd, blue);
            if (this.hasAlpha) {
                g.setColor(Color.gray);
                g.drawLine(prevEnd, prevAlpha, lineEnd, alpha);
            }
            prevEnd = lineEnd;
            prevRed = red;
            prevGreen = green;
            prevBlue = blue;
            if (this.hasAlpha) {
                prevAlpha = alpha;
            }
            ++i;
        }
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize == null) {
            this.preferredSize = new Dimension(this.resolution, 170);
        }
        return this.preferredSize;
    }

    public void setPreferredSize(Dimension pref) {
        this.preferredSize = pref;
    }

    public void controlChanged(ControlEvent evt) throws RemoteException, VisADException {
        this.hasAlpha = this.ctl.getNumberOfComponents() == 4;
        this.resolution = this.ctl.getNumberOfColors();
        this.sendUpdate(0, this.getMapResolution() - 1);
    }
}

