/*
 * Decompiled with CFR 0.152.
 */
package visad.ss;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.JComponent;

public class SSLayout
implements LayoutManager {
    private int NumCols;
    private int NumRows;
    private int ColSpace;
    private int RowSpace;

    public SSLayout(int ncol, int nrow, int wspace, int hspace) {
        this.NumCols = ncol;
        this.NumRows = nrow;
        this.ColSpace = wspace;
        this.RowSpace = hspace;
    }

    private Component[] fillOut(Component[] c) {
        System.err.println("Warning: spreadsheet cell layout is corrupted");
        Component[] nc = new Component[this.NumCols * this.NumRows];
        System.arraycopy(c, 0, nc, 0, c.length);
        int i = c.length;
        while (i < nc.length) {
            nc[i] = new JComponent(){

                public void paint(Graphics g) {
                }
            };
            ++i;
        }
        return nc;
    }

    public void layoutContainer(Container parent) {
        Component[] c = parent.getComponents();
        if (c.length < this.NumCols * this.NumRows) {
            c = this.fillOut(c);
        }
        int[] pw = new int[this.NumCols];
        int i = 0;
        while (i < this.NumCols) {
            pw[i] = c[i].getPreferredSize().width;
            ++i;
        }
        int[] ph = new int[this.NumRows];
        int j = 0;
        while (j < this.NumRows) {
            ph[j] = c[this.NumCols * j].getPreferredSize().height;
            ++j;
        }
        int sy = 0;
        int j2 = 0;
        while (j2 < this.NumRows) {
            int sx = 0;
            int i2 = 0;
            while (i2 < this.NumCols) {
                c[this.NumCols * j2 + i2].setBounds(sx, sy, pw[i2], ph[j2]);
                sx += pw[i2] + this.ColSpace;
                ++i2;
            }
            sy += ph[j2] + this.RowSpace;
            ++j2;
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public Dimension preferredLayoutSize(Container parent) {
        Component[] c = parent.getComponents();
        if (c.length < this.NumCols * this.NumRows) {
            c = this.fillOut(c);
        }
        int pwt = -this.ColSpace;
        int i = 0;
        while (i < this.NumCols) {
            pwt += c[i].getPreferredSize().width + this.ColSpace;
            ++i;
        }
        int pht = -this.RowSpace;
        int j = 0;
        while (j < this.NumRows) {
            pht += c[this.NumCols * j].getPreferredSize().height + this.RowSpace;
            ++j;
        }
        return new Dimension(pwt, pht);
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }
}

