/*
 * Decompiled with CFR 0.152.
 */
package visad.ss;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import visad.ConstantMap;
import visad.Data;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayRealType;
import visad.MathType;
import visad.RemoteServer;
import visad.ScalarMap;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.Form;
import visad.data.netcdf.Plain;
import visad.data.visad.VisADForm;
import visad.formula.FormulaManager;
import visad.ss.BasicSSCell;
import visad.ss.MappingDialog;
import visad.ss.SSCellChangeEvent;
import visad.ss.SSCellData;
import visad.ss.SSCellListener;
import visad.util.DataUtility;
import visad.util.Util;

public class FancySSCell
extends BasicSSCell
implements SSCellListener {
    public static final Color DARK_RED = new Color(0.5f, 0.0f, 0.0f);
    public static final Color DARK_GREEN = new Color(0.0f, 0.5f, 0.0f);
    public static final Color DARK_BLUE = new Color(0.0f, 0.0f, 0.5f);
    public static final Color DARK_YELLOW = new Color(0.5f, 0.5f, 0.0f);
    public static final Color DARK_PURPLE = new Color(0.5f, 0.0f, 0.5f);
    public static final Color DARK_CYAN = new Color(0.0f, 0.5f, 0.5f);
    public static final Border B_EMPTY = new LineBorder(Color.gray, 3);
    public static final Border B_HIGHLIGHT = new LineBorder(Color.yellow, 3);
    public static final Border B_UNKNOWN = new LineBorder(DARK_PURPLE, 3);
    public static final Border B_DIRECT = new LineBorder(DARK_CYAN, 3);
    public static final Border B_URL = new LineBorder(DARK_GREEN, 3);
    public static final Border B_FORMULA = new LineBorder(DARK_RED, 3);
    public static final Border B_RMI = new LineBorder(DARK_BLUE, 3);
    public static final Border B_REMOTE = new LineBorder(DARK_YELLOW, 3);
    public static final Border B_MULTI = new CompoundBorder(new CompoundBorder(new LineBorder(DARK_RED), new LineBorder(DARK_GREEN)), new LineBorder(DARK_BLUE));
    protected static JFileChooser FileBox = Util.getVisADFileChooser();
    protected Frame Parent;
    protected JFrame WidgetFrame;
    protected boolean Selected = false;
    protected boolean AutoSwitch = true;
    protected boolean AutoDetect = true;
    protected boolean AutoShowControls = true;
    private Object MapLock = new Object();
    private int MapCount = 0;
    private boolean mapDialogUp = false;

    public FancySSCell(String name) throws VisADException, RemoteException {
        this(name, null, null, false, null, null);
    }

    public FancySSCell(String name, Frame parent) throws VisADException, RemoteException {
        this(name, null, null, false, null, parent);
    }

    public FancySSCell(String name, FormulaManager fman, Frame parent) throws VisADException, RemoteException {
        this(name, fman, null, false, null, parent);
    }

    public FancySSCell(String name, RemoteServer rs, Frame parent) throws VisADException, RemoteException {
        this(name, null, rs, false, null, parent);
    }

    public FancySSCell(String name, String save, Frame parent) throws VisADException, RemoteException {
        this(name, null, null, false, save, parent);
    }

    public FancySSCell(String name, FormulaManager fman, RemoteServer rs, String save, Frame parent) throws VisADException, RemoteException {
        this(name, fman, rs, false, save, parent);
    }

    public FancySSCell(String name, FormulaManager fman, RemoteServer rs, boolean slave, String save, Frame parent) throws VisADException, RemoteException {
        super(name, fman, rs, slave, save);
        this.Parent = parent;
        this.WidgetFrame = new JFrame("Controls (" + this.Name + ")");
        Util.invoke(false, BasicSSCell.DEBUG, new Runnable(){

            public void run() {
                FancySSCell.this.setHighlighted(false);
            }
        });
        this.addSSCellListener(this);
    }

    public void removeData(String varName) throws VisADException, RemoteException {
        super.removeData(varName);
        if (this.CellData.size() == 0) {
            this.clearWidgetFrame();
        }
    }

    public void loadDataSource(String source) {
        this.loadDataSource(source, -1);
    }

    public void loadDataSource(String source, int type) {
        final String fsource = source;
        final int ftype = type;
        final FancySSCell cell = this;
        Runnable load = new Runnable(){

            public void run() {
                try {
                    cell.addDataSource(fsource, ftype);
                    if (!cell.hasData()) {
                        JOptionPane.showMessageDialog(FancySSCell.this.Parent, "Unable to import data", "Error importing data", 0);
                    }
                }
                catch (VisADException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                    JOptionPane.showMessageDialog(FancySSCell.this.Parent, exc.getMessage(), "Error importing data", 0);
                }
                catch (RemoteException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                    JOptionPane.showMessageDialog(FancySSCell.this.Parent, exc.getMessage(), "Error importing data", 0);
                }
            }
        };
        Thread t = new Thread(load);
        t.start();
    }

    public void loadDataDialog() {
        FileBox.setDialogType(0);
        if (FileBox.showOpenDialog(this.Parent) != 0) {
            return;
        }
        File f = FileBox.getSelectedFile();
        if (!f.exists()) {
            JOptionPane.showMessageDialog(this.Parent, f.getName() + " does not exist", "Cannot load file", 0);
            return;
        }
        this.loadDataSource(f.getAbsolutePath(), 1);
    }

    private File getSaveFile() {
        if (!this.hasData()) {
            JOptionPane.showMessageDialog(this.Parent, "This cell is empty.", "Nothing to save", 0);
            return null;
        }
        FileBox.setDialogType(1);
        if (FileBox.showSaveDialog(this.Parent) != 0) {
            return null;
        }
        return FileBox.getSelectedFile();
    }

    public void saveDataDialog(String varName, Form saveForm) {
        final File file = this.getSaveFile();
        if (file == null) {
            return;
        }
        final FancySSCell cell = this;
        final String fname = varName;
        final Form form = saveForm;
        Runnable saveFile = new Runnable(){

            public void run() {
                String msg = "Could not save the dataset to the file \"" + file.getName() + "\" in " + form.getName() + " format. ";
                try {
                    cell.saveData(fname, file.getAbsolutePath(), form);
                }
                catch (BadFormException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                    msg = msg + "An error occurred: " + exc.getMessage();
                    JOptionPane.showMessageDialog(FancySSCell.this.Parent, msg, "Error saving data", 0);
                }
                catch (RemoteException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                    msg = msg + "A remote error occurred: " + exc.getMessage();
                    JOptionPane.showMessageDialog(FancySSCell.this.Parent, msg, "Error saving data", 0);
                }
                catch (IOException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                    msg = msg + "An I/O error occurred: " + exc.getMessage();
                    JOptionPane.showMessageDialog(FancySSCell.this.Parent, msg, "Error saving data", 0);
                }
                catch (VisADException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                    msg = msg + "An error occurred: " + exc.getMessage();
                    JOptionPane.showMessageDialog(FancySSCell.this.Parent, msg, "Error saving data", 0);
                }
            }
        };
        Thread t = new Thread(saveFile);
        t.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForMaps() {
        Object object = this.MapLock;
        synchronized (object) {
            while (this.MapCount > 0) {
                try {
                    this.MapLock.wait();
                }
                catch (InterruptedException exc) {
                    if (!BasicSSCell.DEBUG || BasicSSCell.DEBUG_LEVEL < 3) continue;
                    exc.printStackTrace();
                }
            }
            return;
        }
    }

    protected SSCellData addReferenceImpl(int id, DataReferenceImpl ref, ConstantMap[] cmaps, String source, int type, boolean notify, boolean checkErrors) throws VisADException, RemoteException {
        Object object = this.MapLock;
        synchronized (object) {
            ++this.MapCount;
        }
        return super.addReferenceImpl(id, ref, cmaps, source, type, notify, checkErrors);
    }

    public boolean confirmClear() {
        int ans;
        return !this.othersDepend() || (ans = JOptionPane.showConfirmDialog(null, "Other cells depend on this cell. Are you sure you want to clear it?", "Warning", 0)) == 0;
    }

    public boolean smartClear() throws VisADException, RemoteException {
        if (this.confirmClear()) {
            this.clearWidgetFrame();
            this.clearCell();
            return true;
        }
        return false;
    }

    public boolean smartDestroy() throws VisADException, RemoteException {
        if (this.confirmClear()) {
            this.clearWidgetFrame();
            this.destroyCell();
            return true;
        }
        return false;
    }

    public void setMapsAuto(ScalarMap[] maps) throws VisADException, RemoteException {
        if (this.AutoSwitch && maps != null) {
            int need = 0;
            int i = 0;
            while (i < maps.length) {
                DisplayRealType drt = maps[i].getDisplayScalar();
                if (drt.equals(Display.ZAxis) || drt.equals(Display.Latitude)) {
                    need = 2;
                }
                if ((drt.equals(Display.Alpha) || drt.equals(Display.RGBA)) && need < 1) {
                    need = 1;
                }
                ++i;
            }
            if (need == 2) {
                this.setDimension(1);
            } else if (need == 1 && this.Dim != 1) {
                this.setDimension(3);
            }
        }
        this.setMaps(maps);
    }

    public void setMaps(ScalarMap[] maps) throws VisADException, RemoteException {
        super.setMaps(maps);
        if (this.WidgetFrame.isVisible() || this.AutoShowControls) {
            this.showWidgetFrame();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addMapDialog() {
        block11: {
            block10: {
                if (this.mapDialogUp) {
                    return;
                }
                this.mapDialogUp = true;
                try {
                    if (this.getDataCount() == 0) {
                        JOptionPane.showMessageDialog(this.Parent, "This cell has no data", "FancySSCell error", 0);
                        Object var5_1 = null;
                        this.mapDialogUp = false;
                        return;
                    }
                    MappingDialog mapDialog = new MappingDialog(this.Parent, this.getData(), this.getMaps(), this.Dim != 2 || this.AutoSwitch, this.Dim == 1 || this.AutoSwitch);
                    mapDialog.display();
                    if (!mapDialog.okPressed()) {
                        break block10;
                    }
                    try {
                        this.setMapsAuto(mapDialog.getMaps());
                    }
                    catch (VisADException exc) {
                        if (BasicSSCell.DEBUG) {
                            exc.printStackTrace();
                        }
                        JOptionPane.showMessageDialog(this.Parent, "This combination of mappings is not valid: " + exc.getMessage(), "Cannot assign mappings", 0);
                    }
                    catch (RemoteException exc) {
                        if (BasicSSCell.DEBUG) {
                            exc.printStackTrace();
                        }
                        JOptionPane.showMessageDialog(this.Parent, "This combination of mappings is not valid: " + exc.getMessage(), "Cannot assign mappings", 0);
                    }
                    break block11;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    this.mapDialogUp = false;
                    throw throwable;
                }
            }
            Object var5_2 = null;
            this.mapDialogUp = false;
            return;
        }
        Object var5_3 = null;
        this.mapDialogUp = false;
    }

    protected void autoDetectMappings() throws VisADException, RemoteException {
        if (this.AutoDetect) {
            boolean allow3d = this.Dim != 2 || this.AutoSwitch;
            int len = this.getDataCount();
            Data[] data = this.getData();
            MathType[] types = new MathType[len];
            int i = 0;
            while (i < len) {
                Data d = data[i];
                types[i] = d == null ? null : d.getType();
                ++i;
            }
            ScalarMap[] maps = DataUtility.guessMaps(types, allow3d);
            this.setMapsAuto(maps);
        }
        Object object = this.MapLock;
        synchronized (object) {
            --this.MapCount;
            this.MapLock.notifyAll();
        }
    }

    public synchronized void showWidgetFrame() {
        if (this.VDisplay == null || this.CellData.size() == 0) {
            return;
        }
        Util.invoke(false, BasicSSCell.DEBUG, new Runnable(){

            public void run() {
                Container jc = FancySSCell.this.VDisplay.getWidgetPanel();
                if (jc != null && jc.getComponentCount() > 0) {
                    FancySSCell.this.WidgetFrame.setContentPane(jc);
                    FancySSCell.this.WidgetFrame.pack();
                    ((Component)FancySSCell.this.WidgetFrame).setVisible(true);
                }
            }
        });
    }

    public void hideWidgetFrame() {
        Util.invoke(false, BasicSSCell.DEBUG, new Runnable(){

            public void run() {
                ((Component)FancySSCell.this.WidgetFrame).setVisible(false);
            }
        });
    }

    public void setBorderEnabled(boolean value) {
        if (value) {
            this.setSelected(this.Selected);
        } else {
            this.setBorder(null);
        }
    }

    public void setSelected(boolean value) {
        if (this.Selected == value) {
            return;
        }
        this.Selected = value;
        Util.invoke(false, BasicSSCell.DEBUG, new Runnable(){

            public void run() {
                FancySSCell.this.setHighlighted(FancySSCell.this.Selected);
                if (!FancySSCell.this.Selected) {
                    FancySSCell.this.hideWidgetFrame();
                } else if (FancySSCell.this.AutoShowControls) {
                    FancySSCell.this.showWidgetFrame();
                }
                FancySSCell.this.refresh();
            }
        });
    }

    public synchronized void setAutoSwitch(boolean value) {
        this.AutoSwitch = value;
    }

    public synchronized void setAutoDetect(boolean value) {
        this.AutoDetect = value;
    }

    public synchronized void setAutoShowControls(boolean value) {
        this.AutoShowControls = value;
    }

    private void clearWidgetFrame() {
        Util.invoke(false, BasicSSCell.DEBUG, new Runnable(){

            public void run() {
                ((Component)FancySSCell.this.WidgetFrame).setVisible(false);
                JPanel pane = new JPanel();
                pane.add((Component)new JLabel("No controls"), "CENTER");
                FancySSCell.this.WidgetFrame.setContentPane(pane);
            }
        });
    }

    private void setHighlighted(boolean hl) {
        if (hl) {
            this.setBorder(B_HIGHLIGHT);
        } else {
            int dataCount = this.getDataCount();
            if (dataCount == 0) {
                this.setBorder(B_EMPTY);
            } else if (dataCount == 1) {
                int type = this.getDataSourceType(this.getFirstVariableName());
                if (type == 0) {
                    this.setBorder(B_DIRECT);
                } else if (type == 1) {
                    this.setBorder(B_URL);
                } else if (type == 2) {
                    this.setBorder(B_FORMULA);
                } else if (type == 3) {
                    this.setBorder(B_RMI);
                } else if (type == 4) {
                    this.setBorder(B_REMOTE);
                } else {
                    this.setBorder(B_UNKNOWN);
                }
            } else {
                this.setBorder(B_MULTI);
            }
        }
    }

    public void ssCellChanged(SSCellChangeEvent e) {
        int type = e.getChangeType();
        if (type == SSCellChangeEvent.DATA_CHANGE) {
            Util.invoke(false, BasicSSCell.DEBUG, new Runnable(){

                public void run() {
                    FancySSCell.this.setHighlighted(FancySSCell.this.Selected);
                }
            });
            if (!this.IsRemote) {
                Data value;
                block14: {
                    value = null;
                    try {
                        value = (Data)this.fm.getThing(e.getVariableName());
                    }
                    catch (ClassCastException exc) {
                        if (BasicSSCell.DEBUG) {
                            exc.printStackTrace();
                        }
                    }
                    catch (VisADException exc) {
                        if (!BasicSSCell.DEBUG) break block14;
                        exc.printStackTrace();
                    }
                }
                try {
                    if (value != null) {
                        this.autoDetectMappings();
                    }
                }
                catch (VisADException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                }
                catch (RemoteException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                }
            }
        } else if (type == SSCellChangeEvent.DISPLAY_CHANGE && this.IsRemote && this.AutoShowControls) {
            this.showWidgetFrame();
        }
    }

    public void captureDialog() {
        final File f = this.getSaveFile();
        if (f == null) {
            return;
        }
        final FancySSCell cell = this;
        Runnable captureImage = new Runnable(){

            public void run() {
                String msg = "Could not save image snapshot to file \"" + f.getName() + "\" in JPEG format. ";
                try {
                    cell.captureImage(f);
                }
                catch (VisADException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                    msg = msg + "An error occurred: " + exc.getMessage();
                    JOptionPane.showMessageDialog(FancySSCell.this.Parent, msg, "Error saving data", 0);
                }
                catch (IOException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                    msg = msg + "An I/O error occurred: " + exc.getMessage();
                    JOptionPane.showMessageDialog(FancySSCell.this.Parent, msg, "Error saving data", 0);
                }
            }
        };
        Thread t = new Thread(captureImage);
        t.start();
    }

    public boolean getAutoSwitch() {
        return this.AutoSwitch;
    }

    public boolean getAutoDetect() {
        return this.AutoDetect;
    }

    public boolean getAutoShowControls() {
        return this.AutoShowControls;
    }

    public boolean hasControls() {
        if (this.VDisplay == null || this.CellData.size() == 0) {
            return false;
        }
        Container jc = this.VDisplay.getWidgetPanel();
        if (jc == null) {
            return false;
        }
        return jc.getComponentCount() > 0;
    }

    public void loadDataRMI(String s) {
        this.loadDataSource(s, 3);
    }

    public synchronized void loadDataString(String s) {
        this.loadDataSource(s, 1);
    }

    public void loadDataURL(URL u) {
        this.loadDataSource(u.toString(), 1);
    }

    public void saveDataDialog(boolean netcdf) {
        block2: {
            try {
                Form f = netcdf ? new Plain() : new VisADForm();
                this.saveDataDialog(this.getFirstVariableName(), f);
            }
            catch (VisADException exc) {
                if (!BasicSSCell.DEBUG) break block2;
                exc.printStackTrace();
            }
        }
    }

    public void saveDataDialog(Form saveForm) {
        this.saveDataDialog(this.getFirstVariableName(), saveForm);
    }
}

