/*
 * Decompiled with CFR 0.152.
 */
package visad.paoloa;

import java.io.IOException;
import java.rmi.RemoteException;
import visad.Field;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.Linear2DSet;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;
import visad.data.netcdf.Plain;

public class NV {
    int ntimes;
    int nlines;
    int nelements;
    int[] time_to_sample;
    int[][] sample_to_time;
    Field nasti;
    int spectrum_index;
    boolean java2d = false;
    RealType time;
    RealType wnum1;
    RealType atmosphericRadiance;
    RealType image_line;
    RealType image_element;
    float wnum_low;
    float wnum_hi;
    Linear2DSet image_set;
    RealTupleType image_domain;
    FunctionType image_type;
    FunctionType red_bar_type;

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        if (args.length < 1) {
            System.out.println("To run this program, type \"java visad.paoloa.NV file.nc\"");
            System.out.println("where file.nc is a netCDF file containing a NAST-I file.");
            return;
        }
        NV nV = new NV(args[0]);
    }

    public NV(String filename) throws VisADException, RemoteException, IOException {
        Plain plain = new Plain();
        Tuple nasti_tuple = (Tuple)plain.open(filename);
        plain = null;
        this.nasti = (Field)nasti_tuple.getComponent(2);
        FunctionType nasti_type = (FunctionType)this.nasti.getType();
        TupleType nasti_range_type = (TupleType)nasti_type.getRange();
        int angle_index = nasti_range_type.getIndex("sceneMirrorAngle");
        this.time = (RealType)nasti_type.getDomain().getComponent(0);
        Gridded1DSet time_set = (Gridded1DSet)this.nasti.getDomainSet();
        float[][] t = time_set.getSamples();
        float[] times = t[0];
        this.ntimes = time_set.getLength();
        double[] angles = new double[this.ntimes];
        int[] elements = new int[this.ntimes];
        int[] lines = new int[this.ntimes];
        int line = 0;
        int max_element = 0;
        int i = 0;
        while (i < this.ntimes) {
            angles[i] = ((Real)((Tuple)this.nasti.getSample(i)).getComponent(angle_index)).getValue();
            if (i <= 0 || angles[i] < angles[i - 1]) {
                // empty if block
            }
            lines[i] = ++line;
            elements[i] = (int)Math.round((angles[i] + 45.0) / 7.5);
            if (elements[i] < 0) {
                System.out.println("negative element " + elements[i]);
                System.exit(0);
            }
            if (elements[i] > 12) {
                System.out.println("element > 12: " + elements[i]);
                System.exit(0);
            }
            if (elements[i] > max_element) {
                max_element = elements[i];
            }
            ++i;
        }
        if (max_element > 12) {
            System.out.println("max_element = " + max_element + " too large");
            System.exit(0);
        }
        this.nlines = line + 1;
        this.nelements = 13;
        System.out.println("nlines = " + this.nlines + " nelements = " + this.nelements);
        this.spectrum_index = nasti_range_type.getDimension() - 1;
        FunctionType spectrum_type = (FunctionType)nasti_range_type.getComponent(this.spectrum_index);
        this.wnum1 = (RealType)spectrum_type.getDomain().getComponent(0);
        this.atmosphericRadiance = (RealType)spectrum_type.getRange();
        Field spectrum0 = (Field)((Tuple)this.nasti.getSample(0)).getComponent(this.spectrum_index);
        Gridded1DSet spectrum_set = (Gridded1DSet)spectrum0.getDomainSet();
        float[] lows = spectrum_set.getLow();
        float[] his = spectrum_set.getHi();
        int spectrum_set_length = spectrum_set.getLength();
        float[] g = new float[this.nelements * this.nlines * spectrum_set_length];
        int k = 0;
        while (k < spectrum_set_length) {
            int i2 = 0;
            while (i2 < this.ntimes) {
                float radiance;
                Field spectrum = (Field)((Tuple)this.nasti.getSample(i2)).getComponent(this.spectrum_index);
                try {
                    radiance = (float)((Real)spectrum.getSample(k)).getValue();
                }
                catch (VisADException e1) {
                    radiance = Float.NaN;
                }
                g[elements[i2] + this.nelements * (lines[i2] + this.nlines * k)] = radiance;
                ++i2;
            }
            ++k;
        }
        this.make5d(this.nlines, this.nelements, spectrum_set_length, g);
    }

    private native void make5d(int var1, int var2, int var3, float[] var4);
}

