/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.rmi.RemoteException;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Raster;
import javax.media.j3d.Screen3D;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.DataReferenceImpl;
import visad.Display;
import visad.FlatField;
import visad.FunctionType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.java3d.DisplayAppletJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayPanelJ3D;
import visad.java3d.DisplayRendererJ3D;

public class VisADCanvasJ3D
extends Canvas3D {
    private DisplayRendererJ3D displayRenderer;
    private DisplayImplJ3D display;
    private Component component;
    Dimension prefSize = new Dimension(0, 0);
    boolean captureFlag = false;
    BufferedImage captureImage = null;
    private int width;
    private int height;
    private boolean offscreen = false;
    private static GraphicsConfiguration defaultConfig = VisADCanvasJ3D.makeConfig();
    private static final double METER_RATIO = 2.8222222222222223E-4;

    private static GraphicsConfiguration makeConfig() {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfigTemplate3D gct3d = new GraphicsConfigTemplate3D();
        GraphicsConfiguration c = gct3d.getBestConfiguration(d.getConfigurations());
        return c;
    }

    VisADCanvasJ3D(DisplayRendererJ3D renderer, Component c) {
        this(renderer, c, null);
    }

    VisADCanvasJ3D(DisplayRendererJ3D renderer, Component c, GraphicsConfiguration config) {
        super(config == null ? defaultConfig : config);
        this.displayRenderer = renderer;
        this.display = (DisplayImplJ3D)renderer.getDisplay();
        this.component = c;
    }

    VisADCanvasJ3D(DisplayRendererJ3D renderer, int w, int h) throws VisADException {
        super(defaultConfig, true);
        this.displayRenderer = renderer;
        this.display = (DisplayImplJ3D)renderer.getDisplay();
        this.component = null;
        this.offscreen = true;
        this.width = w;
        this.height = h;
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        ImageComponent2D image2d = new ImageComponent2D(1, image);
        this.setOffScreenBuffer(image2d);
        Screen3D screen = this.getScreen3D();
        int screen_width = 1280;
        int screen_height = 1024;
        screen.setSize(screen_width, screen_height);
        double width_in_meters = (double)screen_width * 2.8222222222222223E-4;
        double height_in_meters = (double)screen_height * 2.8222222222222223E-4;
        screen.setPhysicalScreenWidth(width_in_meters);
        screen.setPhysicalScreenHeight(height_in_meters);
    }

    public boolean getOffscreen() {
        return this.offscreen;
    }

    public void renderField(int i) {
        this.displayRenderer.drawCursorStringVector(this);
    }

    public void postSwap() {
        if (this.display == null) {
            return;
        }
        if (this.captureFlag || this.display.hasSlaves()) {
            this.captureFlag = false;
            int width = this.getSize().width;
            int height = this.getSize().height;
            GraphicsContext3D ctx = this.getGraphicsContext3D();
            Raster ras = new Raster();
            ras.setType(1);
            ras.setSize(width, height);
            ras.setOffset(0, 0);
            BufferedImage image = new BufferedImage(width, height, 1);
            ImageComponent2D image2d = new ImageComponent2D(1, image);
            ras.setImage(image2d);
            ctx.readRaster(ras);
            ImageComponent2D img_src = ras.getImage();
            if (this.captureImage != null) {
                this.captureImage.flush();
            }
            this.captureImage = img_src.getImage();
            this.displayRenderer.notifyCapture();
            if (this.display.hasSlaves()) {
                this.display.updateSlaves(this.captureImage);
            }
        }
        try {
            this.display.notifyListeners(3, 0, 0);
        }
        catch (VisADException e) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public void setPreferredSize(Dimension size) {
        this.prefSize = size;
    }

    public static void main(String[] args) throws RemoteException, VisADException {
        DisplayImplJ3D display = new DisplayImplJ3D("offscreen", 300, 300);
        RealType[] types = new RealType[]{RealType.Latitude, RealType.Longitude};
        RealTupleType earth_location = new RealTupleType(types);
        RealType vis_radiance = RealType.getRealType("vis_radiance");
        RealType ir_radiance = RealType.getRealType("ir_radiance");
        RealType[] types2 = new RealType[]{vis_radiance, ir_radiance};
        RealTupleType radiance = new RealTupleType(types2);
        FunctionType image_tuple = new FunctionType(earth_location, radiance);
        int size = 32;
        FlatField imaget1 = FlatField.makeField(image_tuple, size, false);
        display.addMap(new ScalarMap(RealType.Latitude, Display.YAxis));
        display.addMap(new ScalarMap(RealType.Longitude, Display.XAxis));
        display.addMap(new ScalarMap(vis_radiance, Display.RGB));
        DataReferenceImpl ref_imaget1 = new DataReferenceImpl("ref_imaget1");
        ref_imaget1.setData(imaget1);
        display.addReference(ref_imaget1, null);
        JFrame jframe1 = new JFrame("test off screen");
        jframe1.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 0));
        panel1.setAlignmentY(0.0f);
        panel1.setAlignmentX(0.0f);
        jframe1.setContentPane(panel1);
        jframe1.pack();
        ((Component)jframe1).setSize(300, 300);
        ((Component)jframe1).setVisible(true);
        while (true) {
            Graphics gp = panel1.getGraphics();
            BufferedImage image = display.getImage();
            gp.drawImage(image, 0, 0, panel1);
            System.out.println("drawImage");
            gp.dispose();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
            }
        }
    }

    public void stop() {
        this.stopRenderer();
        this.display = null;
        this.displayRenderer = null;
        if (this.component instanceof DisplayPanelJ3D) {
            ((DisplayPanelJ3D)this.component).destroy();
        } else if (this.component instanceof DisplayAppletJ3D) {
            ((DisplayAppletJ3D)this.component).destroy();
        }
        this.component = null;
    }
}

