/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.awt.image.BufferedImage;
import java.rmi.RemoteException;
import java.util.Enumeration;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent3D;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Texture;
import visad.BadMappingException;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayInterruptException;
import visad.FunctionType;
import visad.RealTupleType;
import visad.RealType;
import visad.SetType;
import visad.ShadowType;
import visad.TextType;
import visad.TupleType;
import visad.UnimplementedException;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.ShadowFunctionTypeJ3D;
import visad.java3d.ShadowRealTupleTypeJ3D;
import visad.java3d.ShadowRealTypeJ3D;
import visad.java3d.ShadowSetTypeJ3D;
import visad.java3d.ShadowTextTypeJ3D;
import visad.java3d.ShadowTupleTypeJ3D;
import visad.java3d.ShadowTypeJ3D;
import visad.util.Delay;

public abstract class RendererJ3D
extends DataRenderer {
    Switch sw;
    BranchGroup swParent;
    private static final int currentIndex = 0;
    BranchGroup[] branches;
    boolean[] switchFlags = new boolean[]{false, false, false};
    boolean[] branchNonEmpty = new boolean[]{false, false, false};

    public void setLinks(DataDisplayLink[] links, DisplayImpl d) throws VisADException {
        if (this.getDisplay() != null || this.getLinks() != null) {
            throw new DisplayException("RendererJ3D.setLinks: already set\nyou are probably re-using a DataRenderer");
        }
        if (!(d instanceof DisplayImplJ3D)) {
            throw new DisplayException("RendererJ3D.setLinks: must be DisplayImplJ3D");
        }
        this.setDisplay(d);
        this.setDisplayRenderer(d.getDisplayRenderer());
        this.setLinks(links);
        this.sw = new Switch();
        this.sw.setCapability(12);
        this.sw.setCapability(13);
        this.sw.setCapability(14);
        this.sw.setCapability(17);
        this.sw.setCapability(18);
        this.swParent = new BranchGroup();
        this.swParent.setCapability(17);
        this.swParent.setCapability(12);
        this.swParent.addChild((Node)this.sw);
        this.addSwitch((DisplayRendererJ3D)this.getDisplayRenderer(), this.swParent);
        this.branches = new BranchGroup[3];
        int i = 0;
        while (i < 3) {
            this.branches[i] = new BranchGroup();
            this.branches[i].setCapability(12);
            this.branches[i].setCapability(13);
            this.branches[i].setCapability(14);
            this.sw.addChild((Node)this.branches[i]);
            ++i;
        }
        this.sw.setWhichChild(0);
        this.toggle(this.getEnabled());
    }

    public void toggle(boolean on) {
        if (this.sw != null) {
            this.sw.setWhichChild(on ? 0 : 1);
        }
        super.toggle(on);
    }

    public ShadowType makeShadowFunctionType(FunctionType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowFunctionTypeJ3D(type, link, parent);
    }

    public ShadowType makeShadowRealTupleType(RealTupleType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowRealTupleTypeJ3D(type, link, parent);
    }

    public ShadowType makeShadowRealType(RealType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowRealTypeJ3D(type, link, parent);
    }

    public ShadowType makeShadowSetType(SetType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowSetTypeJ3D(type, link, parent);
    }

    public ShadowType makeShadowTextType(TextType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowTextTypeJ3D(type, link, parent);
    }

    public ShadowType makeShadowTupleType(TupleType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowTupleTypeJ3D(type, link, parent);
    }

    abstract void addSwitch(DisplayRendererJ3D var1, BranchGroup var2);

    public boolean doAction() throws VisADException, RemoteException {
        boolean all_feasible = this.get_all_feasible();
        boolean any_changed = this.get_any_changed();
        boolean any_transform_control = this.get_any_transform_control();
        if (all_feasible && (any_changed || any_transform_control)) {
            BranchGroup branch;
            this.clearAVControls();
            try {
                branch = this.doTransform();
            }
            catch (OutOfMemoryError e) {
                this.clearBranch();
                branch = null;
                new Delay(250);
                Runtime.getRuntime().gc();
                Runtime.getRuntime().runFinalization();
                try {
                    branch = this.doTransform();
                }
                catch (BadMappingException ee) {
                    this.addException(ee);
                    branch = null;
                }
                catch (UnimplementedException ee) {
                    this.addException(ee);
                    branch = null;
                }
                catch (RemoteException ee) {
                    this.addException(ee);
                    branch = null;
                }
                catch (DisplayInterruptException ee) {
                    branch = null;
                }
            }
            catch (BadMappingException e) {
                this.addException(e);
                branch = null;
            }
            catch (UnimplementedException e) {
                this.addException(e);
                branch = null;
            }
            catch (RemoteException e) {
                this.addException(e);
                branch = null;
            }
            catch (DisplayInterruptException e) {
                branch = null;
            }
            if (branch != null) {
                boolean nextIndex = false;
                branch.detach();
                RendererJ3D e = this;
                synchronized (e) {
                    if (!this.branchNonEmpty[0] || this.branches[0].numChildren() == 0) {
                        this.branches[0].addChild((Node)branch);
                        this.branchNonEmpty[0] = true;
                    } else {
                        this.flush((Group)this.branches[0]);
                        this.branches[0].setChild((Node)branch, 0);
                    }
                }
            } else {
                this.clearBranch();
                all_feasible = false;
                this.set_all_feasible(all_feasible);
            }
        } else {
            DataDisplayLink[] links = this.getLinks();
            int i = 0;
            while (i < links.length) {
                links[i].clearData();
                ++i;
            }
        }
        return all_feasible && (any_changed || any_transform_control);
    }

    public BranchGroup getBranch() {
        RendererJ3D rendererJ3D = this;
        synchronized (rendererJ3D) {
            if (this.branchNonEmpty[0]) {
                BranchGroup branchGroup = (BranchGroup)this.branches[0].getChild(0);
                return branchGroup;
            }
            BranchGroup branchGroup = null;
            return branchGroup;
        }
    }

    public void setBranchEarly(BranchGroup branch) {
        ShadowTypeJ3D shadow = (ShadowTypeJ3D)this.getLinks()[0].getShadow();
        shadow.ensureNotEmpty(branch);
        branch.detach();
        RendererJ3D rendererJ3D = this;
        synchronized (rendererJ3D) {
            if (!this.branchNonEmpty[0] || this.branches[0].numChildren() == 0) {
                this.branches[0].addChild((Node)branch);
                this.branchNonEmpty[0] = true;
            } else {
                this.flush((Group)this.branches[0]);
                this.branches[0].setChild((Node)branch, 0);
            }
        }
    }

    public void clearBranch() {
        BranchGroup branchGroup = this.branches[0];
        synchronized (branchGroup) {
            if (this.branchNonEmpty[0]) {
                this.flush((Group)this.branches[0]);
                Enumeration ch = this.branches[0].getAllChildren();
                while (ch.hasMoreElements()) {
                    BranchGroup b = (BranchGroup)ch.nextElement();
                    b.detach();
                }
            }
        }
        this.branchNonEmpty[0] = false;
    }

    public void flush(Group branch) {
        Enumeration ch = branch.getAllChildren();
        while (ch.hasMoreElements()) {
            BufferedImage[] images;
            ImageComponent ic;
            Texture texture;
            Appearance appearance;
            Node n = (Node)ch.nextElement();
            if (n instanceof Group) {
                this.flush((Group)n);
                continue;
            }
            if (!(n instanceof Shape3D) || !((Shape3D)n).getCapability(14) || (appearance = ((Shape3D)n).getAppearance()) == null || !appearance.getCapability(2) || (texture = appearance.getTexture()) == null || !texture.getCapability(4) || (ic = texture.getImage(0)) == null || !ic.getCapability(2)) continue;
            if (ic instanceof ImageComponent2D) {
                BufferedImage image = ((ImageComponent2D)ic).getImage();
                if (image == null) continue;
                image.flush();
                continue;
            }
            if (!(ic instanceof ImageComponent3D) || (images = ((ImageComponent3D)ic).getImage()) == null) continue;
            int j = 0;
            while (j < images.length) {
                if (images[j] != null) {
                    images[j].flush();
                }
                ++j;
            }
        }
    }

    public void clearScene() {
        this.flush((Group)this.swParent);
        this.swParent.detach();
        ((DisplayRendererJ3D)this.getDisplayRenderer()).clearScene(this);
    }

    public abstract BranchGroup doTransform() throws VisADException, RemoteException;
}

