/*
 * Decompiled with CFR 0.152.
 */
package visad.georef;

import java.rmi.RemoteException;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.VisADException;
import visad.browser.Convert;
import visad.georef.LatLonPoint;

public class LatLonTuple
extends RealTuple
implements LatLonPoint {
    private Real lat;
    private Real lon;

    public LatLonTuple(double lat, double lon) throws VisADException, RemoteException {
        this(new Real(RealType.Latitude, lat), new Real(RealType.Longitude, lon));
    }

    public LatLonTuple(Real lat, Real lon) throws VisADException, RemoteException {
        super(RealTupleType.LatitudeLongitudeTuple, new Real[]{lat, lon}, null);
        this.lat = lat;
        this.lon = lon;
    }

    public Real getLatitude() {
        return this.lat;
    }

    public Real getLongitude() {
        return this.lon;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Lat: ");
        buf.append(Convert.shortString(this.lat.getValue()));
        buf.append(" Lon: ");
        buf.append(Convert.shortString(this.lon.getValue()));
        return buf.toString();
    }
}

