/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import visad.MathType;
import visad.SampledSet;
import visad.SetType;
import visad.UnionSet;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryGeneric;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinarySampledSet;
import visad.data.visad.object.BinarySetType;
import visad.data.visad.object.BinaryUnknown;

public class BinaryUnionSet
implements BinaryObject {
    static /* synthetic */ Class class$visad$UnionSet;

    public static final int computeBytes(SampledSet[] sets) {
        int setsLen = 5;
        int i = 0;
        while (i < sets.length) {
            int len = BinaryGeneric.computeBytes(sets[i]);
            if (len < 0) {
                return -1;
            }
            setsLen += len;
            ++i;
        }
        return 10 + BinarySampledSet.computeBytes(sets) + 1;
    }

    public static final UnionSet read(BinaryReader reader) throws IOException, VisADException {
        BinaryObjectCache cache = reader.getTypeCache();
        DataInput file = reader.getInput();
        int typeIndex = file.readInt();
        SetType st = (SetType)cache.get(typeIndex);
        SampledSet[] sets = null;
        boolean reading = true;
        while (reading) {
            byte directive;
            try {
                directive = file.readByte();
            }
            catch (EOFException eofe) {
                return null;
            }
            switch (directive) {
                case 11: {
                    sets = BinarySampledSet.readList(reader);
                    break;
                }
                case 80: {
                    reading = false;
                    break;
                }
                default: {
                    throw new IOException("Unknown UnionSet directive " + directive);
                }
            }
        }
        if (st == null) {
            throw new IOException("No SetType found for UnionSet");
        }
        if (sets == null) {
            throw new IOException("No sets found for UnionSet");
        }
        return new UnionSet((MathType)st, sets);
    }

    public static final void writeDependentData(BinaryWriter writer, SetType type, SampledSet[] sets, UnionSet set, Object token) throws IOException {
        if (!(set.getClass().equals(class$visad$UnionSet == null ? (class$visad$UnionSet = BinaryUnionSet.class$("visad.UnionSet")) : class$visad$UnionSet) || set instanceof UnionSet && set instanceof Saveable)) {
            return;
        }
        Object dependToken = token == BinaryObject.SAVE_DEPEND_BIG ? token : BinaryObject.SAVE_DEPEND;
        BinarySetType.write(writer, type, set, BinaryObject.SAVE_DATA);
        if (sets != null) {
            int i = 0;
            while (i < sets.length) {
                BinaryGeneric.write(writer, sets[i], dependToken);
                ++i;
            }
        }
    }

    public static final void write(BinaryWriter writer, SetType type, SampledSet[] sets, UnionSet set, Object token) throws IOException {
        BinaryUnionSet.writeDependentData(writer, type, sets, set, token);
        if (token == BinaryObject.SAVE_DEPEND || token == BinaryObject.SAVE_DEPEND_BIG) {
            return;
        }
        if (!(set.getClass().equals(class$visad$UnionSet == null ? (class$visad$UnionSet = BinaryUnionSet.class$("visad.UnionSet")) : class$visad$UnionSet) || set instanceof UnionSet && set instanceof Saveable)) {
            BinaryUnknown.write(writer, set, token);
            return;
        }
        int typeIndex = writer.getTypeCache().getIndex(type);
        if (typeIndex < 0) {
            throw new IOException("SetType " + type + " not cached");
        }
        int objLen = BinaryUnionSet.computeBytes(sets);
        DataOutput file = writer.getOutput();
        file.writeByte(2);
        file.writeInt(objLen);
        file.writeByte(37);
        file.writeInt(typeIndex);
        BinarySampledSet.writeList(writer, sets, token);
        file.writeByte(80);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

