/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.Integer3DSet;
import visad.IntegerNDSet;
import visad.IntegerSet;
import visad.Linear1DSet;
import visad.LinearSet;
import visad.MathType;
import visad.SetType;
import visad.Unit;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryCoordinateSystem;
import visad.data.visad.object.BinaryErrorEstimate;
import visad.data.visad.object.BinaryGeneric;
import visad.data.visad.object.BinaryIntegerArray;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinarySetType;
import visad.data.visad.object.BinaryUnit;
import visad.data.visad.object.BinaryUnknown;

public class BinaryIntegerSet
implements BinaryObject {
    public static final int computeBytes(boolean matchedTypes, int[] lengths, Integer1DSet[] comps, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors) {
        int compsLen;
        if (matchedTypes) {
            compsLen = 1 + BinaryIntegerArray.computeBytes(lengths);
        } else {
            compsLen = 5;
            int i = 0;
            while (i < comps.length) {
                int size = BinaryGeneric.computeBytes(comps[i]);
                if (size < 0) {
                    compsLen = -1;
                    break;
                }
                compsLen += size;
                ++i;
            }
        }
        if (compsLen < 0) {
            return compsLen;
        }
        int unitsLen = BinaryUnit.computeBytes(units);
        int errorsLen = BinaryErrorEstimate.computeBytes(errors);
        return 10 + compsLen + (cs == null ? 0 : 5) + (unitsLen == 0 ? 0 : unitsLen + 1) + (errorsLen == 0 ? 0 : errorsLen + 1) + 1;
    }

    public static final Integer1DSet[] getComponents(LinearSet set) {
        int dim = ((GriddedSet)((Object)set)).getDimension();
        Integer1DSet[] comps = new Integer1DSet[dim];
        int i = 0;
        while (i < dim) {
            Linear1DSet comp = set.getLinear1DComponent(i);
            if (comp instanceof Integer1DSet) {
                comps[i] = (Integer1DSet)comp;
            } else if (comp.getFirst() == 0.0) {
                try {
                    comps[i] = new Integer1DSet(comp.getType(), comp.getLength(), comp.getCoordinateSystem(), comp.getSetUnits(), comp.getSetErrors());
                }
                catch (VisADException ve) {
                    return null;
                }
            } else {
                System.err.println("Ignoring comp#" + i + ": " + comp);
                comps[i] = null;
            }
            ++i;
        }
        return comps;
    }

    public static boolean hasMatchedTypes(SetType type, Integer1DSet[] comps) {
        if (comps == null) {
            return true;
        }
        MathType[] dComp = type.getDomain().getComponents();
        if (dComp == null || dComp.length != comps.length) {
            return false;
        }
        boolean matchedTypes = true;
        int i = 0;
        while (i < dComp.length) {
            if (!dComp[i].equals(comps[i].getType())) {
                matchedTypes = false;
                break;
            }
            ++i;
        }
        return matchedTypes;
    }

    private static final Integer1DSet[] readInteger1DSets(BinaryReader reader) throws IOException, VisADException {
        DataInput file = reader.getInput();
        int len = file.readInt();
        Integer1DSet[] sets = new Integer1DSet[len];
        int i = 0;
        while (i < len) {
            sets[i] = (Integer1DSet)BinaryGeneric.read(reader);
            ++i;
        }
        return sets;
    }

    public static final GriddedSet read(BinaryReader reader, byte dataType) throws IOException, VisADException {
        int dim;
        BinaryObjectCache cSysCache = reader.getCoordinateSystemCache();
        BinaryObjectCache typeCache = reader.getTypeCache();
        DataInput file = reader.getInput();
        int typeIndex = file.readInt();
        SetType st = (SetType)typeCache.get(typeIndex);
        int[] lengths = null;
        CoordinateSystem cs = null;
        Unit[] units = null;
        ErrorEstimate[] errs = null;
        Integer1DSet[] comps = null;
        boolean reading = true;
        while (reading) {
            byte directive;
            try {
                directive = file.readByte();
            }
            catch (EOFException eofe) {
                return null;
            }
            switch (directive) {
                case 3: {
                    lengths = BinaryIntegerArray.read(reader);
                    break;
                }
                case 14: {
                    comps = BinaryIntegerSet.readInteger1DSets(reader);
                    break;
                }
                case 32: {
                    int index = file.readInt();
                    cs = (CoordinateSystem)cSysCache.get(index);
                    break;
                }
                case 40: {
                    units = BinaryUnit.readList(reader);
                    break;
                }
                case 41: {
                    errs = BinaryErrorEstimate.readList(reader);
                    break;
                }
                case 80: {
                    reading = false;
                    break;
                }
                default: {
                    throw new IOException("Unknown IntegerSet directive " + directive);
                }
            }
        }
        if (st == null) {
            throw new IOException("No SetType found for IntegerSet");
        }
        if (comps != null) {
            if (lengths != null) {
                throw new IOException("Both components and lengths found for IntegerSet");
            }
            switch (dataType) {
                case 55: {
                    throw new IOException("Components specified for Integer1DSet");
                }
                case 56: {
                    return new Integer2DSet((MathType)st, comps, cs, units, errs);
                }
                case 57: {
                    return new Integer3DSet((MathType)st, comps, cs, units, errs);
                }
                case 58: {
                    return new IntegerNDSet((MathType)st, comps, cs, units, errs);
                }
            }
            throw new IOException("Unknown IntegerSet type " + dataType);
        }
        if (lengths == null) {
            throw new IOException("No lengths found for IntegerSet");
        }
        switch (dataType) {
            case 55: {
                dim = 1;
                break;
            }
            case 56: {
                dim = 2;
                break;
            }
            case 57: {
                dim = 3;
                break;
            }
            default: {
                dim = -1;
            }
        }
        if (dim > 0 && lengths.length != dim) {
            throw new VisADException("Expected " + dim + " length" + (dim > 1 ? "s" : "") + ", not " + lengths.length);
        }
        switch (dataType) {
            case 55: {
                return new Integer1DSet(st, lengths[0], cs, units, errs);
            }
            case 56: {
                return new Integer2DSet((MathType)st, lengths[0], lengths[1], cs, units, errs);
            }
            case 57: {
                return new Integer3DSet((MathType)st, lengths[0], lengths[1], lengths[2], cs, units, errs);
            }
            case 58: {
                return new IntegerNDSet((MathType)st, lengths, cs, units, errs);
            }
        }
        throw new IOException("Unknown IntegerSet type " + dataType);
    }

    public static final void writeDependentData(BinaryWriter writer, SetType type, Integer1DSet[] comps, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, GriddedSet set, Class canonicalClass, Object token) throws IOException {
        if (!(set.getClass().equals(canonicalClass) || set instanceof IntegerSet && set instanceof Saveable)) {
            return;
        }
        Object dependToken = token == BinaryObject.SAVE_DEPEND_BIG ? token : BinaryObject.SAVE_DEPEND;
        BinarySetType.write(writer, type, set, BinaryObject.SAVE_DATA);
        if (cs != null) {
            BinaryCoordinateSystem.write(writer, cs, BinaryObject.SAVE_DATA);
        }
        if (units != null) {
            BinaryUnit.writeList(writer, units, BinaryObject.SAVE_DATA);
        }
        if (errors != null) {
            BinaryErrorEstimate.writeList(writer, errors, BinaryObject.SAVE_DATA);
        }
        if (comps != null) {
            int i = 0;
            while (i < comps.length) {
                BinaryGeneric.write(writer, comps[i], dependToken);
                ++i;
            }
        }
    }

    public static final void write(BinaryWriter writer, SetType type, int[] lengths, Integer1DSet[] comps, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, GriddedSet set, Class canonicalClass, byte dataType, Object token) throws IOException {
        int typeIndex;
        BinaryIntegerSet.writeDependentData(writer, type, comps, cs, units, errors, set, canonicalClass, token);
        if (token == BinaryObject.SAVE_DEPEND || token == BinaryObject.SAVE_DEPEND_BIG) {
            return;
        }
        if (!(set.getClass().equals(canonicalClass) || set instanceof IntegerSet && set instanceof Saveable)) {
            BinaryUnknown.write(writer, set, token);
            return;
        }
        boolean matchedTypes = BinaryIntegerSet.hasMatchedTypes(type, comps);
        int dim = set.getDimension();
        if (!matchedTypes) {
            if (dataType == 55) {
                throw new IOException("Components specified for Integer1DSet");
            }
            if (comps.length != dim) {
                throw new IOException("Expected " + dim + " IntegerSet component" + (dim > 1 ? "s" : "") + ", not " + comps.length);
            }
        } else {
            if (lengths == null) {
                throw new IOException("Null " + canonicalClass.getName() + " lengths");
            }
            if (lengths.length != dim) {
                throw new IOException("Expected " + dim + " IntegerSet length" + (dim > 1 ? "s" : "") + ", not " + lengths.length);
            }
        }
        if ((typeIndex = writer.getTypeCache().getIndex(type)) < 0) {
            throw new IOException("SetType " + type + " not cached");
        }
        int csIndex = -1;
        if (cs != null && (csIndex = writer.getCoordinateSystemCache().getIndex(cs)) < 0) {
            throw new IOException("CoordinateSystem " + cs + " not cached");
        }
        int[] unitsIndex = null;
        if (units != null) {
            unitsIndex = BinaryUnit.lookupList(writer.getUnitCache(), units);
        }
        int[] errorsIndex = null;
        if (errors != null) {
            errorsIndex = BinaryErrorEstimate.lookupList(writer.getErrorEstimateCache(), errors);
        }
        int objLen = BinaryIntegerSet.computeBytes(matchedTypes, lengths, comps, cs, units, errors);
        DataOutput file = writer.getOutput();
        file.writeByte(2);
        file.writeInt(objLen);
        file.writeByte(dataType);
        file.writeInt(typeIndex);
        if (matchedTypes) {
            file.writeByte(3);
            BinaryIntegerArray.write(writer, lengths, token);
        } else {
            file.writeByte(14);
            file.writeInt(comps.length);
            int i = 0;
            while (i < comps.length) {
                BinaryGeneric.write(writer, comps[i], token);
                ++i;
            }
        }
        if (csIndex >= 0) {
            file.writeByte(32);
            file.writeInt(csIndex);
        }
        if (unitsIndex != null) {
            file.writeByte(40);
            BinaryIntegerArray.write(writer, unitsIndex, token);
        }
        if (errorsIndex != null) {
            file.writeByte(41);
            BinaryIntegerArray.write(writer, errorsIndex, token);
        }
        file.writeByte(80);
    }
}

