/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DDoubleSet;
import visad.Gridded2DDoubleSet;
import visad.Gridded3DDoubleSet;
import visad.GriddedDoubleSet;
import visad.GriddedSet;
import visad.MathType;
import visad.SetType;
import visad.Unit;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryCoordinateSystem;
import visad.data.visad.object.BinaryDoubleMatrix;
import visad.data.visad.object.BinaryErrorEstimate;
import visad.data.visad.object.BinaryIntegerArray;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinarySetType;
import visad.data.visad.object.BinaryUnit;
import visad.data.visad.object.BinaryUnknown;

public class BinaryGriddedDoubleSet
implements BinaryObject {
    public static final int computeBytes(double[][] samples, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors) {
        int unitsLen = BinaryUnit.computeBytes(units);
        int errorsLen = BinaryErrorEstimate.computeBytes(errors);
        return 11 + BinaryDoubleMatrix.computeBytes(samples) + 1 + BinaryIntegerArray.computeBytes(lengths) + (cs == null ? 0 : 5) + (unitsLen == 0 ? 0 : unitsLen + 1) + (errorsLen == 0 ? 0 : errorsLen + 1) + 1;
    }

    public static final GriddedSet read(BinaryReader reader, byte dataType) throws IOException, VisADException {
        int dim;
        BinaryObjectCache cSysCache = reader.getCoordinateSystemCache();
        BinaryObjectCache typeCache = reader.getTypeCache();
        DataInput file = reader.getInput();
        int typeIndex = file.readInt();
        SetType st = (SetType)typeCache.get(typeIndex);
        double[][] samples = null;
        int[] lengths = null;
        CoordinateSystem cs = null;
        Unit[] units = null;
        ErrorEstimate[] errs = null;
        boolean reading = true;
        while (reading) {
            byte directive;
            try {
                directive = file.readByte();
            }
            catch (EOFException eofe) {
                return null;
            }
            switch (directive) {
                case 7: {
                    samples = BinaryDoubleMatrix.read(reader);
                    break;
                }
                case 3: {
                    lengths = BinaryIntegerArray.read(reader);
                    break;
                }
                case 32: {
                    int index = file.readInt();
                    cs = (CoordinateSystem)cSysCache.get(index);
                    break;
                }
                case 40: {
                    units = BinaryUnit.readList(reader);
                    break;
                }
                case 41: {
                    errs = BinaryErrorEstimate.readList(reader);
                    break;
                }
                case 80: {
                    reading = false;
                    break;
                }
                default: {
                    throw new IOException("Unknown GriddedDoubleSet directive " + directive);
                }
            }
        }
        if (st == null) {
            throw new IOException("No SetType found for GriddedDoubleSet");
        }
        if (lengths == null) {
            throw new IOException("No lengths found for GriddedDoubleSet");
        }
        switch (dataType) {
            case 47: {
                dim = 1;
                break;
            }
            case 48: {
                dim = 2;
                break;
            }
            case 49: {
                dim = 3;
                break;
            }
            default: {
                throw new IOException("Unknown GriddedDoubleSet type " + dataType);
            }
        }
        if (samples != null && samples.length != dim) {
            throw new VisADException("Expected " + dim + "D sample array, not " + samples.length + "D");
        }
        switch (dataType) {
            case 47: {
                return new Gridded1DDoubleSet((MathType)st, samples, lengths[0], cs, units, errs);
            }
            case 48: {
                if (lengths.length == 1) {
                    return new Gridded2DDoubleSet((MathType)st, samples, lengths[0], cs, units, errs);
                }
                return new Gridded2DDoubleSet((MathType)st, samples, lengths[0], lengths[1], cs, units, errs);
            }
            case 49: {
                if (lengths.length == 1) {
                    return new Gridded3DDoubleSet((MathType)st, samples, lengths[0], cs, units, errs);
                }
                if (lengths.length == 2) {
                    return new Gridded3DDoubleSet((MathType)st, samples, lengths[0], lengths[1], cs, units, errs);
                }
                return new Gridded3DDoubleSet((MathType)st, samples, lengths[0], lengths[1], lengths[2], cs, units, errs);
            }
        }
        throw new IOException("Unknown GriddedDoubleSet type " + dataType);
    }

    public static final void writeDependentData(BinaryWriter writer, SetType type, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, GriddedSet set, Class canonicalClass, Object token) throws IOException {
        if (!(set.getClass().equals(canonicalClass) || set instanceof GriddedDoubleSet && set instanceof Saveable)) {
            return;
        }
        BinarySetType.write(writer, type, set, BinaryObject.SAVE_DATA);
        if (cs != null) {
            BinaryCoordinateSystem.write(writer, cs, BinaryObject.SAVE_DATA);
        }
        if (units != null) {
            BinaryUnit.writeList(writer, units, BinaryObject.SAVE_DATA);
        }
        if (errors != null) {
            BinaryErrorEstimate.writeList(writer, errors, BinaryObject.SAVE_DATA);
        }
    }

    public static final void write(BinaryWriter writer, SetType type, double[][] samples, int[] lengths, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, GriddedSet set, Class canonicalClass, byte dataType, Object token) throws IOException {
        int validLen;
        BinaryGriddedDoubleSet.writeDependentData(writer, type, cs, units, errors, set, canonicalClass, token);
        if (token == BinaryObject.SAVE_DEPEND || token == BinaryObject.SAVE_DEPEND_BIG) {
            return;
        }
        if (!(set.getClass().equals(canonicalClass) || set instanceof GriddedDoubleSet && set instanceof Saveable)) {
            BinaryUnknown.write(writer, set, token);
            return;
        }
        if (lengths == null) {
            throw new IOException("Null " + canonicalClass.getName() + " lengths");
        }
        switch (dataType) {
            case 47: {
                validLen = 1;
                break;
            }
            case 48: {
                validLen = 2;
                break;
            }
            case 49: {
                validLen = 3;
                break;
            }
            default: {
                throw new IOException("Invalid type " + dataType);
            }
        }
        if (samples != null && samples.length != validLen) {
            throw new IOException("Expected " + validLen + " sample list" + (validLen > 1 ? "s" : "") + ", not " + samples.length);
        }
        int typeIndex = writer.getTypeCache().getIndex(type);
        if (typeIndex < 0) {
            throw new IOException("SetType " + type + " not cached");
        }
        int csIndex = -1;
        if (cs != null && (csIndex = writer.getCoordinateSystemCache().getIndex(cs)) < 0) {
            throw new IOException("CoordinateSystem " + cs + " not cached");
        }
        int[] unitsIndex = null;
        if (units != null) {
            unitsIndex = BinaryUnit.lookupList(writer.getUnitCache(), units);
        }
        int[] errorsIndex = null;
        if (errors != null) {
            errorsIndex = BinaryErrorEstimate.lookupList(writer.getErrorEstimateCache(), errors);
        }
        int objLen = BinaryGriddedDoubleSet.computeBytes(samples, lengths, cs, units, errors);
        DataOutput file = writer.getOutput();
        file.writeByte(2);
        file.writeInt(objLen);
        file.writeByte(dataType);
        file.writeInt(typeIndex);
        file.writeByte(7);
        BinaryDoubleMatrix.write(writer, samples, token);
        file.writeByte(3);
        BinaryIntegerArray.write(writer, lengths, token);
        if (csIndex >= 0) {
            file.writeByte(32);
            file.writeInt(csIndex);
        }
        if (unitsIndex != null) {
            file.writeByte(40);
            BinaryIntegerArray.write(writer, unitsIndex, token);
        }
        if (errorsIndex != null) {
            file.writeByte(41);
            BinaryIntegerArray.write(writer, errorsIndex, token);
        }
        file.writeByte(80);
    }
}

