/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryIntegerArray;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinarySerializedObject;

public class BinaryCoordinateSystem
implements BinaryObject {
    public static final int computeBytes(CoordinateSystem cSys) {
        try {
            return BinaryCoordinateSystem.computeBytes(BinarySerializedObject.getBytes(cSys));
        }
        catch (IOException ioe) {
            return 0;
        }
    }

    private static final int computeBytes(byte[] serialObj) {
        return 5 + serialObj.length + 1;
    }

    public static final int computeBytes(CoordinateSystem[] array) {
        return BinaryIntegerArray.computeBytes(array);
    }

    public static final int[] lookupList(BinaryObjectCache cache, CoordinateSystem[] cSys) {
        boolean empty = true;
        int i = 0;
        while (i < cSys.length) {
            if (cSys[i] != null) {
                empty = false;
                break;
            }
            ++i;
        }
        if (empty) {
            return null;
        }
        int[] indices = new int[cSys.length];
        int i2 = 0;
        while (i2 < cSys.length) {
            indices[i2] = cSys[i2] == null ? -1 : cache.getIndex(cSys[i2]);
            ++i2;
        }
        return indices;
    }

    public static final CoordinateSystem read(BinaryReader reader) throws IOException {
        BinaryObjectCache cache = reader.getCoordinateSystemCache();
        DataInput file = reader.getInput();
        int objLen = file.readInt();
        int index = file.readInt();
        byte cSysSerial = file.readByte();
        if (cSysSerial != 20) {
            throw new IOException("Corrupted file (no CoordinateSystem serial marker)");
        }
        CoordinateSystem cs = (CoordinateSystem)BinarySerializedObject.read(file, objLen - 6 + 1);
        cache.add(index, cs);
        return cs;
    }

    public static final CoordinateSystem[] readList(BinaryReader reader) throws IOException {
        BinaryObjectCache cache = reader.getCoordinateSystemCache();
        DataInput file = reader.getInput();
        int len = file.readInt();
        if (len < 1) {
            throw new IOException("Corrupted file (bad CoordinateSystem array length " + len + ")");
        }
        CoordinateSystem[] cSys = new CoordinateSystem[len];
        int i = 0;
        while (i < len) {
            int uIndex = file.readInt();
            cSys[i] = (CoordinateSystem)cache.get(uIndex);
            ++i;
        }
        return cSys;
    }

    public static final int write(BinaryWriter writer, CoordinateSystem cSys, Object token) throws IOException {
        BinaryObjectCache cache = writer.getCoordinateSystemCache();
        int index = cache.getIndex(cSys);
        if (index >= 0) {
            return index;
        }
        index = cache.add(cSys);
        if (index < 0) {
            throw new IOException("Couldn't cache CoordinateSystem " + cSys);
        }
        DataOutput file = writer.getOutput();
        byte[] serialObj = BinarySerializedObject.getBytes(cSys);
        int objLen = BinaryCoordinateSystem.computeBytes(serialObj);
        file.writeByte(1);
        file.writeInt(objLen);
        file.writeInt(index);
        file.writeByte(20);
        file.write(serialObj);
        file.writeByte(80);
        return index;
    }

    public static final int[] writeList(BinaryWriter writer, CoordinateSystem[] cSys, Object token) throws IOException {
        boolean empty = true;
        int i = 0;
        while (i < cSys.length) {
            if (cSys[i] != null) {
                empty = false;
                break;
            }
            ++i;
        }
        if (empty) {
            return null;
        }
        int[] indices = new int[cSys.length];
        int i2 = 0;
        while (i2 < cSys.length) {
            indices[i2] = cSys[i2] == null ? -1 : BinaryCoordinateSystem.write(writer, cSys[i2], token);
            ++i2;
        }
        return indices;
    }
}

