/*
 * Decompiled with CFR 0.152.
 */
package visad.data.units;

import java.io.ByteArrayInputStream;
import visad.Unit;
import visad.data.units.NoSuchUnitException;
import visad.data.units.ParseException;
import visad.data.units.TokenMgrError;
import visad.data.units.UnitParser;

public class Parser {
    protected static final UnitParser unitParser = new UnitParser(System.in);
    protected static final Parser parser = new Parser();

    protected Parser() {
    }

    public static Parser instance() {
        return parser;
    }

    public static synchronized Unit parse(String spec) throws ParseException, NoSuchUnitException {
        unitParser.ReInit(new ByteArrayInputStream(spec.trim().getBytes()));
        try {
            return unitParser.unitSpec();
        }
        catch (TokenMgrError e) {
            throw new ParseException(e.getMessage());
        }
    }

    public static void main(String[] args) throws ParseException {
        String[] specs = new String[]{"m", "2 m s", "3.14 m.s", "1e9 (m)", "(m s)2", "m2.s-1", "m2 s^-1", "(m/s)2", "m2/s-1", "m2/s^-1", ".5 m/(.25 s)2", "m.m-1.m", "2.0 m 1/2 s-1*(m/s^1)^-1 (1e9 m-1)(1e9 s-1)-1.m/s", "g/kg"};
        int i = 0;
        while (i < specs.length) {
            String spec = specs[i];
            System.out.print(spec + ": ");
            System.out.println(Parser.parse(spec));
            ++i;
        }
        try {
            System.out.print("unknown unit: ");
            System.out.println(Parser.parse("unknown unit"));
        }
        catch (ParseException e) {
            System.out.println(e);
        }
    }
}

