/*
 * Decompiled with CFR 0.152.
 */
package visad.data.text;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import visad.Data;
import visad.ErrorEstimate;
import visad.Field;
import visad.FieldException;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Irregular1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearNDSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;
import visad.data.units.Parser;
import visad.jmet.DumpType;

public class TextAdapter {
    private FlatField ff = null;
    private Field field = null;
    private boolean debug = false;
    private String DELIM;
    private final String COMMA = ",";
    private final String SEMICOLON = ";";
    private final String TAB = "\t";
    private final String BLANK = " ";
    String[] hdrNames;
    Unit[] hdrUnits;
    double[] hdrMissingValues;
    String[] hdrMissingStrings;
    int[] hdrIsInterval;
    double[] hdrErrorEstimates;
    double[] rangeErrorEstimates;
    Unit[] rangeUnits;
    double[] domainErrorEstimates;
    Unit[] domainUnits;
    double[] hdrScales;
    double[] hdrOffsets;
    int[][] hdrColumns;
    int[][] values_to_index;

    public TextAdapter(String filename) throws IOException, VisADException {
        FileInputStream is = new FileInputStream(filename);
        this.DELIM = null;
        if (filename.trim().toLowerCase().endsWith(".csv")) {
            this.DELIM = ",";
        }
        if (filename.trim().toLowerCase().endsWith(".tsv")) {
            this.DELIM = "\t";
        }
        if (filename.trim().toLowerCase().endsWith(".bsv")) {
            this.DELIM = " ";
        }
        this.readit(is, null, null);
    }

    public TextAdapter(String filename, String map, String params) throws IOException, VisADException {
        FileInputStream is = new FileInputStream(filename);
        this.DELIM = null;
        if (filename.trim().toLowerCase().endsWith(".csv")) {
            this.DELIM = ",";
        }
        if (filename.trim().toLowerCase().endsWith(".tsv")) {
            this.DELIM = "\t";
        }
        if (filename.trim().toLowerCase().endsWith(".bsv")) {
            this.DELIM = " ";
        }
        this.readit(is, map, params);
    }

    public TextAdapter(URL url) throws IOException, VisADException {
        this.DELIM = null;
        String filename = url.getFile();
        if (filename.trim().toLowerCase().endsWith(".csv")) {
            this.DELIM = ",";
        }
        if (filename.trim().toLowerCase().endsWith(".tsv")) {
            this.DELIM = "\t";
        }
        if (filename.trim().toLowerCase().endsWith(".bsv")) {
            this.DELIM = " ";
        }
        InputStream is = url.openStream();
        this.readit(is, null, null);
    }

    public TextAdapter(URL url, String map, String params) throws IOException, VisADException {
        this.DELIM = null;
        String filename = url.getFile();
        if (filename.trim().toLowerCase().endsWith(".csv")) {
            this.DELIM = ",";
        }
        if (filename.trim().toLowerCase().endsWith(".tsv")) {
            this.DELIM = "\t";
        }
        if (filename.trim().toLowerCase().endsWith(".bsv")) {
            this.DELIM = " ";
        }
        InputStream is = url.openStream();
        this.readit(is, map, null);
    }

    void readit(InputStream is, String map, String params) throws IOException, VisADException {
        BufferedReader bis;
        block160: {
            float[][] samples;
            float[][] a;
            TupleType rngType;
            RealTupleType domType;
            this.ff = null;
            this.field = null;
            bis = new BufferedReader(new InputStreamReader(is));
            String maps = null;
            if (map == null) {
                String t;
                do {
                    if ((t = bis.readLine()) == null) {
                        return;
                    }
                    if (TextAdapter.isText(t)) continue;
                    return;
                } while (t.startsWith("#") || t.startsWith("!") || t.startsWith("%") || t.length() < 1);
                maps = t.trim();
            } else {
                maps = map;
            }
            maps = this.makeMT(maps);
            System.out.println("Specified MathType = " + maps);
            String hdr = null;
            if (params == null) {
                while (true) {
                    if ((hdr = bis.readLine()) == null) {
                        return;
                    }
                    if (!TextAdapter.isText(hdr)) {
                        return;
                    }
                    if (hdr.startsWith("#") || hdr.startsWith("!") || hdr.startsWith("%") || hdr.length() < 1) {
                        continue;
                    }
                    break;
                }
            } else {
                hdr = params;
            }
            String hdrDelim = this.DELIM;
            if (this.DELIM == null) {
                if (hdr.indexOf(" ") != -1) {
                    hdrDelim = " ";
                }
                if (hdr.indexOf(",") != -1) {
                    hdrDelim = ",";
                }
                if (hdr.indexOf(";") != -1) {
                    hdrDelim = ";";
                }
                if (hdr.indexOf("\t") != -1) {
                    hdrDelim = "\t";
                }
                if (this.debug) {
                    System.out.println("Using header delimiter = " + hdrDelim.getBytes()[0]);
                }
            }
            StringTokenizer sthdr = new StringTokenizer(hdr, hdrDelim);
            int nhdr = sthdr.countTokens();
            this.hdrNames = new String[nhdr];
            this.hdrUnits = new Unit[nhdr];
            this.hdrMissingValues = new double[nhdr];
            this.hdrMissingStrings = new String[nhdr];
            this.hdrIsInterval = new int[nhdr];
            this.hdrErrorEstimates = new double[nhdr];
            this.hdrScales = new double[nhdr];
            this.hdrOffsets = new double[nhdr];
            this.hdrColumns = new int[2][nhdr];
            int i = 0;
            while (i < nhdr) {
                String name = sthdr.nextToken().trim();
                String hdrUnitString = null;
                this.hdrMissingValues[i] = Double.NaN;
                this.hdrMissingStrings[i] = null;
                this.hdrIsInterval[i] = 0;
                this.hdrScales[i] = 1.0;
                this.hdrOffsets[i] = 0.0;
                this.hdrErrorEstimates[i] = 0.0;
                this.hdrColumns[0][i] = -1;
                int m = name.indexOf("[");
                if (m == -1) {
                    this.hdrNames[i] = name;
                    hdrUnitString = null;
                } else {
                    int m2 = name.indexOf("]");
                    if (m2 == -1) {
                        throw new VisADException("TextAdapter: Bad [descriptor] named in:" + name);
                    }
                    this.hdrNames[i] = m2 >= name.length() ? name.substring(0, m).trim() : (name.substring(0, m) + name.substring(m2 + 1)).trim();
                    String cl = name.substring(m + 1, m2).trim();
                    StringTokenizer stcl = new StringTokenizer(cl, " ");
                    int ncl = stcl.countTokens();
                    if (ncl == 1 && cl.indexOf("=") == -1) {
                        hdrUnitString = cl;
                    } else {
                        int j = 0;
                        while (j < ncl) {
                            String s = stcl.nextToken().trim();
                            StringTokenizer sts = new StringTokenizer(s, "=");
                            if (sts.countTokens() != 2) {
                                throw new VisADException("TextAdapter: Invalid clause in: " + s);
                            }
                            String tok = sts.nextToken().trim();
                            String val = sts.nextToken().trim();
                            if (tok.toLowerCase().startsWith("unit")) {
                                hdrUnitString = val;
                            } else if (tok.toLowerCase().startsWith("mis")) {
                                this.hdrMissingStrings[i] = val.trim();
                                try {
                                    this.hdrMissingValues[i] = Double.parseDouble(val);
                                }
                                catch (NumberFormatException me) {
                                    this.hdrMissingValues[i] = Double.NaN;
                                }
                            } else if (tok.toLowerCase().startsWith("int")) {
                                this.hdrIsInterval[i] = -1;
                                if (val.toLowerCase().startsWith("t")) {
                                    this.hdrIsInterval[i] = 1;
                                }
                                if (val.toLowerCase().startsWith("f")) {
                                    this.hdrIsInterval[i] = 0;
                                }
                                if (this.hdrIsInterval[i] == -1) {
                                    throw new VisADException("TextAdapter: Value of 'interval' must be 'true' or 'false'");
                                }
                            } else if (tok.toLowerCase().startsWith("err")) {
                                this.hdrErrorEstimates[i] = Double.parseDouble(val);
                            } else if (tok.toLowerCase().startsWith("sca")) {
                                this.hdrScales[i] = Double.parseDouble(val);
                            } else if (tok.toLowerCase().startsWith("off")) {
                                this.hdrOffsets[i] = Double.parseDouble(val);
                            } else if (tok.toLowerCase().startsWith("pos")) {
                                StringTokenizer stp = new StringTokenizer(val, ":");
                                if (stp.countTokens() != 2) {
                                    throw new VisADException("TextAdapter: invalid Position parameter in:" + s);
                                }
                                this.hdrColumns[0][i] = Integer.parseInt(stp.nextToken().trim());
                                this.hdrColumns[1][i] = Integer.parseInt(stp.nextToken().trim());
                            } else {
                                throw new VisADException("Invalid token name: " + s);
                            }
                            ++j;
                        }
                    }
                }
                if (this.debug) {
                    System.out.println("hdr name = " + this.hdrNames[i] + " units=" + hdrUnitString + " miss=" + this.hdrMissingValues[i] + " interval=" + this.hdrIsInterval[i] + " errorest=" + this.hdrErrorEstimates[i] + " scale=" + this.hdrScales[i] + " offset=" + this.hdrOffsets[i] + " pos=" + this.hdrColumns[0][i] + ":" + this.hdrColumns[1][i]);
                }
                Unit u = null;
                if (hdrUnitString != null) {
                    try {
                        u = Parser.parse(hdrUnitString);
                    }
                    catch (Exception ue) {
                        System.out.println("Unit name problem:" + ue + " with: " + hdrUnitString);
                        u = null;
                    }
                }
                RealType rt = RealType.getRealType(this.hdrNames[i], u, null, this.hdrIsInterval[i]);
                this.hdrUnits[i] = u;
                ++i;
            }
            MathType mt = null;
            try {
                mt = MathType.stringToType(maps);
                System.out.println("from: " + maps + " made MathType: " + mt);
            }
            catch (Exception mte) {
                throw new VisADException("TextAdapter: MathType badly formed or missing: " + maps);
            }
            if (this.debug) {
                System.out.println(mt);
                new DumpType();
                DumpType.dumpMathType(mt, System.out);
            }
            String[] domainNames = null;
            String[] rangeNames = null;
            int numDom = 0;
            int numRng = 0;
            if (mt instanceof FunctionType) {
                domType = ((FunctionType)mt).getDomain();
                numDom = domType.getDimension();
                domainNames = new String[numDom];
                int i2 = 0;
                while (i2 < numDom) {
                    MathType comp = domType.getComponent(i2);
                    domainNames[i2] = ((RealType)comp).toString().trim();
                    if (this.debug) {
                        System.out.println("dom " + i2 + " = " + domainNames[i2]);
                    }
                    ++i2;
                }
                rngType = (TupleType)((FunctionType)mt).getRange();
                numRng = rngType.getDimension();
                rangeNames = new String[numRng];
                int i3 = 0;
                while (i3 < numRng) {
                    MathType comp = rngType.getComponent(i3);
                    rangeNames[i3] = comp.toString().trim();
                    if (this.debug) {
                        System.out.println("range " + i3 + " = " + rangeNames[i3]);
                    }
                    ++i3;
                }
            } else {
                throw new VisADException("TextAdapter: Math Type is not a simple FunctionType");
            }
            int[] domainPointer = new int[numDom];
            double[][] domainRanges = new double[3][numDom];
            boolean[] gotDomainRanges = new boolean[numDom];
            this.domainErrorEstimates = new double[numDom];
            this.domainUnits = new Unit[numDom];
            this.rangeErrorEstimates = new double[numRng];
            this.rangeUnits = new Unit[numRng];
            int countDomain = 0;
            int i4 = 0;
            while (i4 < numDom) {
                domainPointer[i4] = -1;
                gotDomainRanges[i4] = false;
                this.domainErrorEstimates[i4] = Double.NaN;
                this.domainUnits[i4] = null;
                ++i4;
            }
            int[] rangePointer = new int[numRng];
            int countRange = 0;
            int i5 = 0;
            while (i5 < numRng) {
                rangePointer[i5] = -1;
                this.rangeErrorEstimates[i5] = Double.NaN;
                this.rangeUnits[i5] = null;
                ++i5;
            }
            int countValues = -1;
            this.values_to_index = new int[3][nhdr];
            int i6 = 0;
            while (i6 < nhdr) {
                this.values_to_index[0][i6] = -1;
                this.values_to_index[1][i6] = -1;
                this.values_to_index[2][i6] = -1;
                ++countValues;
                String name = this.hdrNames[i6];
                boolean gotName = false;
                String test_name = name;
                int n = test_name.indexOf("(");
                if (n != -1 && test_name.indexOf("(Text)") == -1) {
                    test_name = name.substring(0, n).trim();
                    --countValues;
                    --countDomain;
                }
                int k = 0;
                while (k < numDom) {
                    if (test_name.equals(domainNames[k])) {
                        domainPointer[k] = countValues;
                        this.domainErrorEstimates[k] = this.hdrErrorEstimates[i6];
                        this.domainUnits[k] = this.hdrUnits[i6];
                        gotName = true;
                        ++countDomain;
                        if (n != -1) {
                            try {
                                String ss = name.substring(n + 1, name.length() - 1);
                                StringTokenizer sct = new StringTokenizer(ss, ":");
                                String first = sct.nextToken().trim();
                                String second = sct.nextToken().trim();
                                String third = "1";
                                if (sct.hasMoreTokens()) {
                                    third = sct.nextToken().trim();
                                }
                                domainRanges[0][k] = Double.parseDouble(first);
                                domainRanges[1][k] = Double.parseDouble(second);
                                domainRanges[2][k] = Double.parseDouble(third);
                                gotDomainRanges[k] = true;
                                break;
                            }
                            catch (Exception ef) {
                                throw new VisADException("TextAdapter: Error while interpreting min:max values for domain " + name);
                            }
                        }
                        if (countValues <= -1) break;
                        this.values_to_index[0][countValues] = k;
                        this.values_to_index[2][countValues] = i6;
                        break;
                    }
                    ++k;
                }
                if (!gotName) {
                    int k2 = 0;
                    while (k2 < numRng) {
                        if (name.equals(rangeNames[k2])) {
                            rangePointer[k2] = countValues;
                            this.rangeErrorEstimates[k2] = this.hdrErrorEstimates[i6];
                            this.rangeUnits[k2] = this.hdrUnits[i6];
                            ++countRange;
                            this.values_to_index[1][countValues] = k2;
                            this.values_to_index[2][countValues] = i6;
                            gotName = true;
                        }
                        ++k2;
                    }
                }
                ++i6;
            }
            if (this.debug) {
                System.out.println("countDom/numDom=" + countDomain + " " + numDom);
                System.out.println("countRange/numRng=" + countRange + " " + numRng);
                System.out.println("Domain info:");
                int i7 = 0;
                while (i7 < numDom) {
                    System.out.println("Dom name / index = " + domainNames[i7] + "  " + domainPointer[i7]);
                    if (gotDomainRanges[i7]) {
                        System.out.println("    ..." + domainRanges[0][i7] + "  " + domainRanges[1][i7] + "    " + domainRanges[2][i7]);
                    }
                    ++i7;
                }
                System.out.println("Range info:");
                int i8 = 0;
                while (i8 < numRng) {
                    System.out.println("Rng name / index / error est = " + rangeNames[i8] + "  " + rangePointer[i8] + "  " + this.rangeErrorEstimates[i8] + " " + this.rangeUnits[i8]);
                    ++i8;
                }
                System.out.println("values_to_index pointers = ");
                int i9 = 0;
                while (i9 < nhdr) {
                    System.out.println(" inx / value = " + i9 + " " + this.values_to_index[0][i9] + "    " + this.values_to_index[1][i9] + " " + this.values_to_index[2][i9]);
                    ++i9;
                }
            }
            ArrayList<double[]> domainValues = new ArrayList<double[]>();
            ArrayList<double[]> rangeValues = new ArrayList<double[]>();
            ArrayList<Tuple> tupleValues = new ArrayList<Tuple>();
            Tuple tuple = null;
            String dataDelim = this.DELIM;
            boolean isRaster = false;
            int numElements = 1;
            if (countRange == 1 && numRng == 1 && numDom == 2 && countDomain < 2) {
                isRaster = true;
            }
            while (true) {
                String sa;
                int i10;
                StringTokenizer st;
                int n;
                String s = bis.readLine();
                if (this.debug) {
                    System.out.println("read:" + s);
                }
                if (s == null) break;
                if (!TextAdapter.isText(s)) {
                    return;
                }
                if (s.startsWith("#") || s.startsWith("!") || s.startsWith("%") || s.length() < 1) continue;
                if (dataDelim == null) {
                    if (s.indexOf(" ") != -1) {
                        dataDelim = " ";
                    }
                    if (s.indexOf(",") != -1) {
                        dataDelim = ",";
                    }
                    if (s.indexOf(";") != -1) {
                        dataDelim = ";";
                    }
                    if (s.indexOf("\t") != -1) {
                        dataDelim = "\t";
                    }
                    if (this.debug) {
                        System.out.println("Using data delimiter = " + dataDelim.getBytes()[0]);
                    }
                }
                if ((n = (st = new StringTokenizer(s, dataDelim)).countTokens()) < 1) continue;
                double[] dValues = new double[numDom];
                double[] rValues = null;
                Data[] tValues = null;
                if (isRaster) {
                    if (this.debug) {
                        System.out.println("probably a raster...");
                    }
                    boolean gotFirst = false;
                    int rvaluePointer = 0;
                    int irange = 0;
                    i10 = 0;
                    while (i10 < n) {
                        sa = st.nextToken().trim();
                        if (i10 >= nhdr) {
                            if (!gotFirst) {
                                throw new VisADException("TextAdapter: Cannot find first raster value");
                            }
                            rValues[++rvaluePointer] = this.getVal(sa, irange);
                        } else {
                            if (this.values_to_index[0][i10] != -1) {
                                dValues[this.values_to_index[0][i10]] = this.getVal(sa, i10);
                            }
                            if (gotFirst) {
                                rValues[++rvaluePointer] = this.getVal(sa, irange);
                            } else if (this.values_to_index[1][i10] != -1) {
                                rValues = new double[n - i10];
                                irange = i10;
                                rValues[rvaluePointer] = this.getVal(sa, irange);
                                gotFirst = true;
                            }
                        }
                        ++i10;
                    }
                } else {
                    tValues = new Data[numRng];
                    if (this.debug) {
                        System.out.println("probably not a raster...");
                    }
                    rValues = new double[numRng];
                    if (n > nhdr) {
                        n = nhdr;
                    }
                    i10 = 0;
                    while (i10 < n) {
                        sa = st.nextToken().trim();
                        if (this.values_to_index[0][i10] != -1) {
                            dValues[this.values_to_index[0][i10]] = this.getVal(sa, i10);
                        } else if (this.values_to_index[1][i10] != -1) {
                            MathType thisMT = rngType.getComponent(this.values_to_index[1][i10]);
                            if (sa.startsWith("\"")) {
                                StringTokenizer stText = new StringTokenizer(sa, "\"");
                                String sThisText = stText.countTokens() == 0 ? "" : stText.nextToken().trim();
                                try {
                                    tValues[this.values_to_index[1][i10]] = new Text((TextType)thisMT, sThisText);
                                    if (this.debug) {
                                        System.out.println("tValues[" + this.values_to_index[1][i10] + "] = " + tValues[this.values_to_index[1][i10]]);
                                    }
                                }
                                catch (Exception e) {
                                    System.out.println(" Exception converting " + thisMT + " to TextType " + e);
                                }
                            } else {
                                rValues[this.values_to_index[1][i10]] = this.getVal(sa, i10);
                                try {
                                    tValues[this.values_to_index[1][i10]] = new Real((RealType)thisMT, this.getVal(sa, i10));
                                    if (this.debug) {
                                        System.out.println("tValues[" + this.values_to_index[1][i10] + "] = " + tValues[this.values_to_index[1][i10]]);
                                    }
                                }
                                catch (Exception e) {
                                    System.out.println(" Exception converting " + thisMT + " " + e);
                                }
                            }
                        }
                        ++i10;
                    }
                }
                try {
                    if (tValues != null) {
                        tuple = new Tuple(tValues);
                    }
                }
                catch (TypeException te) {
                    tuple = null;
                }
                domainValues.add(dValues);
                rangeValues.add(rValues);
                if (tuple != null) {
                    tupleValues.add(tuple);
                }
                if (!isRaster) continue;
                numElements = rValues.length;
            }
            int numSamples = rangeValues.size();
            if (this.debug) {
                try {
                    System.out.println("domain size = " + domainValues.size());
                    double[] dt = (double[])domainValues.get(1);
                    System.out.println("domain.array[0] = " + dt[0]);
                    System.out.println("range size = " + rangeValues.size());
                    System.out.println("# samples = " + numSamples);
                }
                catch (Exception er) {
                    System.out.println("out range");
                }
            }
            Linear1DSet[] lset = new Linear1DSet[numDom];
            int numVal = numRng;
            if (numDom == 1) {
                numVal = numSamples;
            }
            if (numDom == 2 && numRng == 1 && numElements > 1) {
                numVal = numElements;
            }
            int i11 = 0;
            while (i11 < numDom) {
                if (gotDomainRanges[i11]) {
                    lset[i11] = new Linear1DSet(domainRanges[0][i11], domainRanges[1][i11], numVal);
                    if (this.debug) {
                        System.out.println("lset from domain = " + lset[i11]);
                    }
                } else if (domainPointer[i11] == -1) {
                    lset[i11] = new Linear1DSet(0.0, numVal - 1, numVal);
                    if (this.debug) {
                        System.out.println("lset from range = " + lset[i11]);
                    }
                } else {
                    lset[i11] = null;
                }
                numVal = numSamples;
                ++i11;
            }
            SampledSet domain = null;
            if (numDom == 1) {
                if (lset[0] == null) {
                    a = this.getDomSamples(0, numSamples, domainValues);
                    domain = new Irregular1DSet((MathType)domType, a);
                } else {
                    domain = lset[0];
                }
            } else if (numDom == 2) {
                if (lset[0] != null && lset[1] != null) {
                    domain = new Linear2DSet((MathType)domType, lset);
                } else {
                    samples = new float[2][numSamples];
                    samples[0] = lset[0] == null ? this.getDomSamples(0, numSamples, domainValues)[0] : lset[0].getSamples()[0];
                    samples[1] = lset[1] == null ? this.getDomSamples(1, numSamples, domainValues)[0] : lset[1].getSamples()[0];
                    domain = new Irregular2DSet((MathType)domType, samples);
                }
            } else if (numDom == 3) {
                if (lset[0] != null && lset[1] != null && lset[2] != null) {
                    domain = new Linear3DSet((MathType)domType, lset);
                } else {
                    samples = new float[3][numSamples];
                    samples[0] = lset[0] == null ? this.getDomSamples(0, numSamples, domainValues)[0] : lset[0].getSamples()[0];
                    samples[1] = lset[1] == null ? this.getDomSamples(1, numSamples, domainValues)[0] : lset[1].getSamples()[0];
                    samples[2] = lset[2] == null ? this.getDomSamples(2, numSamples, domainValues)[0] : lset[2].getSamples()[0];
                    domain = new Irregular3DSet((MathType)domType, samples);
                }
            } else {
                domain = new LinearNDSet((MathType)domType, lset);
            }
            try {
                this.ff = new FlatField((FunctionType)mt, domain);
            }
            catch (FieldException fe) {
                this.field = new FieldImpl((FunctionType)mt, domain);
            }
            if (this.debug) {
                if (this.ff != null) {
                    System.out.println("ff.Length " + this.ff.getLength());
                    System.out.println("ff.getType " + this.ff.getType());
                }
                if (this.field != null) {
                    System.out.println("field.Length " + this.field.getLength());
                    System.out.println("field.getType " + this.field.getType());
                }
                System.out.println("domain = " + domain);
                System.out.println("size of a = " + numRng + " x " + numSamples * numElements);
            }
            a = new float[numRng][numSamples * numElements];
            Data[] at = new Tuple[numSamples];
            if (isRaster) {
                int samPointer = 0;
                int i12 = 0;
                while (i12 < numSamples) {
                    double[] rs = (double[])rangeValues.get(i12);
                    int j = 0;
                    while (j < numElements) {
                        a[0][samPointer] = (float)rs[j];
                        ++samPointer;
                        ++j;
                    }
                    ++i12;
                }
            } else {
                int i13 = 0;
                while (i13 < numSamples) {
                    double[] rs = (double[])rangeValues.get(i13);
                    int j = 0;
                    while (j < numRng) {
                        a[j][i13] = (float)rs[j];
                        ++j;
                    }
                    if (!tupleValues.isEmpty()) {
                        at[i13] = (Tuple)tupleValues.get(i13);
                    }
                    ++i13;
                }
            }
            if (this.debug) {
                System.out.println("about to field.setSamples");
            }
            if (this.ff != null) {
                this.ff.setSamples(a);
                this.field = this.ff;
            } else {
                this.field.setSamples(at, false);
            }
            ErrorEstimate[] es = new ErrorEstimate[numRng];
            int i14 = 0;
            while (i14 < numRng) {
                es[i14] = new ErrorEstimate(a[i14], this.rangeErrorEstimates[i14], this.rangeUnits[i14]);
                ++i14;
            }
            try {
                ((FlatField)this.field).setRangeErrors(es);
            }
            catch (FieldException fe) {
                if (this.debug) {
                    System.out.println("caught " + fe);
                }
            }
            catch (ClassCastException cce) {
                if (!this.debug) break block160;
                System.out.println("caught " + cce);
            }
        }
        if (this.debug) {
            new DumpType();
            DumpType.dumpDataType(this.field, System.out);
            System.out.println("field = " + this.field);
        }
        bis.close();
    }

    private String makeMT(String s) {
        String t2;
        String t = "";
        int i = 0;
        while (i < s.length()) {
            String r = s.substring(i, i + 1);
            if (!(r.equals(" ") || r.equals("\t") || r.equals("\n"))) {
                t = t + r;
            }
            ++i;
        }
        int k = t.indexOf("->");
        if (k < 0) {
            System.out.println("Invalid MathType form: -> required:" + k);
            return null;
        }
        if (t.charAt(k - 1) != ')') {
            t = t2 = "(" + t.substring(0, k) + ")->(" + t.substring(k + 2) + ")";
        } else if (t.charAt(k + 2) != '(') {
            t = t2 = t.substring(0, k + 2) + "(" + t.substring(k + 2) + ")";
        }
        if (!t.startsWith("((")) {
            t = t2 = "(" + t + ")";
        }
        return t;
    }

    private static final boolean isText(String s) {
        int len;
        int n = len = s == null ? -1 : s.length();
        if (len <= 0) {
            return true;
        }
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            if (Character.isISOControl(ch) && !Character.isWhitespace(ch)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    double getVal(String s, int k) {
        int i = this.values_to_index[2][k];
        if (i < 0 || s == null || s.length() < 1 || s.equals(this.hdrMissingStrings[i])) {
            return Double.NaN;
        }
        try {
            double v = Double.parseDouble(s);
            if (v == this.hdrMissingValues[i]) {
                return Double.NaN;
            }
            v = v * this.hdrScales[i] + this.hdrOffsets[i];
            return v;
        }
        catch (NumberFormatException ne) {
            System.out.println("Invalid number format for " + s);
            return Double.NaN;
        }
    }

    float[][] getDomSamples(int comp, int numDomValues, ArrayList domValues) {
        float[][] a = new float[1][numDomValues];
        int i = 0;
        while (i < numDomValues) {
            double[] d = (double[])domValues.get(i);
            a[0][i] = (float)d[comp];
            ++i;
        }
        return a;
    }

    public Field getData() {
        return this.field;
    }
}

