/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.in;

import java.io.IOException;
import java.lang.reflect.Array;
import java.rmi.RemoteException;
import ucar.netcdf.Variable;
import visad.DataImpl;
import visad.MathType;
import visad.ScalarType;
import visad.SimpleSet;
import visad.Unit;
import visad.VisADException;
import visad.data.netcdf.in.Context;
import visad.data.netcdf.in.DataFactory;
import visad.data.netcdf.in.InvalidContextException;
import visad.data.netcdf.in.Vetter;
import visad.data.netcdf.in.VirtualData;

public class VirtualScalar
extends VirtualData {
    private DataFactory dataFactory = DataFactory.instance();
    private ScalarType type;
    private final Variable var;
    private SimpleSet rangeSet;
    private final Unit unit;
    private final Vetter vetter;
    private final int[] lengths;

    public VirtualScalar(ScalarType type, Variable var, SimpleSet rangeSet, Unit unit, Vetter vetter) {
        this.type = type;
        this.var = var;
        this.rangeSet = rangeSet;
        this.unit = unit;
        this.vetter = vetter;
        this.lengths = var.getLengths();
    }

    public ScalarType getScalarType() {
        return this.type;
    }

    public MathType getType() {
        return this.getScalarType();
    }

    public SimpleSet getRangeSet() {
        return this.rangeSet;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Variable getVariable() {
        return this.var;
    }

    public Vetter getVetter() {
        return this.vetter;
    }

    public DataImpl getData(Context context) throws InvalidContextException, VisADException, RemoteException, IOException {
        return this.getDataFactory().newData(context, this);
    }

    public double[] getDoubles(Context context) throws IOException, VisADException {
        int rank = this.lengths.length;
        int[] ioOrigin = new int[rank];
        int[] ioShape = new int[rank];
        int[] ioContext = context.getContext();
        System.arraycopy(ioContext, 0, ioOrigin, 0, ioContext.length);
        int i = 0;
        while (i < ioContext.length) {
            ioShape[i] = 1;
            ++i;
        }
        int total = 1;
        int i2 = ioContext.length;
        while (i2 < rank) {
            ioOrigin[i2] = 0;
            ioShape[i2] = this.lengths[i2];
            total *= this.lengths[i2];
            ++i2;
        }
        double[] values = new double[total];
        VirtualScalar.toArray(this.var, values, ioOrigin, ioShape);
        this.vetter.vet(values);
        return values;
    }

    static Object toArray(Variable var, double[] values, int[] origin, int[] shape) throws IOException {
        block6: {
            Object dst;
            Class fromClass;
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block5: {
                                if (var.getRank() != 0) break block5;
                                values[0] = var.getDouble(new int[0]);
                                break block6;
                            }
                            fromClass = var.getComponentType();
                            if (!fromClass.equals(Double.TYPE)) break block7;
                            var.toArray(values, origin, shape);
                            break block6;
                        }
                        int length = 1;
                        int i = 0;
                        while (i < shape.length) {
                            length *= shape[i];
                            ++i;
                        }
                        dst = Array.newInstance(fromClass, length);
                        var.toArray(dst, origin, shape);
                        if (!fromClass.equals(Byte.TYPE)) break block8;
                        byte[] fromArray = (byte[])dst;
                        int i2 = 0;
                        while (i2 < fromArray.length) {
                            values[i2] = fromArray[i2];
                            ++i2;
                        }
                        break block6;
                    }
                    if (!fromClass.equals(Short.TYPE)) break block9;
                    short[] fromArray = (short[])dst;
                    int i = 0;
                    while (i < fromArray.length) {
                        values[i] = fromArray[i];
                        ++i;
                    }
                    break block6;
                }
                if (!fromClass.equals(Integer.TYPE)) break block10;
                int[] fromArray = (int[])dst;
                int i = 0;
                while (i < fromArray.length) {
                    values[i] = fromArray[i];
                    ++i;
                }
                break block6;
            }
            if (!fromClass.equals(Float.TYPE)) break block6;
            float[] fromArray = (float[])dst;
            int i = 0;
            while (i < fromArray.length) {
                values[i] = fromArray[i];
                ++i;
            }
        }
        return values;
    }

    public Object clone() {
        return new VirtualScalar(this.type, this.var, this.rangeSet, this.unit, this.vetter);
    }

    public void setDataFactory(DataFactory factory) {
        this.dataFactory = factory;
    }

    public DataFactory getDataFactory() {
        return this.dataFactory;
    }
}

