/*
 * Decompiled with CFR 0.152.
 */
package visad.data.mcidas;

import edu.wisc.ssec.mcidas.GridDirectory;
import edu.wisc.ssec.mcidas.McIDASException;
import edu.wisc.ssec.mcidas.McIDASUtil;
import visad.CoordinateSystem;
import visad.VisADException;
import visad.data.mcidas.GRIDCoordinateSystem;
import visad.data.units.ParseException;
import visad.data.units.Parser;
import visad.jmet.MetGridDirectory;
import visad.jmet.MetUnits;

public class McIDASGridDirectory
extends MetGridDirectory {
    CoordinateSystem coordSystem = null;
    GridDirectory directory = null;
    private double paramScale;

    public McIDASGridDirectory(GridDirectory directory) {
        this.directory = directory;
        if (directory != null) {
            this.setParameters();
        }
    }

    public McIDASGridDirectory(byte[] h) {
        int[] dirblock = new int[64];
        int i = 0;
        while (i < 64) {
            dirblock[i] = McIDASUtil.bytesToInteger(h, i * 4);
            ++i;
        }
        try {
            this.directory = new GridDirectory(dirblock);
        }
        catch (McIDASException excp) {
            this.directory = null;
        }
        if (this.directory != null) {
            this.setParameters();
        }
    }

    private void setParameters() {
        this.paramName = this.directory.getParamName();
        this.rows = this.directory.getRows();
        this.columns = this.directory.getColumns();
        this.levels = 1;
        this.validHour = this.directory.getForecastHour();
        this.referenceTime = this.directory.getReferenceTime();
        this.validTime = this.directory.getValidTime();
        this.levelValue = this.directory.getLevelValue();
        try {
            MetUnits mu = new MetUnits();
            String su = this.directory.getParamUnitName();
            String sl = this.directory.getLevelUnitName();
            try {
                this.paramUnit = Parser.parse(mu.makeSymbol(su));
            }
            catch (ParseException pe) {
                this.paramUnit = null;
            }
            try {
                this.levelUnit = Parser.parse(mu.makeSymbol(sl));
            }
            catch (ParseException pe) {
                this.levelUnit = null;
            }
        }
        catch (VisADException e) {
            System.out.println(e);
        }
        this.secondLevelValue = this.directory.getSecondLevelValue();
        this.secondTime = this.directory.getSecondTime();
        this.paramScale = this.directory.getParamScale();
    }

    public double getParamScale() {
        return this.paramScale;
    }

    public CoordinateSystem getCoordinateSystem() {
        if (this.coordSystem == null) {
            try {
                if (this.directory == null) {
                    throw new Exception("null directory");
                }
                this.coordSystem = new GRIDCoordinateSystem(this.directory);
            }
            catch (Exception ev) {
                this.coordSystem = null;
                System.out.println("No navigation available");
            }
        }
        return this.coordSystem;
    }

    public int[] getNavBlock() {
        return this.directory != null ? this.directory.getNavBlock() : null;
    }

    public int getGridType() {
        return this.directory != null ? this.directory.getNavType() : -1;
    }

    public GridDirectory getGridDirectory() {
        return this.directory;
    }

    public String toString() {
        return new String(this.paramName + " " + this.paramUnit + " " + this.rows + " " + this.columns + " " + this.levelValue + " " + this.levelUnit + " " + this.referenceTime.toGMTString() + " " + (int)this.validHour + " or " + this.validTime.toGMTString());
    }
}

