/*
 * Decompiled with CFR 0.152.
 */
package visad.data.mcidas;

import edu.wisc.ssec.mcidas.GRIDnav;
import edu.wisc.ssec.mcidas.GridDirectory;
import edu.wisc.ssec.mcidas.McIDASException;
import java.awt.geom.Rectangle2D;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.MapProjection;

public class GRIDCoordinateSystem
extends MapProjection {
    private GRIDnav gnav = null;
    private int rows;
    private int columns;
    private int[] dirBlock;
    private static Unit[] coordinate_system_units = new Unit[]{null, null};

    public GRIDCoordinateSystem(GridDirectory gridDirectory) throws VisADException {
        this(gridDirectory.getDirBlock());
    }

    public GRIDCoordinateSystem(int[] dirBlock) throws VisADException {
        super(RealTupleType.LatitudeLongitudeTuple, coordinate_system_units);
        this.rows = dirBlock[1];
        this.columns = dirBlock[2];
        try {
            this.gnav = new GRIDnav(dirBlock);
            this.gnav.setStart(0, 0);
            this.gnav.setFlipRowCoordinates(this.rows);
        }
        catch (McIDASException excp) {
            throw new VisADException("Grid cannot be navigated");
        }
        this.dirBlock = dirBlock;
    }

    public double[][] toReference(double[][] rowcol) throws VisADException {
        if (rowcol == null || rowcol.length != 2) {
            throw new CoordinateSystemException("GRIDCoordinateSystem.toReference: tuples wrong dimension");
        }
        if (this.gnav == null) {
            throw new CoordinateSystemException("GRID navigation data not available");
        }
        return this.gnav.toLatLon(rowcol);
    }

    public double[][] fromReference(double[][] latlon) throws VisADException {
        if (latlon == null || latlon.length != 2) {
            throw new CoordinateSystemException("GRIDCoordinateSystem.fromReference: tuples wrong dimension");
        }
        if (this.gnav == null) {
            throw new CoordinateSystemException("GRID navigation data not available");
        }
        return this.gnav.toRowCol(latlon);
    }

    public Rectangle2D getDefaultMapArea() {
        return new Rectangle2D.Double(0.0, 0.0, this.columns - 1, this.rows - 1);
    }

    public int[] getDirBlock() {
        return this.dirBlock;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GRIDCoordinateSystem)) {
            return false;
        }
        GRIDCoordinateSystem that = (GRIDCoordinateSystem)obj;
        return this == that || this.gnav.equals(that.gnav) && this.rows == that.rows && this.columns == that.columns;
    }
}

