/*
 * Decompiled with CFR 0.152.
 */
package visad.data.mcidas;

import edu.wisc.ssec.mcidas.AreaDirectory;
import edu.wisc.ssec.mcidas.AreaFile;
import edu.wisc.ssec.mcidas.McIDASException;
import java.io.IOException;
import java.rmi.RemoteException;
import visad.CoordinateSystem;
import visad.DateTime;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.data.mcidas.AREACoordinateSystem;
import visad.meteorology.NavigatedImage;
import visad.meteorology.SingleBandedImage;
import visad.meteorology.SingleBandedImageImpl;

public class AreaAdapter {
    private FlatField field = null;
    private AREACoordinateSystem cs;
    private AreaDirectory areaDirectory;

    public AreaAdapter(String imageSource) throws IOException, VisADException {
        this(imageSource, 0, 0, 0, 0, 0);
    }

    public AreaAdapter(String imageSource, int startLine, int startEle, int numLines, int numEles) throws IOException, VisADException {
        this(imageSource, startLine, startEle, numLines, numEles, 0);
    }

    public AreaAdapter(String imageSource, int startLine, int startEle, int numLines, int numEles, int band) throws IOException, VisADException {
        try {
            AreaFile af = new AreaFile(imageSource);
            this.buildFlatField(af, startLine, startEle, numLines, numEles, band);
        }
        catch (McIDASException afe) {
            throw new VisADException("Problem with McIDAS AREA file: " + afe);
        }
    }

    private void buildFlatField(AreaFile af, int startLine, int startEle, int numLines, int numEles, int band) throws VisADException {
        int[][][] int_samples;
        int i;
        int[] nav = null;
        try {
            this.areaDirectory = af.getAreaDirectory();
            nav = af.getNav();
        }
        catch (Exception rmd) {
            throw new VisADException("Problem getting Area file directory or navigation");
        }
        int nLines = numLines == 0 ? this.areaDirectory.getLines() : numLines;
        int nEles = numEles == 0 ? this.areaDirectory.getElements() : numEles;
        RealType line = RealType.getRealType("ImageLine", null, null);
        RealType element = RealType.getRealType("ImageElement", null, null);
        int[] bandNums = this.areaDirectory.getBands();
        int numBands = bandNums.length;
        int[] bandIndices = new int[numBands];
        if (band != 0) {
            bandIndices[0] = -1;
            i = 0;
            while (i < numBands) {
                if (band == bandNums[i]) {
                    bandIndices[0] = i;
                    break;
                }
                ++i;
            }
            if (bandIndices[0] == -1) {
                throw new VisADException("requested band number not in image");
            }
            bandNums = new int[]{band};
            numBands = 1;
        } else {
            i = 0;
            while (i < numBands) {
                bandIndices[i] = i;
                ++i;
            }
        }
        RealType[] bands = new RealType[numBands];
        int i2 = 0;
        while (i2 < numBands) {
            bands[i2] = RealType.getRealType("Band" + bandNums[i2]);
            ++i2;
        }
        RealTupleType radiance = new RealTupleType(bands);
        RealType[] domain_components = new RealType[]{element, line};
        try {
            int[] dirBlock = (int[])this.areaDirectory.getDirectoryBlock().clone();
            dirBlock[5] = dirBlock[5] + startLine * dirBlock[11];
            dirBlock[6] = dirBlock[6] + startEle * dirBlock[12];
            dirBlock[8] = nLines;
            dirBlock[9] = nEles;
            this.cs = new AREACoordinateSystem(dirBlock, nav);
        }
        catch (VisADException e) {
            System.out.println(e);
            System.out.println("Using null CoordinateSystem");
            this.cs = null;
        }
        RealTupleType image_domain = new RealTupleType(domain_components, (CoordinateSystem)this.cs, null);
        Linear2DSet domain_set = new Linear2DSet((MathType)image_domain, 0.0, (double)(nEles - 1), nEles, nLines - 1, 0.0, nLines);
        FunctionType image_type = new FunctionType(image_domain, radiance);
        if (this.areaDirectory.getCalibrationType().equalsIgnoreCase("BRIT")) {
            Set[] rangeSets = new Set[numBands];
            int i3 = 0;
            while (i3 < numBands) {
                rangeSets[i3] = new Integer1DSet((MathType)bands[i3], 255);
                ++i3;
            }
            this.field = new FlatField(image_type, (Set)domain_set, (CoordinateSystem[])null, rangeSets, (Unit[])null);
        } else {
            this.field = new FlatField(image_type, domain_set);
        }
        try {
            int_samples = af.getData();
        }
        catch (McIDASException samp) {
            throw new VisADException("Problem reading AREA file: " + samp);
        }
        try {
            float[][] samples = new float[numBands][nEles * nLines];
            if (this.areaDirectory.getCalibrationType().equalsIgnoreCase("BRIT")) {
                int b = 0;
                while (b < numBands) {
                    int i4 = 0;
                    while (i4 < nLines) {
                        int j = 0;
                        while (j < nEles) {
                            int val = int_samples[bandIndices[b]][startLine + i4][startEle + j];
                            samples[b][j + nEles * i4] = val == 255 ? 254.0f : (float)val;
                            ++j;
                        }
                        ++i4;
                    }
                    ++b;
                }
            } else {
                int b = 0;
                while (b < numBands) {
                    int i5 = 0;
                    while (i5 < nLines) {
                        int j = 0;
                        while (j < nEles) {
                            samples[b][j + nEles * i5] = int_samples[bandIndices[b]][startLine + i5][startEle + j];
                            ++j;
                        }
                        ++i5;
                    }
                    ++b;
                }
            }
            this.field.setSamples(samples, false);
        }
        catch (RemoteException e) {
            throw new VisADException("Couldn't finish image initialization");
        }
    }

    public int[] getDimensions() {
        int[] dim = new int[]{this.areaDirectory.getNumberOfBands(), this.areaDirectory.getElements(), this.areaDirectory.getLines()};
        return dim;
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.cs;
    }

    public AreaDirectory getAreaDirectory() {
        return this.areaDirectory;
    }

    public FlatField getData() {
        if (this.field.getRangeDimension() == 1) {
            try {
                return (FlatField)((Object)this.getImage());
            }
            catch (VisADException ve) {
                ve.printStackTrace();
            }
        }
        return this.field;
    }

    public DateTime getNominalTime() throws VisADException {
        return new DateTime(this.areaDirectory.getNominalTime());
    }

    public DateTime getImageStartTime() throws VisADException {
        return new DateTime(this.areaDirectory.getStartTime());
    }

    public SingleBandedImage getImage() throws VisADException {
        FlatField firstBand;
        if (this.field.getRangeDimension() > 1) {
            try {
                firstBand = (FlatField)this.field.extract(0);
            }
            catch (RemoteException excp) {
                throw new VisADException("AreaAdapter.getImage(): RemoteException");
            }
        } else {
            firstBand = this.field;
        }
        return this.cs == null ? new SingleBandedImageImpl(firstBand, this.getNominalTime(), "McIDAS Image") : new NavigatedImage(firstBand, this.getNominalTime(), "McIDAS Image");
    }
}

