/*
 * Decompiled with CFR 0.152.
 */
package visad.data.amanda;

import java.awt.Component;
import java.rmi.RemoteException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import visad.ControlEvent;
import visad.ControlListener;
import visad.PlotText;
import visad.ScalarMap;
import visad.ValueControl;
import visad.VisADException;
import visad.data.amanda.BaseTrack;
import visad.data.amanda.Event;
import visad.util.VisADSlider;

public class TrackWidget
extends JPanel
implements ControlListener {
    private Event event;
    private int trackIndex;
    private JLabel lengthLabel;
    private JLabel energyLabel;

    public TrackWidget(ScalarMap map) throws RemoteException, VisADException {
        ValueControl ctl = (ValueControl)((Object)map.getControl());
        ctl.addControlListener(this);
        this.event = null;
        this.trackIndex = (int)ctl.getValue();
        this.setLayout(new BoxLayout(this, 1));
        Component labels = this.buildLabels();
        VisADSlider trackSlider = new VisADSlider(map, true, true);
        trackSlider.hardcodeSizePercent(110);
        this.add(trackSlider);
        this.add(labels);
    }

    public Component buildLabels() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.lengthLabel = new JLabel("WWWWWW.WWWW");
        this.lengthLabel.setMinimumSize(this.lengthLabel.getSize());
        this.energyLabel = new JLabel("WWWWWW.WWWW");
        this.energyLabel.setMinimumSize(this.energyLabel.getSize());
        panel.add(Box.createHorizontalGlue());
        panel.add(new JLabel("Length: "));
        panel.add(this.lengthLabel);
        panel.add(Box.createHorizontalGlue());
        panel.add(new JLabel("  Energy: "));
        panel.add(this.energyLabel);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    public void controlChanged(ControlEvent evt) {
        ValueControl ctl = (ValueControl)((Object)evt.getControl());
        this.trackIndex = (int)ctl.getValue();
        if (this.event == null) {
            this.trackChanged(null);
        } else {
            this.trackChanged(this.event.getTrack(this.trackIndex));
        }
    }

    private static final String floatString(float val) {
        if (val == Float.POSITIVE_INFINITY) {
            return "inf";
        }
        if (val == Float.NEGATIVE_INFINITY) {
            return "-inf";
        }
        if (val == Float.NaN) {
            return "?";
        }
        return PlotText.shortString(val);
    }

    public void setEvent(Event evt) {
        this.event = evt;
        if (this.event == null) {
            this.trackChanged(null);
        } else {
            this.trackChanged(this.event.getTrack(this.trackIndex));
        }
    }

    private void trackChanged(BaseTrack track) {
        if (track == null) {
            this.lengthLabel.setText("");
            this.energyLabel.setText("");
        } else {
            this.lengthLabel.setText(TrackWidget.floatString(track.getLength()));
            this.energyLabel.setText(TrackWidget.floatString(track.getEnergy()));
        }
        this.invalidate();
    }
}

