/*
 * Decompiled with CFR 0.152.
 */
package visad.data.amanda;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.AnimationControl;
import visad.BaseColorControl;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.Integer1DSet;
import visad.MathType;
import visad.RealType;
import visad.ScalarMap;
import visad.ShapeControl;
import visad.VisADException;
import visad.data.amanda.AmandaFile;
import visad.data.amanda.EventWidget;
import visad.data.amanda.F2000Util;
import visad.data.amanda.Hit;
import visad.java3d.DisplayImplJ3D;
import visad.util.AnimationWidget;
import visad.util.CmdlineConsumer;
import visad.util.CmdlineParser;
import visad.util.LabeledColorWidget;

public class NuView
extends WindowAdapter
implements CmdlineConsumer {
    private String fileName;
    private DisplayImpl display;

    public NuView(String[] args) throws RemoteException, VisADException {
        AnimationWidget animWidget;
        CmdlineParser cmdline = new CmdlineParser(this);
        if (!cmdline.processArgs(args)) {
            System.exit(1);
            return;
        }
        AmandaFile file = NuView.openFile(this.fileName);
        this.display = new DisplayImplJ3D("amanda");
        double halfRange = NuView.getMaxRange(file) / 2.0;
        ScalarMap xMap = new ScalarMap(RealType.XAxis, Display.XAxis);
        NuView.setRange(xMap, file.getXMin(), file.getXMax(), halfRange);
        this.display.addMap(xMap);
        ScalarMap yMap = new ScalarMap(RealType.YAxis, Display.YAxis);
        NuView.setRange(yMap, file.getYMin(), file.getYMax(), halfRange);
        this.display.addMap(yMap);
        ScalarMap zMap = new ScalarMap(RealType.ZAxis, Display.ZAxis);
        NuView.setRange(zMap, file.getZMin(), file.getZMax(), halfRange);
        this.display.addMap(zMap);
        ScalarMap shapeMap = new ScalarMap(Hit.amplitudeType, Display.Shape);
        this.display.addMap(shapeMap);
        ShapeControl sctl = (ShapeControl)shapeMap.getControl();
        sctl.setShapeSet(new Integer1DSet((MathType)Hit.amplitudeType, 1));
        sctl.setShapes(F2000Util.getCubeArray());
        ScalarMap shapeScaleMap = new ScalarMap(Hit.amplitudeType, Display.ShapeScale);
        this.display.addMap(shapeScaleMap);
        shapeScaleMap.setRange(-20.0, 50.0);
        ScalarMap colorMap = new ScalarMap(Hit.leadingEdgeTimeType, Display.RGB);
        this.display.addMap(colorMap);
        BaseColorControl colorCtl = (BaseColorControl)colorMap.getControl();
        int numColors = colorCtl.getNumberOfColors();
        int numComps = colorCtl.getNumberOfComponents();
        float[][] table = colorCtl.getTable();
        int i = 0;
        while (i < numColors / 2) {
            int swaploc = numColors - (i + 1);
            int j = 0;
            while (j < numComps) {
                float tmp = table[j][i];
                table[j][i] = table[j][swaploc];
                table[j][swaploc] = tmp;
                ++j;
            }
            ++i;
        }
        colorCtl.setTable(table);
        ScalarMap animMap = new ScalarMap(RealType.Time, Display.Animation);
        this.display.addMap(animMap);
        DisplayRenderer displayRenderer = this.display.getDisplayRenderer();
        displayRenderer.setBoxOn(false);
        DataReferenceImpl eventRef = new DataReferenceImpl("event");
        this.display.addReference(eventRef);
        DataReferenceImpl modulesRef = new DataReferenceImpl("modules");
        modulesRef.setData(file.makeModuleData());
        this.display.addReference(modulesRef);
        LabeledColorWidget colorWidget = new LabeledColorWidget(colorMap);
        colorWidget.setAlignmentX(0.0f);
        AnimationControl animCtl = (AnimationControl)((Object)animMap.getControl());
        EventWidget eventWidget = new EventWidget(file, eventRef, animCtl);
        try {
            animWidget = new AnimationWidget(animMap);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            animWidget = null;
        }
        JPanel widgetPanel = new JPanel();
        widgetPanel.setLayout(new BoxLayout(widgetPanel, 1));
        widgetPanel.setMaximumSize(new Dimension(400, 600));
        widgetPanel.add(colorWidget);
        widgetPanel.add(eventWidget);
        if (animWidget != null) {
            widgetPanel.add(animWidget);
        }
        widgetPanel.add(Box.createHorizontalGlue());
        JPanel displayPanel = (JPanel)this.display.getComponent();
        Dimension dim = new Dimension(800, 800);
        displayPanel.setPreferredSize(dim);
        displayPanel.setMinimumSize(dim);
        widgetPanel.setAlignmentX(displayPanel.getAlignmentX());
        widgetPanel.setAlignmentY(displayPanel.getAlignmentY());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(widgetPanel);
        panel.add(displayPanel);
        JFrame frame = new JFrame("VisAD AMANDA Viewer");
        frame.addWindowListener(this);
        frame.getContentPane().add(panel);
        frame.pack();
        panel.invalidate();
        Dimension fSize = frame.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)frame).setLocation((screenSize.width - fSize.width) / 2, (screenSize.height - fSize.height) / 2);
        ((Component)frame).setVisible(true);
    }

    public int checkKeyword(String mainName, int thisArg, String[] args) {
        if (this.fileName == null) {
            this.fileName = args[thisArg];
            return 1;
        }
        return 0;
    }

    public int checkOption(String mainName, char ch, String arg) {
        return 0;
    }

    public boolean finalizeArgs(String mainName) {
        if (this.fileName == null) {
            System.err.println(mainName + ": No file specified!");
            return false;
        }
        return true;
    }

    private static final double getMaxRange(AmandaFile file) {
        double xRange = file.getXMax() - file.getXMin();
        double yRange = file.getYMax() - file.getYMin();
        double zRange = file.getZMax() - file.getZMin();
        return -0.5 * Math.max(xRange, Math.max(yRange, zRange));
    }

    public void initializeArgs() {
        this.fileName = null;
    }

    private static final AmandaFile openFile(String fileName) throws VisADException {
        AmandaFile file;
        try {
            file = fileName.startsWith("http://") ? new AmandaFile(new URL(fileName)) : new AmandaFile(fileName);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new VisADException(ioe.getMessage());
        }
        return file;
    }

    public String keywordUsage() {
        return " fileName";
    }

    public String optionUsage() {
        return " [-o(ldData)]";
    }

    private static final void setRange(ScalarMap map, double min, double max, double halfRange) throws RemoteException, VisADException {
        double mid = (min + max) / 2.0;
        map.setRange(mid - halfRange, mid + halfRange);
    }

    public void windowClosing(WindowEvent evt) {
        try {
            this.display.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }

    public static void main(String[] args) throws RemoteException, VisADException {
        new NuView(args);
    }
}

