/*
 * Decompiled with CFR 0.152.
 */
package visad.data.amanda;

import java.rmi.RemoteException;
import visad.Data;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.Integer1DSet;
import visad.MathType;
import visad.RealTuple;
import visad.RealType;
import visad.VisADException;
import visad.data.amanda.EventList;
import visad.data.amanda.Hit;

public class Hits
extends EventList {
    public static FunctionType functionType;
    public static FunctionType timeSequenceType;
    public static FieldImpl missing;
    public static final RealType indexType;
    private static final int MIN_TIMESTEPS = 20;
    private static final int MAX_TIMESTEPS = 50;
    private static FunctionType indexTupleType;

    public final void add(Hit hit) {
        super.add(hit);
    }

    public final Hit get(int i) {
        return (Hit)super.internalGet(i);
    }

    final FieldImpl makeTimeSequence() {
        Gridded1DSet set;
        FieldImpl fld;
        FlatField missingFld;
        Integer1DSet subSet;
        int numHits = this.size();
        try {
            subSet = new Integer1DSet((MathType)indexType, numHits);
            missingFld = new FlatField(indexTupleType, subSet);
        }
        catch (VisADException ve) {
            ve.printStackTrace();
            return null;
        }
        float startTime = Float.MAX_VALUE;
        float endTime = Float.MIN_VALUE;
        float minLen = Float.MAX_VALUE;
        int i = 0;
        while (i < numHits) {
            float et;
            float len;
            Hit hit = (Hit)this.internalGet(i);
            float st = hit.getLeadingEdgeTime();
            if (startTime > st) {
                startTime = st;
            }
            if ((len = hit.getTimeOverThreshold()) < minLen) {
                minLen = len;
            }
            if (endTime < (et = st + len)) {
                endTime = et;
            }
            ++i;
        }
        float dist = endTime - startTime;
        int steps = (int)(dist / minLen);
        if (steps < 20) {
            steps = 20;
        } else if (steps > 50) {
            steps = 50;
        }
        float stepLen = dist / (float)steps;
        float[] timeSteps = new float[steps + 1];
        timeSteps[0] = startTime;
        int i2 = 0;
        while (i2 < steps) {
            timeSteps[i2 + 1] = timeSteps[i2] + stepLen;
            ++i2;
        }
        Data[] data = new FlatField[timeSteps.length];
        Data[] rt = new RealTuple[numHits];
        int a = 0;
        while (a < timeSteps.length) {
            int i3 = 0;
            while (i3 < numHits) {
                Hit hit = (Hit)this.internalGet(i3);
                float leadTime = hit.getLeadingEdgeTime();
                rt[i3] = timeSteps[a] < leadTime ? Hit.missing : hit.makeData();
                ++i3;
            }
            try {
                fld = new FlatField(indexTupleType, subSet);
                ((FlatField)fld).setSamples(rt, false);
            }
            catch (VisADException ve) {
                ve.printStackTrace();
                fld = missingFld;
            }
            catch (RemoteException re) {
                re.printStackTrace();
                fld = missingFld;
            }
            data[a] = fld;
            ++a;
        }
        try {
            set = new Gridded1DSet((MathType)RealType.Time, (float[][])new float[][]{timeSteps}, timeSteps.length);
        }
        catch (VisADException ve) {
            ve.printStackTrace();
            set = null;
        }
        try {
            fld = new FieldImpl(timeSequenceType, set);
            fld.setSamples(data, false);
        }
        catch (VisADException ve) {
            ve.printStackTrace();
            fld = null;
        }
        catch (RemoteException re) {
            re.printStackTrace();
            fld = null;
        }
        return fld;
    }

    static {
        indexType = RealType.getRealType("Hits_Index");
        try {
            functionType = new FunctionType(Hit.indexType, Hit.tupleType);
            indexTupleType = new FunctionType(indexType, Hit.tupleType);
            timeSequenceType = new FunctionType(RealType.Time, indexTupleType);
            Gridded1DSet set = new Gridded1DSet((MathType)RealType.Time, new float[1][1], 1);
            missing = new FieldImpl(timeSequenceType, set);
        }
        catch (VisADException ve) {
            ve.printStackTrace();
            functionType = null;
            timeSequenceType = null;
            indexTupleType = null;
            missing = null;
        }
    }
}

