/*
 * Decompiled with CFR 0.152.
 */
package visad.data.amanda;

import java.rmi.RemoteException;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.VisADException;
import visad.data.amanda.Module;
import visad.util.Util;

public class Hit
implements Comparable {
    public static final RealType amplitudeType = RealType.getRealType("Hit_Amplitude");
    public static final RealType indexType = RealType.getRealType("Hit_Index");
    public static final RealType leadingEdgeTimeType = RealType.getRealType("Hit_Leading_Edge_Time");
    public static final RealType moduleType = RealType.getRealType("Hit_Module");
    private static final RealType timeOverThresholdType = RealType.getRealType("Hit_Time_Over_Threshold");
    public static RealTupleType tupleType;
    public static RealTuple missing;
    private Module mod;
    private float amplitude;
    private float leadEdgeTime;
    private float timeOverThreshold;
    private RealTuple data;

    Hit(Module mod, float amplitude, float leadEdgeTime, float timeOverThreshold) {
        this.mod = mod;
        this.amplitude = amplitude;
        this.leadEdgeTime = leadEdgeTime;
        this.timeOverThreshold = timeOverThreshold;
        this.data = null;
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof Hit)) {
            return this.getClass().toString().compareTo(obj.getClass().toString());
        }
        return this.compareTo((Hit)obj);
    }

    public int compareTo(Hit h) {
        if (!Util.isApproximatelyEqual(this.leadEdgeTime, h.leadEdgeTime)) {
            if (this.leadEdgeTime < h.leadEdgeTime) {
                return -1;
            }
            return 1;
        }
        if (!Util.isApproximatelyEqual(this.timeOverThreshold, h.timeOverThreshold)) {
            if (this.timeOverThreshold < h.timeOverThreshold) {
                return -1;
            }
            return 1;
        }
        if (!Util.isApproximatelyEqual(this.amplitude, h.amplitude)) {
            if (this.amplitude < h.amplitude) {
                return -1;
            }
            return 1;
        }
        return this.mod.compareTo(h.mod);
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public final float getAmplitude() {
        return this.amplitude;
    }

    public final float getLeadingEdgeTime() {
        return this.leadEdgeTime;
    }

    public final Module getModule() {
        return this.mod;
    }

    public final float getTimeOverThreshold() {
        return this.timeOverThreshold;
    }

    final RealTuple makeData() {
        if (this.data == null) {
            try {
                this.data = new RealTuple(tupleType, new double[]{this.mod.getNumber(), this.mod.getX(), this.mod.getY(), this.mod.getZ(), this.amplitude, this.leadEdgeTime, this.timeOverThreshold});
            }
            catch (RemoteException re) {
                re.printStackTrace();
                this.data = missing;
            }
            catch (VisADException ve) {
                ve.printStackTrace();
                this.data = missing;
            }
        }
        return this.data;
    }

    public String toString() {
        return "Hit[Mod#" + this.mod.getNumber() + " amp " + this.amplitude + " let " + this.leadEdgeTime + " tot " + this.timeOverThreshold + "]";
    }

    static {
        try {
            tupleType = new RealTupleType(new RealType[]{moduleType, RealType.XAxis, RealType.YAxis, RealType.ZAxis, amplitudeType, leadingEdgeTimeType, timeOverThresholdType});
            missing = new RealTuple(tupleType);
        }
        catch (VisADException ve) {
            ve.printStackTrace();
            tupleType = null;
            missing = null;
        }
    }
}

