/*
 * Decompiled with CFR 0.152.
 */
package visad.data.amanda;

import java.rmi.RemoteException;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import visad.AnimationControl;
import visad.CellImpl;
import visad.DataReferenceImpl;
import visad.FieldImpl;
import visad.Real;
import visad.ScalarMap;
import visad.VisADException;
import visad.data.amanda.AmandaFile;
import visad.data.amanda.Event;
import visad.data.amanda.TrackWidget;
import visad.util.VisADSlider;

public class EventWidget
extends JPanel {
    private AmandaFile fileData;
    private DataReferenceImpl eventRef;
    private AnimationControl animCtl;
    private GregorianCalendar cal;
    private VisADSlider slider;
    private int sliderLength;
    private JLabel dateLabel;
    private TrackWidget trackWidget;
    private Event thisEvent;

    public EventWidget(AmandaFile fileData, DataReferenceImpl eventRef, AnimationControl animCtl) throws RemoteException, VisADException {
        this(fileData, eventRef, animCtl, null);
    }

    public EventWidget(AmandaFile fileData, DataReferenceImpl eventRef, AnimationControl animCtl, ScalarMap trackMap) throws RemoteException, VisADException {
        this.fileData = fileData;
        this.eventRef = eventRef;
        this.animCtl = animCtl;
        this.cal = new GregorianCalendar();
        this.thisEvent = null;
        this.trackWidget = trackMap == null ? null : new TrackWidget(trackMap);
        this.dateLabel = new JLabel();
        this.slider = this.buildSlider(fileData.getNumberOfEvents());
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.slider);
        this.add(this.dateLabel);
        if (this.trackWidget != null) {
            this.add(this.trackWidget);
        }
    }

    private VisADSlider buildSlider(int initialLength) throws RemoteException, VisADException {
        final DataReferenceImpl eventRef = new DataReferenceImpl("event");
        this.sliderLength = initialLength;
        VisADSlider slider = new VisADSlider("event", 0, initialLength - 1, 0, 1.0, eventRef, Event.indexType, true);
        slider.hardcodeSizePercent(110);
        CellImpl cell = new CellImpl(){

            public void doAction() throws RemoteException, VisADException {
                Real r = (Real)eventRef.getData();
                if (r != null) {
                    int index = (int)r.getValue();
                    if (index < 0) {
                        index = 0;
                    } else if (index > EventWidget.this.sliderLength) {
                        index = EventWidget.this.sliderLength;
                    }
                    EventWidget.this.indexChanged(index);
                }
            }
        };
        cell.addReference(eventRef);
        return slider;
    }

    private final Date getDate(int year, int day, double time) {
        int hr = (int)((time + 3599.0) / 3600.0);
        int min = (int)(((time -= (double)hr * 3600.0) + 59.0) / 60.0);
        int sec = (int)(time -= (double)min * 60.0);
        int milli = (int)((time -= (double)sec) * 1000.0);
        this.cal.clear();
        this.cal.set(1, year);
        this.cal.set(6, day);
        this.cal.set(11, hr);
        this.cal.set(12, min);
        this.cal.set(13, sec);
        this.cal.set(14, milli);
        this.cal.set(16, 0);
        return this.cal.getTime();
    }

    public final Event getEvent() {
        return this.thisEvent;
    }

    public final JLabel getLabel() {
        return this.dateLabel;
    }

    public final VisADSlider getSlider() {
        return this.slider;
    }

    public final TrackWidget getTrackWidget() {
        return this.trackWidget;
    }

    private void indexChanged(int index) throws RemoteException, VisADException {
        this.thisEvent = this.fileData.getEvent(index);
        if (this.thisEvent == null) {
            this.eventRef.setData(Event.missing);
            this.dateLabel.setText("*** NO DATE ***");
        } else {
            FieldImpl seq = this.thisEvent.makeTimeSequence();
            this.eventRef.setData(seq);
            this.animCtl.setSet(seq.getDomainSet());
            this.dateLabel.setText(this.getDate(this.thisEvent.getYear(), this.thisEvent.getDay(), this.thisEvent.getTime()).toGMTString());
        }
        if (this.trackWidget != null) {
            this.trackWidget.setEvent(this.thisEvent);
        }
        this.invalidate();
    }
}

