/*
 * Decompiled with CFR 0.152.
 */
package visad.data.amanda;

import java.io.PrintStream;
import visad.Data;
import visad.FieldImpl;
import visad.MathType;
import visad.RealType;
import visad.TupleType;
import visad.VisADException;
import visad.data.amanda.BaseTrack;
import visad.data.amanda.FitTrack;
import visad.data.amanda.Hit;
import visad.data.amanda.Hits;
import visad.data.amanda.MCTrack;
import visad.data.amanda.Tracks;

public class Event {
    public static final RealType indexType = RealType.getRealType("Event_Index");
    public static TupleType tupleType;
    public static Data missing;
    private int number;
    private int run;
    private int year;
    private int day;
    private double time;
    private double timeShift;
    private Hits hits;
    private Tracks tracks;

    Event(int number, int run, int year, int day, double time, double timeShift) {
        this.number = number;
        this.run = run;
        this.year = year;
        this.day = day;
        this.time = time;
        this.timeShift = timeShift;
        this.hits = new Hits();
        this.tracks = new Tracks();
    }

    final void add(Hit hit) {
        this.hits.add(hit);
    }

    final void add(FitTrack track) {
        this.tracks.add(track);
    }

    final void add(MCTrack track) {
        this.tracks.add(track);
    }

    final void dump(PrintStream out) {
        out.println(this);
        this.hits.dump(out);
        this.tracks.dump(out);
    }

    public final int getDay() {
        return this.day;
    }

    public final int getNumber() {
        return this.number;
    }

    public final int getRun() {
        return this.run;
    }

    public final double getTime() {
        return this.time;
    }

    public final double getTimeShift() {
        return this.timeShift;
    }

    public final BaseTrack getTrack(int idx) {
        return this.tracks.get(idx);
    }

    public final int getYear() {
        return this.year;
    }

    public final FieldImpl makeTimeSequence() {
        return this.hits.makeTimeSequence();
    }

    public String toString() {
        return "Event#" + this.number + "[Y" + this.year + "D" + this.day + " H" + this.hits + " T" + this.tracks + "]";
    }

    static {
        missing = Hits.missing;
        try {
            tupleType = new TupleType(new MathType[]{Tracks.functionType, Hits.functionType});
        }
        catch (VisADException ve) {
            ve.printStackTrace();
            tupleType = null;
        }
    }
}

