/*
 * Decompiled with CFR 0.152.
 */
package visad.data.amanda;

import java.rmi.RemoteException;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded3DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.VisADException;
import visad.data.amanda.AmandaFile;

public abstract class BaseTrack {
    public static final RealType indexType = RealType.getRealType("Track_Index");
    private static final RealType energyType = RealType.getRealType("Track_Energy");
    public static FunctionType functionType;
    private static final float LENGTH_SCALE = 1000.0f;
    private float xstart;
    private float ystart;
    private float zstart;
    private float zenith;
    private float azimuth;
    private float length;
    private float energy;
    private float time;
    private float maxLength;

    BaseTrack(float xstart, float ystart, float zstart, float zenith, float azimuth, float length, float energy, float time) {
        this.xstart = xstart;
        this.ystart = ystart;
        this.zstart = zstart;
        this.zenith = zenith;
        this.azimuth = azimuth;
        this.length = length;
        this.energy = energy;
        this.time = time;
    }

    public final float getEnergy() {
        return this.energy;
    }

    public final float getLength() {
        return this.length;
    }

    abstract FlatField makeData() throws VisADException;

    final FlatField makeData(float maxLength) throws VisADException {
        float fldLength = this.length;
        if (fldLength > maxLength) {
            fldLength = maxLength;
        } else if (fldLength != fldLength) {
            fldLength = -1.0f;
        }
        float fldEnergy = this.energy;
        if (fldEnergy != fldEnergy) {
            fldEnergy = 1.0f;
        }
        float zs = (float)Math.sin((double)this.zenith * (Math.PI / 180));
        float zc = (float)Math.cos((double)this.zenith * (Math.PI / 180));
        float as = (float)Math.sin((double)this.azimuth * (Math.PI / 180));
        float ac = (float)Math.cos((double)this.azimuth * (Math.PI / 180));
        float zinc = fldLength * zc;
        float xinc = fldLength * zs * ac;
        float yinc = fldLength * zs * as;
        float[][] locs = new float[][]{{this.xstart - 1000.0f * xinc, this.xstart + 1000.0f * xinc}, {this.ystart - 1000.0f * yinc, this.ystart + 1000.0f * yinc}, {this.zstart - 1000.0f * zinc, this.zstart + 1000.0f * zinc}};
        Gridded3DSet set = new Gridded3DSet((MathType)AmandaFile.xyzType, (float[][])locs, 2);
        FlatField field = new FlatField(functionType, set);
        float[][] values = new float[][]{{this.time, this.time}, {fldEnergy, fldEnergy}};
        try {
            field.setSamples(values, false);
        }
        catch (RemoteException re) {
            re.printStackTrace();
            return null;
        }
        return field;
    }

    public String toString() {
        String fullName = this.getClass().getName();
        int pt = fullName.lastIndexOf(46);
        int ds = fullName.lastIndexOf(36);
        if (ds > pt) {
            pt = ds;
        }
        String className = fullName.substring(pt == -1 ? 0 : pt + 1);
        return className + "[" + this.xstart + "," + this.ystart + "," + this.zstart + " LA#" + this.zenith + " LO#" + this.azimuth + "]";
    }

    static {
        try {
            functionType = new FunctionType(AmandaFile.xyzType, new RealTupleType(RealType.Time, energyType));
        }
        catch (VisADException ve) {
            ve.printStackTrace();
            functionType = null;
        }
    }
}

