/*
 * Decompiled with CFR 0.152.
 */
package visad.cluster;

import java.awt.image.BufferedImage;
import java.rmi.RemoteException;
import visad.Control;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.FieldImpl;
import visad.GraphicsModeControl;
import visad.Gridded3DSet;
import visad.MathType;
import visad.Set;
import visad.SetType;
import visad.ShadowType;
import visad.VisADAppearance;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADGroup;
import visad.VisADSwitch;
import visad.cluster.NodeRendererJ3D;
import visad.cluster.RemoteNodePartitionedFieldImpl;
import visad.java3d.ShadowFunctionTypeJ3D;

public class ShadowNodeFunctionTypeJ3D
extends ShadowFunctionTypeJ3D {
    public ShadowNodeFunctionTypeJ3D(MathType t, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        super(t, link, parent);
    }

    public boolean doTransform(Object group, Data data, float[] value_array, float[] default_values, DataRenderer renderer) throws VisADException, RemoteException {
        FieldImpl adaptedField;
        Set set;
        int resolution;
        Data new_data = data;
        if (renderer instanceof NodeRendererJ3D && data instanceof RemoteNodePartitionedFieldImpl && (resolution = ((NodeRendererJ3D)renderer).getResolution()) > 1 && (set = (adaptedField = ((RemoteNodePartitionedFieldImpl)data).getAdaptedField()).getDomainSet()) instanceof Gridded3DSet && set.getManifoldDimension() == 3) {
            Gridded3DSet domain_set = (Gridded3DSet)set;
            float[][] samples = domain_set.getSamples(false);
            int x_len = domain_set.getLength(0);
            int y_len = domain_set.getLength(1);
            int z_len = domain_set.getLength(2);
            int len = domain_set.getLength();
            int new_x_len = 1 + (x_len - 1) / resolution;
            int new_y_len = 1 + (y_len - 1) / resolution;
            int new_z_len = 1 + (z_len - 1) / resolution;
            int new_len = new_x_len * new_y_len * new_z_len;
            float[][] new_samples = new float[3][new_len];
            int x = 0;
            while (x < new_x_len) {
                int i = x * resolution;
                int y = 0;
                while (y < new_y_len) {
                    int j = y * resolution;
                    int z = 0;
                    while (z < new_z_len) {
                        int k = z * resolution;
                        int ijk = i + x_len * (j + y_len * k);
                        int xyz = x + new_x_len * (y + new_y_len * z);
                        new_samples[0][xyz] = samples[0][ijk];
                        new_samples[1][xyz] = samples[1][ijk];
                        new_samples[2][xyz] = samples[2][ijk];
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            SetType domain_type = (SetType)domain_set.getType();
            Gridded3DSet new_domain_set = new Gridded3DSet((MathType)domain_type, new_samples, new_x_len, new_y_len, new_z_len, domain_set.getCoordinateSystem(), domain_set.getSetUnits(), null);
            FieldImpl newAdaptedField = (FieldImpl)adaptedField.resample(new_domain_set);
            new_data = new RemoteNodePartitionedFieldImpl(newAdaptedField);
        }
        return super.doTransform(group, new_data, value_array, default_values, renderer);
    }

    public void textureToGroup(Object group, VisADGeometryArray array, BufferedImage image, GraphicsModeControl mode, float constant_alpha, float[] constant_color, int texture_width, int texture_height) throws VisADException {
        VisADAppearance appearance = ShadowNodeFunctionTypeJ3D.makeAppearance(mode, constant_alpha, constant_color, array);
        appearance.image = null;
        appearance.image_type = image.getType();
        appearance.image_width = image.getWidth();
        appearance.image_height = image.getHeight();
        appearance.image_pixels = image.getRGB(0, 0, appearance.image_width, appearance.image_height, null, 0, appearance.image_width);
        ((VisADGroup)group).addChild(appearance);
        appearance.texture_width = texture_width;
        appearance.texture_height = texture_height;
    }

    public void texture3DToGroup(Object group, VisADGeometryArray arrayX, VisADGeometryArray arrayY, VisADGeometryArray arrayZ, VisADGeometryArray arrayXrev, VisADGeometryArray arrayYrev, VisADGeometryArray arrayZrev, BufferedImage[] images, GraphicsModeControl mode, float constant_alpha, float[] constant_color, int texture_width, int texture_height, int texture_depth, DataRenderer renderer) throws VisADException {
    }

    public void textureStackToGroup(Object group, VisADGeometryArray arrayX, VisADGeometryArray arrayY, VisADGeometryArray arrayZ, VisADGeometryArray arrayXrev, VisADGeometryArray arrayYrev, VisADGeometryArray arrayZrev, BufferedImage[] imagesX, BufferedImage[] imagesY, BufferedImage[] imagesZ, GraphicsModeControl mode, float constant_alpha, float[] constant_color, int texture_width, int texture_height, int texture_depth, DataRenderer renderer) throws VisADException {
        VisADGeometryArray[] geometryX = this.makeVisADGeometrys(arrayX);
        VisADGeometryArray[] geometryY = this.makeVisADGeometrys(arrayY);
        VisADGeometryArray[] geometryZ = this.makeVisADGeometrys(arrayZ);
        VisADGroup branchX = new VisADGroup();
        int data_depth = geometryX.length;
        int i = 0;
        while (i < data_depth) {
            VisADAppearance appearance = ShadowNodeFunctionTypeJ3D.makeAppearance(mode, constant_alpha, constant_color, geometryX[i]);
            appearance.image = null;
            appearance.image_type = imagesX[i].getType();
            appearance.image_width = imagesX[i].getWidth();
            appearance.image_height = imagesX[i].getHeight();
            appearance.image_pixels = imagesX[i].getRGB(0, 0, appearance.image_width, appearance.image_height, null, 0, appearance.image_width);
            appearance.texture_width = imagesX[i].getWidth();
            appearance.texture_height = imagesX[i].getHeight();
            branchX.addChild(appearance);
            ++i;
        }
        VisADGroup branchY = new VisADGroup();
        int data_height = geometryY.length;
        int i2 = 0;
        while (i2 < data_height) {
            VisADAppearance appearance = ShadowNodeFunctionTypeJ3D.makeAppearance(mode, constant_alpha, constant_color, geometryY[i2]);
            appearance.image = null;
            appearance.image_type = imagesY[i2].getType();
            appearance.image_width = imagesY[i2].getWidth();
            appearance.image_height = imagesY[i2].getHeight();
            appearance.image_pixels = imagesY[i2].getRGB(0, 0, appearance.image_width, appearance.image_height, null, 0, appearance.image_width);
            appearance.texture_width = imagesY[i2].getWidth();
            appearance.texture_height = imagesY[i2].getHeight();
            branchY.addChild(appearance);
            ++i2;
        }
        VisADGroup branchZ = new VisADGroup();
        int data_width = geometryZ.length;
        int i3 = 0;
        while (i3 < data_width) {
            VisADAppearance appearance = ShadowNodeFunctionTypeJ3D.makeAppearance(mode, constant_alpha, constant_color, geometryZ[i3]);
            appearance.image = null;
            appearance.image_type = imagesZ[i3].getType();
            appearance.image_width = imagesZ[i3].getWidth();
            appearance.image_height = imagesZ[i3].getHeight();
            appearance.image_pixels = imagesZ[i3].getRGB(0, 0, appearance.image_width, appearance.image_height, null, 0, appearance.image_width);
            appearance.texture_width = imagesZ[i3].getWidth();
            appearance.texture_height = imagesZ[i3].getHeight();
            branchZ.addChild(appearance);
            ++i3;
        }
        VisADSwitch swit = (VisADSwitch)this.makeSwitch();
        swit.addChild(branchX);
        swit.addChild(branchY);
        swit.addChild(branchZ);
        swit.setSet(null);
        VisADGroup branch = new VisADGroup();
        branch.addChild(swit);
        if (((VisADGroup)group).numChildren() > 0) {
            ((VisADGroup)group).setChild(branch, 0);
        } else {
            ((VisADGroup)group).addChild(branch);
        }
    }

    public Object makeSwitch() {
        return new VisADSwitch();
    }

    public Object makeBranch() {
        VisADGroup branch = new VisADGroup();
        return branch;
    }

    public void addToGroup(Object group, Object branch) throws VisADException {
        ((VisADGroup)group).addChild((VisADGroup)branch);
    }

    public void addToSwitch(Object swit, Object branch) throws VisADException {
        ((VisADSwitch)swit).addChild((VisADGroup)branch);
    }

    public void addSwitch(Object group, Object swit, Control control, Set domain_set, DataRenderer renderer) throws VisADException {
        ((VisADSwitch)swit).setSet(domain_set);
        ((VisADGroup)group).addChild((VisADSwitch)swit);
    }

    public boolean wantIndexed() {
        return false;
    }

    public boolean addToGroup(Object group, VisADGeometryArray array, GraphicsModeControl mode, float constant_alpha, float[] constant_color) throws VisADException {
        return ShadowNodeFunctionTypeJ3D.staticAddToGroup(group, array, mode, constant_alpha, constant_color);
    }

    public static boolean staticAddToGroup(Object group, VisADGeometryArray array, GraphicsModeControl mode, float constant_alpha, float[] constant_color) throws VisADException {
        if (array != null) {
            VisADAppearance appearance = ShadowNodeFunctionTypeJ3D.makeAppearance(mode, constant_alpha, constant_color, array);
            ((VisADGroup)group).addChild(appearance);
            return true;
        }
        return false;
    }

    static VisADAppearance makeAppearance(GraphicsModeControl mode, float constant_alpha, float[] constant_color, VisADGeometryArray array) {
        VisADAppearance appearance = new VisADAppearance();
        appearance.pointSize = mode.getPointSize();
        appearance.lineWidth = mode.getLineWidth();
        appearance.alpha = constant_alpha;
        if (constant_color != null && constant_color.length == 3) {
            appearance.color_flag = true;
            appearance.red = constant_color[0];
            appearance.green = constant_color[1];
            appearance.blue = constant_color[2];
        }
        appearance.array = array;
        return appearance;
    }
}

