/*
 * Decompiled with CFR 0.152.
 */
package visad.cluster;

import java.rmi.RemoteException;
import visad.CellImpl;
import visad.Data;
import visad.DataImpl;
import visad.DataReferenceImpl;
import visad.DataShadow;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealType;
import visad.ShadowType;
import visad.Tuple;
import visad.VisADException;
import visad.cluster.ClusterException;
import visad.cluster.RemoteClientDataImpl;
import visad.cluster.RemoteClientTuple;

public class RemoteClientTupleImpl
extends RemoteClientDataImpl
implements RemoteClientTuple {
    private Tuple adaptedTuple = null;
    private DataReferenceImpl adaptedTupleRef = null;
    private boolean allReal = false;

    public RemoteClientTupleImpl(Data[] datums) throws VisADException, RemoteException {
        int i;
        if (datums == null) {
            throw new ClusterException("datums cannot be null");
        }
        int n = datums.length;
        if (n == 0) {
            throw new ClusterException("datums.length must be > 0");
        }
        this.allReal = true;
        int i2 = 0;
        while (i2 < n) {
            if (!(datums[i2] instanceof DataImpl) && !(datums[i2] instanceof RemoteClientDataImpl)) {
                throw new ClusterException("datums must be DataImpl or RemoteClientDataImpl");
            }
            if (!(datums[i2] instanceof Real)) {
                this.allReal = false;
            }
            ++i2;
        }
        if (this.allReal) {
            Real[] reals = new Real[n];
            i = 0;
            while (i < n) {
                reals[i] = (Real)datums[i];
                ++i;
            }
            this.adaptedTuple = new RealTuple(reals);
        } else {
            this.adaptedTuple = new Tuple(datums, false);
        }
        boolean any_local = false;
        i = 0;
        while (i < n) {
            if (datums[i] instanceof RemoteClientDataImpl) {
                ((RemoteClientDataImpl)datums[i]).setParent(this);
            } else {
                any_local = true;
            }
            ++i;
        }
        if (any_local) {
            this.adaptedTupleRef = new DataReferenceImpl("adaptedTupleRef");
            this.adaptedTupleRef.setData(this.adaptedTuple);
            CellImpl adaptedTupleCell = new CellImpl(){

                public void doAction() throws VisADException, RemoteException {
                    RemoteClientTupleImpl.this.notifyReferences();
                }
            };
            adaptedTupleCell.addReference(this.adaptedTupleRef);
        }
    }

    public MathType getType() throws VisADException, RemoteException {
        return this.adaptedTuple.getType();
    }

    public Real[] getRealComponents() throws VisADException, RemoteException {
        return this.adaptedTuple.getRealComponents();
    }

    public int getDimension() throws RemoteException {
        return this.adaptedTuple.getDimension();
    }

    public Data getComponent(int i) throws VisADException, RemoteException {
        return this.adaptedTuple.getComponent(i);
    }

    public boolean isMissing() throws RemoteException {
        return this.adaptedTuple.isMissing();
    }

    public DataShadow computeRanges(ShadowType type, DataShadow shadow) throws VisADException, RemoteException {
        return this.adaptedTuple.computeRanges(type, shadow);
    }

    public DataShadow computeRanges(ShadowType type, int n) throws VisADException, RemoteException {
        return this.adaptedTuple.computeRanges(type, n);
    }

    public double[][] computeRanges(RealType[] reals) throws VisADException, RemoteException {
        return this.adaptedTuple.computeRanges(reals);
    }

    public Data adjustSamplingError(Data error, int error_mode) throws VisADException, RemoteException {
        return this.adaptedTuple.adjustSamplingError(error, error_mode);
    }

    public String longString() throws VisADException, RemoteException {
        return this.longString("");
    }

    public String longString(String pre) throws VisADException, RemoteException {
        return pre + "RemoteClientTupleImpl";
    }
}

